/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.executor;

import com.linkedin.kafka.cruisecontrol.executor.ExecutionProposal;
import com.linkedin.kafka.cruisecontrol.executor.ExecutionTaskState;
import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseClass;
import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseField;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@JsonResponseClass
public class ExecutionTask
implements Comparable<ExecutionTask> {
    @JsonResponseField
    private static final String EXECUTION_ID = "executionId";
    @JsonResponseField
    private static final String TYPE = "type";
    @JsonResponseField
    private static final String STATE = "state";
    @JsonResponseField
    private static final String PROPOSAL = "proposal";
    @JsonResponseField
    private static final String BROKER_ID = "brokerId";
    private static final Map<ExecutionTaskState, Set<ExecutionTaskState>> VALID_TRANSFER = new HashMap<ExecutionTaskState, Set<ExecutionTaskState>>();
    private final TaskType _type;
    private final long _executionId;
    private final ExecutionProposal _proposal;
    private final int _brokerId;
    private ExecutionTaskState _state;
    private long _startTimeMs;
    private long _endTimeMs;
    private long _alertTimeMs;
    private boolean _slowExecutionReported;

    public ExecutionTask(long executionId, ExecutionProposal proposal, Integer brokerId, TaskType type, long executionAlertingThresholdMs) {
        if (type != TaskType.INTRA_BROKER_REPLICA_ACTION && brokerId != null) {
            throw new IllegalArgumentException("Broker id is specified for non-intra-broker task.");
        }
        if (executionAlertingThresholdMs <= 0L) {
            throw new IllegalArgumentException(String.format("Non-positive execution alerting threshold %d is set for task %d.", executionAlertingThresholdMs, executionId));
        }
        this._executionId = executionId;
        this._proposal = proposal;
        this._brokerId = brokerId == null ? -1 : brokerId;
        this._state = ExecutionTaskState.PENDING;
        this._type = type;
        this._startTimeMs = -1L;
        this._endTimeMs = -1L;
        this._alertTimeMs = executionAlertingThresholdMs;
        this._slowExecutionReported = false;
    }

    public ExecutionTask(long executionId, ExecutionProposal proposal, TaskType type, long executionAlertingThresholdMs) {
        this(executionId, proposal, null, type, executionAlertingThresholdMs);
    }

    public boolean canTransferToState(ExecutionTaskState targetState) {
        return VALID_TRANSFER.get((Object)this._state).contains((Object)targetState);
    }

    public Set<ExecutionTaskState> validTargetState() {
        return Collections.unmodifiableSet(VALID_TRANSFER.get((Object)this._state));
    }

    public long executionId() {
        return this._executionId;
    }

    public ExecutionProposal proposal() {
        return this._proposal;
    }

    public TaskType type() {
        return this._type;
    }

    public ExecutionTaskState state() {
        return this._state;
    }

    public long startTimeMs() {
        return this._startTimeMs;
    }

    public long endTimeMs() {
        return this._endTimeMs;
    }

    public int brokerId() {
        return this._brokerId;
    }

    public void inProgress(long now) {
        this.ensureValidTransfer(ExecutionTaskState.IN_PROGRESS);
        this._state = ExecutionTaskState.IN_PROGRESS;
        this._startTimeMs = now;
        this._alertTimeMs += now;
    }

    public void kill(long now) {
        this.ensureValidTransfer(ExecutionTaskState.DEAD);
        this._state = ExecutionTaskState.DEAD;
        this._endTimeMs = now;
    }

    public void abort() {
        this.ensureValidTransfer(ExecutionTaskState.ABORTING);
        this._state = ExecutionTaskState.ABORTING;
    }

    public void aborted(long now) {
        this.ensureValidTransfer(ExecutionTaskState.ABORTED);
        this._state = ExecutionTaskState.ABORTED;
        this._endTimeMs = now;
    }

    public void completed(long now) {
        this.ensureValidTransfer(ExecutionTaskState.COMPLETED);
        this._state = ExecutionTaskState.COMPLETED;
        this._endTimeMs = now;
    }

    public void maybeReportExecutionTooSlow(long now, List<ExecutionTask> tasksToReport) {
        if (!(this._slowExecutionReported || this._state != ExecutionTaskState.IN_PROGRESS && this._state != ExecutionTaskState.ABORTING || now <= this._alertTimeMs)) {
            tasksToReport.add(this);
            this._slowExecutionReported = true;
        }
    }

    public boolean equals(Object o) {
        return o instanceof ExecutionTask && this._executionId == ((ExecutionTask)o)._executionId;
    }

    public int hashCode() {
        return (int)this._executionId;
    }

    public Map<String, Object> getJsonStructure() {
        HashMap<String, Object> executionStatsMap = new HashMap<String, Object>();
        executionStatsMap.put(EXECUTION_ID, this._executionId);
        executionStatsMap.put(TYPE, (Object)this._type);
        executionStatsMap.put(STATE, (Object)this._state);
        executionStatsMap.put(PROPOSAL, this._proposal.getJsonStructure());
        if (this._type == TaskType.INTRA_BROKER_REPLICA_ACTION) {
            executionStatsMap.put(BROKER_ID, this._brokerId);
        }
        return executionStatsMap;
    }

    private void ensureValidTransfer(ExecutionTaskState targetState) {
        if (!this.canTransferToState(targetState)) {
            throw new IllegalStateException("Cannot mark a task in " + this._state + " to " + targetState + "state. The valid target state are " + this.validTargetState());
        }
    }

    public String toString() {
        switch (this._type) {
            case INTRA_BROKER_REPLICA_ACTION: {
                return String.format("{EXE_ID: %d, %s(%d), %s, %s}", new Object[]{this._executionId, this._type, this._brokerId, this._proposal, this._state});
            }
            case INTER_BROKER_REPLICA_ACTION: 
            case LEADER_ACTION: {
                return String.format("{EXE_ID: %d, %s, %s, %s}", new Object[]{this._executionId, this._type, this._proposal, this._state});
            }
        }
        throw new IllegalStateException("Unknown task type " + this._type);
    }

    @Override
    public int compareTo(ExecutionTask o) {
        return Long.compare(this._executionId, o._executionId);
    }

    static {
        VALID_TRANSFER.put(ExecutionTaskState.PENDING, new HashSet<ExecutionTaskState>(Collections.singleton(ExecutionTaskState.IN_PROGRESS)));
        VALID_TRANSFER.put(ExecutionTaskState.IN_PROGRESS, new HashSet<ExecutionTaskState>(Arrays.asList(ExecutionTaskState.ABORTING, ExecutionTaskState.DEAD, ExecutionTaskState.COMPLETED)));
        VALID_TRANSFER.put(ExecutionTaskState.ABORTING, new HashSet<ExecutionTaskState>(Arrays.asList(ExecutionTaskState.ABORTED, ExecutionTaskState.DEAD)));
        VALID_TRANSFER.put(ExecutionTaskState.COMPLETED, Collections.emptySet());
        VALID_TRANSFER.put(ExecutionTaskState.DEAD, Collections.emptySet());
        VALID_TRANSFER.put(ExecutionTaskState.ABORTED, Collections.emptySet());
    }

    public static enum TaskType {
        INTER_BROKER_REPLICA_ACTION,
        INTRA_BROKER_REPLICA_ACTION,
        LEADER_ACTION;

        private static final List<TaskType> CACHED_VALUES;

        public static List<TaskType> cachedValues() {
            return CACHED_VALUES;
        }

        static {
            CACHED_VALUES = Collections.unmodifiableList(Arrays.asList(TaskType.values()));
        }
    }
}

