/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.executor;

import com.linkedin.kafka.cruisecontrol.model.ReplicaPlacementInfo;
import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseClass;
import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseField;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;

@JsonResponseClass
public class ExecutionProposal {
    @JsonResponseField
    private static final String TOPIC_PARTITION = "topicPartition";
    @JsonResponseField
    private static final String OLD_LEADER = "oldLeader";
    @JsonResponseField
    private static final String OLD_REPLICAS = "oldReplicas";
    @JsonResponseField
    private static final String NEW_REPLICAS = "newReplicas";
    private final TopicPartition _tp;
    private final long _partitionSize;
    private final ReplicaPlacementInfo _oldLeader;
    private final List<ReplicaPlacementInfo> _oldReplicas;
    private final List<ReplicaPlacementInfo> _newReplicas;
    private final Set<ReplicaPlacementInfo> _replicasToAdd;
    private final Set<ReplicaPlacementInfo> _replicasToRemove;
    private final Map<Integer, ReplicaPlacementInfo> _replicasToMoveBetweenDisksByBroker;

    public ExecutionProposal(TopicPartition tp, long partitionSize, ReplicaPlacementInfo oldLeader, List<ReplicaPlacementInfo> oldReplicas, List<ReplicaPlacementInfo> newReplicas) {
        this._tp = tp;
        this._partitionSize = partitionSize;
        this._oldLeader = oldLeader;
        this._oldReplicas = oldReplicas == null ? Collections.emptyList() : oldReplicas;
        this._newReplicas = newReplicas;
        this.validate();
        Set newBrokerList = this._newReplicas.stream().mapToInt(ReplicaPlacementInfo::brokerId).boxed().collect(Collectors.toSet());
        Set oldBrokerList = this._oldReplicas.stream().mapToInt(ReplicaPlacementInfo::brokerId).boxed().collect(Collectors.toSet());
        this._replicasToAdd = this._newReplicas.stream().filter(r -> !oldBrokerList.contains(r.brokerId())).collect(Collectors.toSet());
        this._replicasToRemove = this._oldReplicas.stream().filter(r -> !newBrokerList.contains(r.brokerId())).collect(Collectors.toSet());
        this._replicasToMoveBetweenDisksByBroker = new HashMap<Integer, ReplicaPlacementInfo>();
        newReplicas.stream().filter(r -> !this._replicasToAdd.contains(r) && !this._oldReplicas.contains(r)).forEach(r -> this._replicasToMoveBetweenDisksByBroker.put(r.brokerId(), (ReplicaPlacementInfo)r));
        if (!this._replicasToAdd.isEmpty() && !this._replicasToMoveBetweenDisksByBroker.isEmpty()) {
            throw new IllegalArgumentException("Change from " + this._oldReplicas + " to " + this._newReplicas + " will generate both intra-broker and inter-broker replica movements.");
        }
    }

    private boolean brokerOrderMatched(Node[] currentOrderedReplicas, List<ReplicaPlacementInfo> replicas) {
        if (replicas.size() != currentOrderedReplicas.length) {
            return false;
        }
        for (int i = 0; i < replicas.size(); ++i) {
            if (currentOrderedReplicas[i].id() == replicas.get(i).brokerId().intValue()) continue;
            return false;
        }
        return true;
    }

    public boolean isInterBrokerMovementCompleted(PartitionInfo partitionInfo) {
        return this.brokerOrderMatched(partitionInfo.replicas(), this._newReplicas) && partitionInfo.replicas().length == partitionInfo.inSyncReplicas().length;
    }

    public boolean isInterBrokerMovementAborted(PartitionInfo partitionInfo) {
        return this.isInterBrokerMovementCompleted(partitionInfo) || this.brokerOrderMatched(partitionInfo.replicas(), this._oldReplicas);
    }

    public String topic() {
        return this._tp.topic();
    }

    public int partitionId() {
        return this._tp.partition();
    }

    public TopicPartition topicPartition() {
        return this._tp;
    }

    public ReplicaPlacementInfo oldLeader() {
        return this._oldLeader;
    }

    public ReplicaPlacementInfo newLeader() {
        return this._newReplicas.get(0);
    }

    public List<ReplicaPlacementInfo> oldReplicas() {
        return this._oldReplicas;
    }

    public List<ReplicaPlacementInfo> newReplicas() {
        return this._newReplicas;
    }

    public Set<ReplicaPlacementInfo> replicasToAdd() {
        return this._replicasToAdd;
    }

    public Set<ReplicaPlacementInfo> replicasToRemove() {
        return this._replicasToRemove;
    }

    public Map<Integer, ReplicaPlacementInfo> replicasToMoveBetweenDisksByBroker() {
        return this._replicasToMoveBetweenDisksByBroker;
    }

    public boolean hasReplicaAction() {
        return !new HashSet<ReplicaPlacementInfo>(this._oldReplicas).equals(new HashSet<ReplicaPlacementInfo>(this._newReplicas));
    }

    public boolean hasLeaderAction() {
        return this._oldLeader != this._newReplicas.get(0);
    }

    public long interBrokerDataToMoveInMB() {
        return (long)this._replicasToAdd.size() * this._partitionSize;
    }

    public long intraBrokerDataToMoveInMB() {
        return this._partitionSize;
    }

    public long dataToMoveInMB() {
        return (long)(this._replicasToAdd.size() + this._replicasToMoveBetweenDisksByBroker.size()) * this._partitionSize;
    }

    private void validate() {
        if (this._oldLeader.brokerId() >= 0 && !this._oldReplicas.contains(this._oldLeader)) {
            throw new IllegalArgumentException(String.format("The old leader %s does not exist in the old replica list %s", this._oldLeader, this._oldReplicas));
        }
        if (this._newReplicas == null || this._newReplicas.isEmpty()) {
            throw new IllegalArgumentException("The new replica list " + this._newReplicas + " cannot be empty.");
        }
        HashSet<ReplicaPlacementInfo> checkSet = new HashSet<ReplicaPlacementInfo>(this._newReplicas);
        if (checkSet.size() != this._newReplicas.size()) {
            throw new IllegalArgumentException("The new replicas list " + this._newReplicas + " has duplicate replica.");
        }
    }

    public Map<String, Object> getJsonStructure() {
        HashMap<String, Object> proposalMap = new HashMap<String, Object>(4);
        proposalMap.put(TOPIC_PARTITION, this._tp);
        proposalMap.put(OLD_LEADER, this._oldLeader.brokerId());
        proposalMap.put(OLD_REPLICAS, this._oldReplicas.stream().mapToInt(ReplicaPlacementInfo::brokerId).boxed().collect(Collectors.toList()));
        proposalMap.put(NEW_REPLICAS, this._newReplicas.stream().mapToInt(ReplicaPlacementInfo::brokerId).boxed().collect(Collectors.toList()));
        return proposalMap;
    }

    public String toString() {
        return String.format("{%s, oldLeader: %d, %s -> %s}", this._tp, this._oldLeader.brokerId(), this._oldReplicas.stream().mapToInt(ReplicaPlacementInfo::brokerId).boxed().collect(Collectors.toList()), this._newReplicas.stream().mapToInt(ReplicaPlacementInfo::brokerId).boxed().collect(Collectors.toList()));
    }

    public boolean equals(Object other) {
        if (!(other instanceof ExecutionProposal)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        ExecutionProposal otherProposal = (ExecutionProposal)other;
        return this._tp.equals((Object)otherProposal._tp) && this._oldLeader == otherProposal._oldLeader && this._oldReplicas.equals(otherProposal._oldReplicas) && this._newReplicas.equals(otherProposal._newReplicas);
    }

    public int hashCode() {
        int result = this._tp.hashCode();
        result = 31 * result + this._oldLeader.hashCode();
        for (ReplicaPlacementInfo replica : this._oldReplicas) {
            result = 31 * result + replica.hashCode();
        }
        for (ReplicaPlacementInfo replica : this._newReplicas) {
            result = 31 * replica.hashCode();
        }
        return result;
    }
}

