/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.detector.notifier;

import com.linkedin.cruisecontrol.detector.AnomalyType;
import com.linkedin.kafka.cruisecontrol.detector.BrokerFailures;
import com.linkedin.kafka.cruisecontrol.detector.DiskFailures;
import com.linkedin.kafka.cruisecontrol.detector.GoalViolations;
import com.linkedin.kafka.cruisecontrol.detector.KafkaMetricAnomaly;
import com.linkedin.kafka.cruisecontrol.detector.MaintenanceEvent;
import com.linkedin.kafka.cruisecontrol.detector.TopicAnomaly;
import com.linkedin.kafka.cruisecontrol.detector.notifier.AnomalyNotificationResult;
import com.linkedin.kafka.cruisecontrol.detector.notifier.AnomalyNotifier;
import com.linkedin.kafka.cruisecontrol.detector.notifier.KafkaAnomalyType;
import java.util.HashMap;
import java.util.Map;

public class NoopNotifier
implements AnomalyNotifier {
    private final Map<AnomalyType, Boolean> _selfHealingEnabled = new HashMap<AnomalyType, Boolean>(KafkaAnomalyType.cachedValues().size());

    public void configure(Map<String, ?> configs) {
        KafkaAnomalyType.cachedValues().forEach(anomalyType -> this._selfHealingEnabled.put((AnomalyType)anomalyType, false));
    }

    @Override
    public AnomalyNotificationResult onGoalViolation(GoalViolations goalViolations) {
        return AnomalyNotificationResult.ignore();
    }

    @Override
    public AnomalyNotificationResult onBrokerFailure(BrokerFailures brokerFailures) {
        return AnomalyNotificationResult.ignore();
    }

    @Override
    public AnomalyNotificationResult onMetricAnomaly(KafkaMetricAnomaly metricAnomaly) {
        return AnomalyNotificationResult.ignore();
    }

    @Override
    public AnomalyNotificationResult onTopicAnomaly(TopicAnomaly topicAnomaly) {
        return AnomalyNotificationResult.ignore();
    }

    @Override
    public AnomalyNotificationResult onMaintenanceEvent(MaintenanceEvent maintenanceEvent) {
        return AnomalyNotificationResult.ignore();
    }

    @Override
    public AnomalyNotificationResult onDiskFailure(DiskFailures diskFailures) {
        return AnomalyNotificationResult.ignore();
    }

    @Override
    public Map<AnomalyType, Boolean> selfHealingEnabled() {
        return this._selfHealingEnabled;
    }

    @Override
    public boolean setSelfHealingFor(AnomalyType anomalyType, boolean isSelfHealingEnabled) {
        return false;
    }

    @Override
    public Map<AnomalyType, Float> selfHealingEnabledRatio() {
        HashMap<AnomalyType, Float> selfHealingEnabledRatio = new HashMap<AnomalyType, Float>(KafkaAnomalyType.cachedValues().size());
        for (AnomalyType anomalyType : KafkaAnomalyType.cachedValues()) {
            selfHealingEnabledRatio.put(anomalyType, Float.valueOf(0.0f));
        }
        return selfHealingEnabledRatio;
    }

    @Override
    public long uptimeMs(long nowMs) {
        return 0L;
    }
}

