/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.detector;

import com.linkedin.kafka.cruisecontrol.detector.MaintenanceEventType;
import com.linkedin.kafka.cruisecontrol.detector.MaintenancePlan;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.kafka.common.utils.Crc32C;

public class TopicReplicationFactorPlan
extends MaintenancePlan {
    public static final byte LATEST_SUPPORTED_VERSION = 0;
    private final Map<Short, String> _topicRegexWithRFUpdate;

    public TopicReplicationFactorPlan(long timeMs, int brokerId, Map<Short, String> topicRegexWithRFUpdate) {
        super(MaintenanceEventType.TOPIC_REPLICATION_FACTOR, timeMs, brokerId, (byte)0);
        if (topicRegexWithRFUpdate == null || topicRegexWithRFUpdate.isEmpty()) {
            throw new IllegalArgumentException("Missing replication factor updates for the plan.");
        }
        if (topicRegexWithRFUpdate.size() > 127) {
            throw new IllegalArgumentException(String.format("Cannot update more than %d different replication factor (attempt: %d).", (byte)127, topicRegexWithRFUpdate.size()));
        }
        for (String regex : topicRegexWithRFUpdate.values()) {
            if (regex != null && !regex.isEmpty()) continue;
            throw new IllegalArgumentException("Missing topics of the replication factor update for the plan.");
        }
        this._topicRegexWithRFUpdate = topicRegexWithRFUpdate;
    }

    public Map<Short, String> topicRegexWithRFUpdate() {
        return this._topicRegexWithRFUpdate;
    }

    @Override
    protected long getCrc() {
        byte numRFUpdateEntries = (byte)this._topicRegexWithRFUpdate.size();
        int requiredCapacityForRFEntries = 0;
        for (Map.Entry<Short, String> entry : this._topicRegexWithRFUpdate.entrySet()) {
            requiredCapacityForRFEntries += 6 + entry.getValue().getBytes(StandardCharsets.UTF_8).length;
        }
        int contentSize = 15 + requiredCapacityForRFEntries;
        ByteBuffer buffer = ByteBuffer.allocate(contentSize);
        buffer.put(this.maintenanceEventType().id());
        buffer.put(this.planVersion());
        buffer.putLong(this.timeMs());
        buffer.putInt(this.brokerId());
        buffer.put(numRFUpdateEntries);
        for (Map.Entry<Short, String> entry : this._topicRegexWithRFUpdate.entrySet()) {
            buffer.putShort(entry.getKey());
            byte[] regex = entry.getValue().getBytes(StandardCharsets.UTF_8);
            buffer.putInt(regex.length);
            buffer.put(regex);
        }
        return Crc32C.compute((ByteBuffer)buffer, (int)(-buffer.position()), (int)contentSize);
    }

    @Override
    public String toString() {
        return String.format("[%s] TopicRegexWithRFUpdate: %s, Source [timeMs: %d, broker: %d]", new Object[]{this._maintenanceEventType, this._topicRegexWithRFUpdate, this._timeMs, this._brokerId});
    }
}

