/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.detector;

import com.linkedin.kafka.cruisecontrol.KafkaCruiseControl;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.detector.AnomalyDetectorUtils;
import com.linkedin.kafka.cruisecontrol.detector.AnomalyUtils;
import com.linkedin.kafka.cruisecontrol.detector.TopicAnomaly;
import com.linkedin.kafka.cruisecontrol.detector.notifier.KafkaAnomalyType;
import com.linkedin.kafka.cruisecontrol.servlet.handler.async.runnable.UpdateTopicConfigurationRunnable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Pattern;

public class TopicReplicationFactorAnomaly
extends TopicAnomaly {
    protected Map<Short, Set<TopicReplicationFactorAnomalyEntry>> _badTopicsByReplicationFactor;
    protected UpdateTopicConfigurationRunnable _updateTopicConfigurationRunnable;

    public boolean fix() throws Exception {
        if (this._updateTopicConfigurationRunnable == null) {
            return false;
        }
        this._optimizationResult = this._updateTopicConfigurationRunnable.getResult();
        boolean hasProposalsToFix = this.hasProposalsToFix();
        this._optimizationResult.discardIrrelevantAndCacheJsonAndPlaintext();
        return hasProposalsToFix;
    }

    @Override
    public void configure(Map<String, ?> configs) {
        super.configure(configs);
        KafkaCruiseControl kafkaCruiseControl = AnomalyUtils.extractKafkaCruiseControlObjectFromConfig(configs, KafkaAnomalyType.TOPIC_ANOMALY);
        KafkaCruiseControlConfig config = kafkaCruiseControl.config();
        this._badTopicsByReplicationFactor = (Map)configs.get("bad.topics.by.replication.factor");
        if (this._badTopicsByReplicationFactor == null || this._badTopicsByReplicationFactor.isEmpty()) {
            throw new IllegalArgumentException(String.format("Missing %s for topic replication factor anomaly.", "bad.topics.by.replication.factor"));
        }
        boolean allowCapacityEstimation = config.getBoolean("anomaly.detection.allow.capacity.estimation");
        boolean excludeRecentlyDemotedBrokers = config.getBoolean("self.healing.exclude.recently.demoted.brokers");
        boolean excludeRecentlyRemovedBrokers = config.getBoolean("self.healing.exclude.recently.removed.brokers");
        Map<Short, Pattern> topicPatternByReplicationFactor = this.populateTopicPatternByReplicationFactor();
        this._updateTopicConfigurationRunnable = new UpdateTopicConfigurationRunnable(kafkaCruiseControl, topicPatternByReplicationFactor, AnomalyDetectorUtils.getSelfHealingGoalNames(config), allowCapacityEstimation, excludeRecentlyDemotedBrokers, excludeRecentlyRemovedBrokers, this._anomalyId.toString(), this.reasonSupplier());
    }

    protected Map<Short, Pattern> populateTopicPatternByReplicationFactor() {
        HashMap<Short, Pattern> topicPatternByReplicationFactor = new HashMap<Short, Pattern>(this._badTopicsByReplicationFactor.size());
        for (Map.Entry<Short, Set<TopicReplicationFactorAnomalyEntry>> entry : this._badTopicsByReplicationFactor.entrySet()) {
            HashSet<String> topics = new HashSet<String>(entry.getValue().size());
            entry.getValue().forEach(anomaly -> topics.add(anomaly.topicName()));
            topicPatternByReplicationFactor.put(entry.getKey(), AnomalyUtils.buildTopicRegex(topics));
        }
        return topicPatternByReplicationFactor;
    }

    @Override
    public Supplier<String> reasonSupplier() {
        return () -> String.format("Self healing for %s: %s", new Object[]{KafkaAnomalyType.TOPIC_ANOMALY, this});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{Topics with replication factor violations: [");
        this._badTopicsByReplicationFactor.forEach((key, value) -> sb.append(String.format("{With desired RF %d: %s}, ", key, value)));
        sb.setLength(sb.length() - 2);
        sb.append("]}");
        return sb.toString();
    }

    public static class TopicReplicationFactorAnomalyEntry {
        private final String _topicName;
        private final double _violationRatio;

        public TopicReplicationFactorAnomalyEntry(String topicName, double violationRatio) {
            this._topicName = topicName;
            this._violationRatio = violationRatio;
        }

        public String topicName() {
            return this._topicName;
        }

        public double violationRatio() {
            return this._violationRatio;
        }

        public String toString() {
            return String.format("{%s(%.2f)}", this._topicName, this._violationRatio * 100.0);
        }
    }
}

