/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.detector;

import com.linkedin.kafka.cruisecontrol.detector.TopicAnomaly;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.kafka.common.TopicPartition;

public class TopicPartitionSizeAnomaly
extends TopicAnomaly {
    protected Map<TopicPartition, Double> _sizeByPartition;

    public boolean fix() {
        return false;
    }

    @Override
    public void configure(Map<String, ?> configs) {
        super.configure(configs);
        this._sizeByPartition = (Map)configs.get("partitions.with.large.size");
        if (this._sizeByPartition == null || this._sizeByPartition.isEmpty()) {
            throw new IllegalArgumentException(String.format("Missing %s for topic partition size anomaly.", "partitions.with.large.size"));
        }
    }

    @Override
    public Supplier<String> reasonSupplier() {
        return () -> String.format("Self healing for topic partition size anomaly: %s", this);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{Detected following topic partitions having too large size: ");
        for (Map.Entry<TopicPartition, Double> entry : this._sizeByPartition.entrySet()) {
            sb.append(String.format("%s : %f bytes, ", entry.getKey().toString(), entry.getValue()));
        }
        sb.setLength(sb.length() - 2);
        sb.append("}");
        return sb.toString();
    }
}

