/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.detector;

import com.linkedin.cruisecontrol.detector.Anomaly;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControl;
import com.linkedin.kafka.cruisecontrol.detector.AbstractAnomalyDetector;
import com.linkedin.kafka.cruisecontrol.detector.AnomalyDetectionStatus;
import com.linkedin.kafka.cruisecontrol.detector.AnomalyDetectorUtils;
import com.linkedin.kafka.cruisecontrol.detector.TopicAnomalyFinder;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicAnomalyDetector
extends AbstractAnomalyDetector
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(TopicAnomalyDetector.class);
    private final List<TopicAnomalyFinder> _topicAnomalyFinders;

    TopicAnomalyDetector(Queue<Anomaly> anomalies, KafkaCruiseControl kafkaCruiseControl) {
        super(anomalies, kafkaCruiseControl);
        Map<String, Object> configWithCruiseControlObject = Collections.singletonMap("kafka.cruise.control.object", kafkaCruiseControl);
        this._topicAnomalyFinders = kafkaCruiseControl.config().getConfiguredInstances("topic.anomaly.finder.class", TopicAnomalyFinder.class, configWithCruiseControlObject);
    }

    @Override
    public void run() {
        try {
            if (AnomalyDetectorUtils.getAnomalyDetectionStatus(this._kafkaCruiseControl, true) != AnomalyDetectionStatus.READY) {
                return;
            }
            for (TopicAnomalyFinder topicAnomalyFinder : this._topicAnomalyFinders) {
                this._anomalies.addAll(topicAnomalyFinder.topicAnomalies());
            }
        }
        catch (Exception e) {
            LOG.warn("Topic anomaly detector encountered exception: ", (Throwable)e);
        }
        finally {
            LOG.debug("Topic anomaly detection finished.");
        }
    }
}

