/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.detector;

import com.linkedin.kafka.cruisecontrol.KafkaCruiseControl;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.detector.AnomalyDetectorUtils;
import com.linkedin.kafka.cruisecontrol.detector.AnomalyUtils;
import com.linkedin.kafka.cruisecontrol.detector.KafkaMetricAnomaly;
import com.linkedin.kafka.cruisecontrol.detector.notifier.KafkaAnomalyType;
import com.linkedin.kafka.cruisecontrol.exception.KafkaCruiseControlException;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.holder.BrokerEntity;
import com.linkedin.kafka.cruisecontrol.servlet.handler.async.runnable.DemoteBrokerRunnable;
import com.linkedin.kafka.cruisecontrol.servlet.handler.async.runnable.RemoveBrokersRunnable;
import com.linkedin.kafka.cruisecontrol.servlet.response.OptimizationResult;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class SlowBrokers
extends KafkaMetricAnomaly {
    protected RemoveBrokersRunnable _removeBrokersRunnable;
    protected DemoteBrokerRunnable _demoteBrokerRunnable;

    @Override
    public boolean fix() throws KafkaCruiseControlException {
        boolean hasProposalsToFix = false;
        if (!this._fixable.booleanValue()) {
            return hasProposalsToFix;
        }
        if (this._removeBrokersRunnable != null) {
            this._optimizationResult = new OptimizationResult(this._removeBrokersRunnable.computeResult(), null);
            hasProposalsToFix = this.hasProposalsToFix();
            this._optimizationResult.discardIrrelevantAndCacheJsonAndPlaintext();
        } else if (this._demoteBrokerRunnable != null) {
            this._optimizationResult = new OptimizationResult(this._demoteBrokerRunnable.computeResult(), null);
            hasProposalsToFix = this.hasProposalsToFix();
            this._optimizationResult.discardIrrelevantAndCacheJsonAndPlaintext();
        }
        return hasProposalsToFix;
    }

    @Override
    public Supplier<String> reasonSupplier() {
        return () -> String.format("Self healing for slow brokers: %s", this);
    }

    @Override
    public void configure(Map<String, ?> configs) {
        super.configure(configs);
        KafkaCruiseControl kafkaCruiseControl = AnomalyUtils.extractKafkaCruiseControlObjectFromConfig(configs, KafkaAnomalyType.METRIC_ANOMALY);
        if (this._fixable.booleanValue()) {
            Boolean removeSlowBroker = (Boolean)configs.get("remove.slow.broker");
            if (removeSlowBroker == null) {
                throw new IllegalArgumentException(String.format("Missing %s for slow broker anomaly.", "remove.slow.broker"));
            }
            KafkaCruiseControlConfig config = kafkaCruiseControl.config();
            boolean allowCapacityEstimation = config.getBoolean("anomaly.detection.allow.capacity.estimation");
            boolean excludeRecentlyDemotedBrokers = config.getBoolean("self.healing.exclude.recently.demoted.brokers");
            boolean excludeRecentlyRemovedBrokers = config.getBoolean("self.healing.exclude.recently.removed.brokers");
            if (removeSlowBroker.booleanValue()) {
                this._removeBrokersRunnable = new RemoveBrokersRunnable(kafkaCruiseControl, this._brokerEntitiesWithDetectionTimeMs.keySet().stream().mapToInt(BrokerEntity::brokerId).boxed().collect(Collectors.toSet()), AnomalyDetectorUtils.getSelfHealingGoalNames(config), allowCapacityEstimation, excludeRecentlyDemotedBrokers, excludeRecentlyRemovedBrokers, this._anomalyId.toString(), this.reasonSupplier());
            } else {
                this._demoteBrokerRunnable = new DemoteBrokerRunnable(kafkaCruiseControl, this._brokerEntitiesWithDetectionTimeMs.keySet().stream().mapToInt(BrokerEntity::brokerId).boxed().collect(Collectors.toSet()), allowCapacityEstimation, excludeRecentlyDemotedBrokers, this._anomalyId.toString(), this.reasonSupplier());
            }
        }
    }
}

