/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.detector;

import com.linkedin.cruisecontrol.detector.Anomaly;
import com.linkedin.cruisecontrol.detector.metricanomaly.MetricAnomalyFinder;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.ValuesAndExtrapolations;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControl;
import com.linkedin.kafka.cruisecontrol.detector.AbstractAnomalyDetector;
import com.linkedin.kafka.cruisecontrol.detector.AnomalyDetectionStatus;
import com.linkedin.kafka.cruisecontrol.detector.AnomalyDetectorUtils;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.holder.BrokerEntity;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricAnomalyDetector
extends AbstractAnomalyDetector
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(MetricAnomalyDetector.class);
    public static final String METRIC_ANOMALY_DESCRIPTION_OBJECT_CONFIG = "metric.anomaly.description.object";
    public static final String METRIC_ANOMALY_BROKER_ENTITIES_OBJECT_CONFIG = "metric.anomaly.broker.entities.object";
    public static final String METRIC_ANOMALY_FIXABLE_OBJECT_CONFIG = "metric.anomaly.fixable.object";
    private final List<MetricAnomalyFinder> _kafkaMetricAnomalyFinders;

    public MetricAnomalyDetector(Queue<Anomaly> anomalies, KafkaCruiseControl kafkaCruiseControl) {
        super(anomalies, kafkaCruiseControl);
        Map<String, Object> configWithCruiseControlObject = Collections.singletonMap("kafka.cruise.control.object", kafkaCruiseControl);
        this._kafkaMetricAnomalyFinders = kafkaCruiseControl.config().getConfiguredInstances("metric.anomaly.finder.class", MetricAnomalyFinder.class, configWithCruiseControlObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (AnomalyDetectorUtils.getAnomalyDetectionStatus(this._kafkaCruiseControl, true) != AnomalyDetectionStatus.READY) {
                return;
            }
            Map metricsHistoryByBroker = this._kafkaCruiseControl.loadMonitor().brokerMetrics().valuesAndExtrapolations();
            Map<BrokerEntity, ValuesAndExtrapolations> currentMetricsByBroker = this._kafkaCruiseControl.loadMonitor().currentBrokerMetricValues();
            for (MetricAnomalyFinder kafkaMetricAnomalyFinder : this._kafkaMetricAnomalyFinders) {
                this._anomalies.addAll(kafkaMetricAnomalyFinder.metricAnomalies(metricsHistoryByBroker, currentMetricsByBroker));
            }
        }
        catch (Exception e) {
            LOG.warn("Metric Anomaly Detector encountered exception: ", (Throwable)e);
        }
        finally {
            LOG.debug("Metric anomaly detection finished.");
        }
    }
}

