/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.detector;

import com.linkedin.kafka.cruisecontrol.detector.MaintenanceEventType;
import com.linkedin.kafka.cruisecontrol.detector.MaintenancePlan;
import java.nio.ByteBuffer;
import java.util.Set;
import org.apache.kafka.common.utils.Crc32C;

public abstract class MaintenancePlanWithBrokers
extends MaintenancePlan {
    protected final Set<Integer> _brokers;

    public MaintenancePlanWithBrokers(MaintenanceEventType maintenanceEventType, long timeMs, int brokerId, byte planVersion, Set<Integer> brokers) {
        super(maintenanceEventType, timeMs, brokerId, planVersion);
        if (brokers == null || brokers.isEmpty()) {
            throw new IllegalArgumentException("Missing brokers for the plan.");
        }
        this._brokers = brokers;
    }

    @Override
    protected long getCrc() {
        short numBrokers = (short)this._brokers.size();
        int contentSize = 16 + 4 * numBrokers;
        ByteBuffer buffer = ByteBuffer.allocate(contentSize);
        buffer.put(this.maintenanceEventType().id());
        buffer.put(this.planVersion());
        buffer.putLong(this.timeMs());
        buffer.putInt(this.brokerId());
        buffer.putShort(numBrokers);
        for (Integer broker : this._brokers) {
            buffer.putInt(broker);
        }
        return Crc32C.compute((ByteBuffer)buffer, (int)(-buffer.position()), (int)contentSize);
    }

    public Set<Integer> brokers() {
        return this._brokers;
    }

    @Override
    public String toString() {
        return String.format("[%s] Brokers: %s, Source [timeMs: %d, broker: %d]", new Object[]{this._maintenanceEventType, this._brokers, this._timeMs, this._brokerId});
    }
}

