/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.detector;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import com.linkedin.kafka.cruisecontrol.detector.AddBrokerPlan;
import com.linkedin.kafka.cruisecontrol.detector.DemoteBrokerPlan;
import com.linkedin.kafka.cruisecontrol.detector.FixOfflineReplicasPlan;
import com.linkedin.kafka.cruisecontrol.detector.MaintenancePlan;
import com.linkedin.kafka.cruisecontrol.detector.RebalancePlan;
import com.linkedin.kafka.cruisecontrol.detector.RemoveBrokerPlan;
import com.linkedin.kafka.cruisecontrol.detector.TopicReplicationFactorPlan;
import com.linkedin.kafka.cruisecontrol.metricsreporter.exception.UnknownVersionException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;

public class MaintenancePlanSerde
implements Serializer<MaintenancePlan>,
Deserializer<MaintenancePlan> {
    private final Gson _gson = new GsonBuilder().registerTypeAdapter(MaintenancePlan.class, (Object)new MaintenancePlanTypeAdapter()).create();

    public MaintenancePlan deserialize(String topic, byte[] bytes) {
        try {
            return (MaintenancePlan)this._gson.fromJson(new String(bytes, StandardCharsets.UTF_8), MaintenancePlan.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Error occurred while deserializing Maintenance plan.", e);
        }
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
    }

    public byte[] serialize(String topic, MaintenancePlan recordValue) {
        return this._gson.toJson((Object)recordValue, new TypeToken<MaintenancePlan>(){}.getType()).getBytes(StandardCharsets.UTF_8);
    }

    public void close() {
    }

    public static class MaintenancePlanTypeAdapter
    implements JsonSerializer<MaintenancePlan>,
    JsonDeserializer<MaintenancePlan> {
        public static final String PLAN_TYPE = "planType";
        public static final String VERSION = "version";
        public static final String CRC = "crc";
        public static final String CONTENT = "content";

        private static void verifyCrc(MaintenancePlan maintenancePlan, long storedCrc) {
            long computedCrc = maintenancePlan.getCrc();
            if (storedCrc != computedCrc) {
                throw new IllegalArgumentException(String.format("Plan is corrupt. CRC (stored: %d, computed: %d)", storedCrc, computedCrc));
            }
        }

        private static void verifyTypeAndVersion(String type, byte version) throws UnknownVersionException {
            byte latestSupportedVersion;
            if (AddBrokerPlan.class.getSimpleName().equals(type)) {
                latestSupportedVersion = 0;
            } else if (RemoveBrokerPlan.class.getSimpleName().equals(type)) {
                latestSupportedVersion = 0;
            } else if (FixOfflineReplicasPlan.class.getSimpleName().equals(type)) {
                latestSupportedVersion = 0;
            } else if (RebalancePlan.class.getSimpleName().equals(type)) {
                latestSupportedVersion = 0;
            } else if (DemoteBrokerPlan.class.getSimpleName().equals(type)) {
                latestSupportedVersion = 0;
            } else if (TopicReplicationFactorPlan.class.getSimpleName().equals(type)) {
                latestSupportedVersion = 0;
            } else {
                throw new IllegalArgumentException(String.format("Unsupported plan type: %s", type));
            }
            if (version > latestSupportedVersion) {
                throw new UnknownVersionException(String.format("Cannot deserialize the plan with type %s and version %d. Latest supported version: %d.", type, version, latestSupportedVersion));
            }
        }

        public JsonElement serialize(MaintenancePlan maintenancePlan, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject result = new JsonObject();
            result.add(PLAN_TYPE, (JsonElement)new JsonPrimitive(maintenancePlan.getClass().getSimpleName()));
            result.add(VERSION, (JsonElement)new JsonPrimitive((Number)maintenancePlan.planVersion()));
            result.add(CRC, (JsonElement)new JsonPrimitive((Number)maintenancePlan.getCrc()));
            result.add(CONTENT, context.serialize((Object)maintenancePlan, maintenancePlan.getClass()));
            return result;
        }

        public MaintenancePlan deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = json.getAsJsonObject();
            String type = jsonObject.get(PLAN_TYPE).getAsString();
            byte version = jsonObject.get(VERSION).getAsByte();
            try {
                MaintenancePlanTypeAdapter.verifyTypeAndVersion(type, version);
            }
            catch (UnknownVersionException e) {
                return null;
            }
            long storedCrc = jsonObject.get(CRC).getAsLong();
            JsonElement element = jsonObject.get(CONTENT);
            try {
                String fullName = typeOfT.getTypeName();
                String packageText = fullName.substring(0, fullName.lastIndexOf(".") + 1);
                MaintenancePlan maintenancePlan = (MaintenancePlan)context.deserialize(element, Class.forName(packageText + type));
                MaintenancePlanTypeAdapter.verifyCrc(maintenancePlan, storedCrc);
                return maintenancePlan;
            }
            catch (ClassNotFoundException cnfe) {
                throw new JsonParseException("Unknown element type: " + type, (Throwable)cnfe);
            }
        }
    }
}

