/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.detector;

import com.linkedin.kafka.cruisecontrol.detector.MaintenanceEventType;
import java.nio.ByteBuffer;
import org.apache.kafka.common.utils.Crc32C;

public abstract class MaintenancePlan {
    protected final MaintenanceEventType _maintenanceEventType;
    protected final long _timeMs;
    protected final int _brokerId;
    protected final byte _planVersion;

    public MaintenancePlan(MaintenanceEventType maintenanceEventType, long timeMs, int brokerId, byte planVersion) {
        this._maintenanceEventType = maintenanceEventType;
        this._timeMs = timeMs;
        this._brokerId = brokerId;
        this._planVersion = planVersion;
    }

    public MaintenanceEventType maintenanceEventType() {
        return this._maintenanceEventType;
    }

    public long timeMs() {
        return this._timeMs;
    }

    public int brokerId() {
        return this._brokerId;
    }

    public byte planVersion() {
        return this._planVersion;
    }

    protected long getCrc() {
        int contentSize = 14;
        ByteBuffer buffer = ByteBuffer.allocate(contentSize);
        buffer.put(this.maintenanceEventType().id());
        buffer.put(this.planVersion());
        buffer.putLong(this.timeMs());
        buffer.putInt(this.brokerId());
        return Crc32C.compute((ByteBuffer)buffer, (int)(-buffer.position()), (int)contentSize);
    }

    public String toString() {
        return String.format("[%s] Source [timeMs: %d, broker: %d]", new Object[]{this._maintenanceEventType, this._timeMs, this._brokerId});
    }
}

