/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.detector;

import com.linkedin.cruisecontrol.detector.AnomalyType;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControl;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.detector.AnomalyDetectorUtils;
import com.linkedin.kafka.cruisecontrol.detector.AnomalyUtils;
import com.linkedin.kafka.cruisecontrol.detector.KafkaAnomaly;
import com.linkedin.kafka.cruisecontrol.detector.MaintenanceEventType;
import com.linkedin.kafka.cruisecontrol.detector.notifier.KafkaAnomalyType;
import com.linkedin.kafka.cruisecontrol.exception.KafkaCruiseControlException;
import com.linkedin.kafka.cruisecontrol.servlet.handler.async.runnable.AddBrokersRunnable;
import com.linkedin.kafka.cruisecontrol.servlet.handler.async.runnable.DemoteBrokerRunnable;
import com.linkedin.kafka.cruisecontrol.servlet.handler.async.runnable.FixOfflineReplicasRunnable;
import com.linkedin.kafka.cruisecontrol.servlet.handler.async.runnable.GoalBasedOperationRunnable;
import com.linkedin.kafka.cruisecontrol.servlet.handler.async.runnable.RebalanceRunnable;
import com.linkedin.kafka.cruisecontrol.servlet.handler.async.runnable.RemoveBrokersRunnable;
import com.linkedin.kafka.cruisecontrol.servlet.handler.async.runnable.UpdateTopicConfigurationRunnable;
import com.linkedin.kafka.cruisecontrol.servlet.response.OptimizationResult;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Pattern;

public class MaintenanceEvent
extends KafkaAnomaly {
    public static final String MAINTENANCE_EVENT_TYPE_CONFIG = "maintenance.event.type";
    public static final String BROKERS_OBJECT_CONFIG = "brokers.object";
    public static final String TOPICS_WITH_RF_UPDATE_CONFIG = "topics.with.rf.update";
    protected GoalBasedOperationRunnable _goalBasedOperationRunnable;
    protected MaintenanceEventType _maintenanceEventType;
    protected Set<Integer> _brokers;
    protected Map<Short, String> _topicsWithRFUpdate;

    @Override
    public Supplier<String> reasonSupplier() {
        return () -> String.format("Self healing for %s: %s", new Object[]{KafkaAnomalyType.MAINTENANCE_EVENT, this});
    }

    public AnomalyType anomalyType() {
        return KafkaAnomalyType.MAINTENANCE_EVENT;
    }

    public MaintenanceEventType maintenanceEventType() {
        return this._maintenanceEventType;
    }

    public boolean fix() throws KafkaCruiseControlException {
        this._optimizationResult = new OptimizationResult(this._goalBasedOperationRunnable.computeResult(), null);
        boolean hasProposalsToFix = this.hasProposalsToFix();
        this._optimizationResult.discardIrrelevantAndCacheJsonAndPlaintext();
        return hasProposalsToFix;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("{Handling %s", new Object[]{this._maintenanceEventType}));
        if (this._topicsWithRFUpdate != null) {
            sb.append(String.format(" by desired RF: [%s]", this._topicsWithRFUpdate));
        } else if (this._brokers != null) {
            sb.append(String.format(" for brokers: [%s]", this._brokers));
        }
        sb.append("}");
        return sb.toString();
    }

    protected void initBrokers(Map<String, ?> configs) {
        this._brokers = (Set)configs.get(BROKERS_OBJECT_CONFIG);
        if (this._brokers == null || this._brokers.isEmpty()) {
            throw new IllegalArgumentException(String.format("Missing brokers for maintenance event of type %s.", new Object[]{this._maintenanceEventType}));
        }
    }

    protected void initTopicsWithRFUpdate(Map<String, ?> configs) {
        this._topicsWithRFUpdate = (Map)configs.get(TOPICS_WITH_RF_UPDATE_CONFIG);
        if (this._topicsWithRFUpdate == null || this._topicsWithRFUpdate.isEmpty()) {
            throw new IllegalArgumentException(String.format("Missing %s to identify topics (specified as a regex) for replication factor update.", TOPICS_WITH_RF_UPDATE_CONFIG));
        }
    }

    protected Map<Short, Pattern> topicPatternByReplicationFactor(Map<String, ?> configs) {
        this.initTopicsWithRFUpdate(configs);
        HashMap<Short, Pattern> topicPatternByReplicationFactor = new HashMap<Short, Pattern>(this._topicsWithRFUpdate.size());
        this._topicsWithRFUpdate.forEach((key, value) -> topicPatternByReplicationFactor.put((Short)key, Pattern.compile(value)));
        return topicPatternByReplicationFactor;
    }

    @Override
    public void configure(Map<String, ?> configs) {
        super.configure(configs);
        KafkaCruiseControl kafkaCruiseControl = AnomalyUtils.extractKafkaCruiseControlObjectFromConfig(configs, KafkaAnomalyType.MAINTENANCE_EVENT);
        KafkaCruiseControlConfig config = kafkaCruiseControl.config();
        boolean allowCapacityEstimation = config.getBoolean("anomaly.detection.allow.capacity.estimation");
        boolean excludeRecentlyDemotedBrokers = config.getBoolean("self.healing.exclude.recently.demoted.brokers");
        boolean excludeRecentlyRemovedBrokers = config.getBoolean("self.healing.exclude.recently.removed.brokers");
        this._optimizationResult = null;
        this._maintenanceEventType = (MaintenanceEventType)((Object)configs.get(MAINTENANCE_EVENT_TYPE_CONFIG));
        switch (this._maintenanceEventType) {
            case ADD_BROKER: {
                this.initBrokers(configs);
                this._goalBasedOperationRunnable = new AddBrokersRunnable(kafkaCruiseControl, this._brokers, AnomalyDetectorUtils.getSelfHealingGoalNames(config), allowCapacityEstimation, excludeRecentlyDemotedBrokers, excludeRecentlyRemovedBrokers, this._anomalyId.toString(), this.reasonSupplier());
                break;
            }
            case REMOVE_BROKER: {
                this.initBrokers(configs);
                this._goalBasedOperationRunnable = new RemoveBrokersRunnable(kafkaCruiseControl, this._brokers, AnomalyDetectorUtils.getSelfHealingGoalNames(config), allowCapacityEstimation, excludeRecentlyDemotedBrokers, excludeRecentlyRemovedBrokers, this._anomalyId.toString(), this.reasonSupplier());
                break;
            }
            case FIX_OFFLINE_REPLICAS: {
                this._goalBasedOperationRunnable = new FixOfflineReplicasRunnable(kafkaCruiseControl, AnomalyDetectorUtils.getSelfHealingGoalNames(config), allowCapacityEstimation, excludeRecentlyDemotedBrokers, excludeRecentlyRemovedBrokers, this._anomalyId.toString(), this.reasonSupplier());
                break;
            }
            case REBALANCE: {
                this._goalBasedOperationRunnable = new RebalanceRunnable(kafkaCruiseControl, AnomalyDetectorUtils.getSelfHealingGoalNames(config), allowCapacityEstimation, excludeRecentlyDemotedBrokers, excludeRecentlyRemovedBrokers, this._anomalyId.toString(), this.reasonSupplier());
                break;
            }
            case DEMOTE_BROKER: {
                this.initBrokers(configs);
                this._goalBasedOperationRunnable = new DemoteBrokerRunnable(kafkaCruiseControl, this._brokers, allowCapacityEstimation, excludeRecentlyDemotedBrokers, this._anomalyId.toString(), this.reasonSupplier());
                break;
            }
            case TOPIC_REPLICATION_FACTOR: {
                Map<Short, Pattern> topicPatternByReplicationFactor = this.topicPatternByReplicationFactor(configs);
                this._goalBasedOperationRunnable = new UpdateTopicConfigurationRunnable(kafkaCruiseControl, topicPatternByReplicationFactor, AnomalyDetectorUtils.getSelfHealingGoalNames(config), allowCapacityEstimation, excludeRecentlyDemotedBrokers, excludeRecentlyRemovedBrokers, this._anomalyId.toString(), this.reasonSupplier());
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Unsupported maintenance event type %s.", new Object[]{this._maintenanceEventType}));
            }
        }
    }
}

