/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.detector;

import com.linkedin.cruisecontrol.detector.metricanomaly.PercentileMetricAnomalyFinder;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControl;
import com.linkedin.kafka.cruisecontrol.detector.KafkaMetricAnomaly;
import com.linkedin.kafka.cruisecontrol.metricsreporter.metric.RawMetricType;
import com.linkedin.kafka.cruisecontrol.monitor.metricdefinition.KafkaMetricDef;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.holder.BrokerEntity;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

public class KafkaMetricAnomalyFinder
extends PercentileMetricAnomalyFinder<BrokerEntity> {
    private static final String DEFAULT_METRICS = new StringJoiner(",").add(RawMetricType.BROKER_PRODUCE_LOCAL_TIME_MS_50TH.toString()).add(RawMetricType.BROKER_PRODUCE_LOCAL_TIME_MS_999TH.toString()).add(RawMetricType.BROKER_CONSUMER_FETCH_LOCAL_TIME_MS_50TH.toString()).add(RawMetricType.BROKER_CONSUMER_FETCH_LOCAL_TIME_MS_999TH.toString()).add(RawMetricType.BROKER_FOLLOWER_FETCH_LOCAL_TIME_MS_50TH.toString()).add(RawMetricType.BROKER_FOLLOWER_FETCH_LOCAL_TIME_MS_999TH.toString()).add(RawMetricType.BROKER_LOG_FLUSH_TIME_MS_50TH.toString()).add(RawMetricType.BROKER_LOG_FLUSH_TIME_MS_999TH.toString()).toString();
    private KafkaCruiseControl _kafkaCruiseControl;

    protected String toMetricName(Short metricId) {
        return KafkaMetricDef.brokerMetricDef().metricInfo(metricId.shortValue()).name();
    }

    public KafkaMetricAnomaly createMetricAnomaly(String description, BrokerEntity entity, Short metricId, List<Long> windows) {
        HashMap<String, Object> parameterConfigOverrides = new HashMap<String, Object>(4);
        parameterConfigOverrides.put("metric.anomaly.description.object", description);
        parameterConfigOverrides.put("metric.anomaly.broker.entities.object", Collections.singletonMap(entity, this._kafkaCruiseControl.timeMs()));
        parameterConfigOverrides.put("anomaly.detection.time.ms.object", this._kafkaCruiseControl.timeMs());
        parameterConfigOverrides.put("metric.anomaly.fixable.object", false);
        return this._kafkaCruiseControl.config().getConfiguredInstance("metric.anomaly.class", KafkaMetricAnomaly.class, parameterConfigOverrides);
    }

    public void configure(Map<String, ?> configs) {
        String interestedMetrics = (String)configs.get("metric.anomaly.analyzer.metrics");
        if (interestedMetrics == null) {
            configs.put("metric.anomaly.analyzer.metrics", DEFAULT_METRICS);
        }
        super.configure(configs);
        this._kafkaCruiseControl = (KafkaCruiseControl)configs.get("kafka.cruise.control.object");
        if (this._kafkaCruiseControl == null) {
            throw new IllegalArgumentException("Kafka metric anomaly finder is missing kafka.cruise.control.object");
        }
    }
}

