/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.detector;

import com.linkedin.cruisecontrol.detector.AnomalyType;
import com.linkedin.cruisecontrol.detector.metricanomaly.MetricAnomaly;
import com.linkedin.kafka.cruisecontrol.detector.KafkaAnomaly;
import com.linkedin.kafka.cruisecontrol.detector.notifier.KafkaAnomalyType;
import com.linkedin.kafka.cruisecontrol.exception.KafkaCruiseControlException;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.holder.BrokerEntity;
import java.util.Map;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaMetricAnomaly
extends KafkaAnomaly
implements MetricAnomaly<BrokerEntity> {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaMetricAnomaly.class);
    protected String _description;
    protected Map<BrokerEntity, Long> _brokerEntitiesWithDetectionTimeMs;
    protected Boolean _fixable;

    public String description() {
        return this._description;
    }

    public Map<BrokerEntity, Long> entities() {
        return this._brokerEntitiesWithDetectionTimeMs;
    }

    public boolean fixable() {
        return this._fixable;
    }

    public boolean fix() throws KafkaCruiseControlException {
        if (this._fixable.booleanValue()) {
            LOG.trace("Fix the cluster by removing the leadership from the brokers: {}", this._brokerEntitiesWithDetectionTimeMs.keySet());
        }
        return false;
    }

    @Override
    public String toString() {
        return String.format("%s anomaly with id: %s. Anomaly description: %s", new Object[]{KafkaAnomalyType.METRIC_ANOMALY, this.anomalyId(), this._description});
    }

    @Override
    public String optimizationResult(boolean isJson) {
        if (this._optimizationResult == null) {
            return null;
        }
        return isJson ? this._optimizationResult.cachedJSONResponse() : this._optimizationResult.cachedPlaintextResponse();
    }

    @Override
    public Supplier<String> reasonSupplier() {
        return () -> String.format("Self healing for %s: %s", new Object[]{KafkaAnomalyType.METRIC_ANOMALY, this});
    }

    public AnomalyType anomalyType() {
        return KafkaAnomalyType.METRIC_ANOMALY;
    }

    @Override
    public void configure(Map<String, ?> configs) {
        super.configure(configs);
        this._description = (String)configs.get("metric.anomaly.description.object");
        this._fixable = (Boolean)configs.get("metric.anomaly.fixable.object");
        if (this._fixable == null) {
            throw new IllegalArgumentException(String.format("Missing %s for metric anomaly.", "metric.anomaly.fixable.object"));
        }
        this._brokerEntitiesWithDetectionTimeMs = (Map)configs.get("metric.anomaly.broker.entities.object");
        if (this._brokerEntitiesWithDetectionTimeMs == null || this._brokerEntitiesWithDetectionTimeMs.isEmpty()) {
            throw new IllegalArgumentException("Missing broker entities for metric anomaly.");
        }
        this._optimizationResult = null;
    }
}

