/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.detector;

import com.linkedin.cruisecontrol.common.CruiseControlConfigurable;
import com.linkedin.cruisecontrol.detector.Anomaly;
import com.linkedin.kafka.cruisecontrol.servlet.response.OptimizationResult;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KafkaAnomaly
implements Anomaly,
CruiseControlConfigurable {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaAnomaly.class);
    protected OptimizationResult _optimizationResult;
    protected long _detectionTimeMs;
    protected UUID _anomalyId;

    public String optimizationResult(boolean isJson) {
        if (this._optimizationResult == null) {
            return null;
        }
        return isJson ? this._optimizationResult.cachedJSONResponse() : this._optimizationResult.cachedPlaintextResponse();
    }

    protected boolean hasProposalsToFix() {
        boolean hasProposalsToFix;
        if (this._optimizationResult == null) {
            throw new IllegalArgumentException("Attempt to check proposals before generating or after discarding them.");
        }
        boolean bl = hasProposalsToFix = !this._optimizationResult.optimizerResult().goalProposals().isEmpty();
        if (!hasProposalsToFix) {
            LOG.info("Skip fixing the anomaly due to inability to optimize combined self-healing goals ({}). Consider expanding the cluster or relaxing the combined goal requirements.", this._optimizationResult.optimizerResult().statsByGoalName().keySet());
        }
        return hasProposalsToFix;
    }

    public abstract Supplier<String> reasonSupplier();

    public long detectionTimeMs() {
        return this._detectionTimeMs;
    }

    public String toString() {
        return String.format("%s anomaly with id: %s", this.anomalyType(), this.anomalyId());
    }

    public String anomalyId() {
        return this._anomalyId.toString();
    }

    public void configure(Map<String, ?> configs) {
        this._anomalyId = UUID.randomUUID();
        Long detectionTimeMs = (Long)configs.get("anomaly.detection.time.ms.object");
        if (detectionTimeMs == null) {
            throw new IllegalArgumentException(String.format("Missing %s when creating anomaly of type %s.", "anomaly.detection.time.ms.object", this.anomalyType()));
        }
        this._detectionTimeMs = detectionTimeMs;
    }
}

