/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.detector;

import com.linkedin.cruisecontrol.detector.AnomalyType;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControl;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.detector.AnomalyDetectorUtils;
import com.linkedin.kafka.cruisecontrol.detector.AnomalyUtils;
import com.linkedin.kafka.cruisecontrol.detector.KafkaAnomaly;
import com.linkedin.kafka.cruisecontrol.detector.notifier.KafkaAnomalyType;
import com.linkedin.kafka.cruisecontrol.exception.KafkaCruiseControlException;
import com.linkedin.kafka.cruisecontrol.servlet.handler.async.runnable.RebalanceRunnable;
import com.linkedin.kafka.cruisecontrol.servlet.response.OptimizationResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoalViolations
extends KafkaAnomaly {
    private static final Logger LOG = LoggerFactory.getLogger(GoalViolations.class);
    public static final String UNFIXABLE_GOAL_VIOLATIONS = "Unfixable goal violations";
    public static final String FIXABLE_GOAL_VIOLATIONS = "Fixable goal violations";
    protected Map<Boolean, List<String>> _violatedGoalsByFixability;
    protected boolean _excludeRecentlyDemotedBrokers;
    protected boolean _excludeRecentlyRemovedBrokers;
    protected RebalanceRunnable _rebalanceRunnable;

    void addViolation(String goalName, boolean fixable) {
        this._violatedGoalsByFixability.computeIfAbsent(fixable, k -> new ArrayList()).add(goalName);
    }

    public Map<Boolean, List<String>> violatedGoalsByFixability() {
        return this._violatedGoalsByFixability;
    }

    public boolean fix() throws KafkaCruiseControlException {
        boolean hasProposalsToFix = false;
        if (this._violatedGoalsByFixability.get(false) == null) {
            try {
                this._optimizationResult = new OptimizationResult(this._rebalanceRunnable.computeResult(), null);
                hasProposalsToFix = this.hasProposalsToFix();
                this._optimizationResult.discardIrrelevantAndCacheJsonAndPlaintext();
            }
            catch (IllegalStateException e) {
                LOG.warn("Got exception when trying to fix the cluster for violated goals {}: {}", this._violatedGoalsByFixability.get(true), (Object)e.getMessage());
            }
        } else {
            LOG.info("Skip fixing goal violations due to unfixable goal violations {} detected.", this._violatedGoalsByFixability.get(false));
        }
        return hasProposalsToFix;
    }

    public AnomalyType anomalyType() {
        return KafkaAnomalyType.GOAL_VIOLATION;
    }

    @Override
    public Supplier<String> reasonSupplier() {
        return () -> String.format("Self healing for %s: %s", new Object[]{KafkaAnomalyType.GOAL_VIOLATION, this});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("{%s: {", UNFIXABLE_GOAL_VIOLATIONS));
        StringJoiner joiner = new StringJoiner(",");
        this._violatedGoalsByFixability.getOrDefault(false, Collections.emptyList()).forEach(joiner::add);
        sb.append(joiner.toString());
        sb.append(String.format("}, %s: {", FIXABLE_GOAL_VIOLATIONS));
        joiner = new StringJoiner(",");
        this._violatedGoalsByFixability.getOrDefault(true, Collections.emptyList()).forEach(joiner::add);
        sb.append(joiner.toString());
        sb.append(String.format("}, Exclude brokers recently (removed: %s demoted: %s)}", this._excludeRecentlyRemovedBrokers, this._excludeRecentlyDemotedBrokers));
        return sb.toString();
    }

    @Override
    public void configure(Map<String, ?> configs) {
        super.configure(configs);
        this._violatedGoalsByFixability = new HashMap<Boolean, List<String>>();
        this._optimizationResult = null;
        KafkaCruiseControl kafkaCruiseControl = AnomalyUtils.extractKafkaCruiseControlObjectFromConfig(configs, KafkaAnomalyType.GOAL_VIOLATION);
        KafkaCruiseControlConfig config = kafkaCruiseControl.config();
        boolean allowCapacityEstimation = config.getBoolean("anomaly.detection.allow.capacity.estimation");
        this._excludeRecentlyDemotedBrokers = config.getBoolean("self.healing.exclude.recently.demoted.brokers");
        this._excludeRecentlyRemovedBrokers = config.getBoolean("self.healing.exclude.recently.removed.brokers");
        this._rebalanceRunnable = new RebalanceRunnable(kafkaCruiseControl, AnomalyDetectorUtils.getSelfHealingGoalNames(config), allowCapacityEstimation, this._excludeRecentlyDemotedBrokers, this._excludeRecentlyRemovedBrokers, this._anomalyId.toString(), this.reasonSupplier());
    }
}

