/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.detector;

import com.linkedin.cruisecontrol.detector.AnomalyType;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControl;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlUtils;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.detector.AnomalyDetectorUtils;
import com.linkedin.kafka.cruisecontrol.detector.AnomalyUtils;
import com.linkedin.kafka.cruisecontrol.detector.KafkaAnomaly;
import com.linkedin.kafka.cruisecontrol.detector.notifier.KafkaAnomalyType;
import com.linkedin.kafka.cruisecontrol.exception.KafkaCruiseControlException;
import com.linkedin.kafka.cruisecontrol.servlet.handler.async.runnable.FixOfflineReplicasRunnable;
import com.linkedin.kafka.cruisecontrol.servlet.response.OptimizationResult;
import java.util.Map;
import java.util.function.Supplier;

public class DiskFailures
extends KafkaAnomaly {
    protected Map<Integer, Map<String, Long>> _failedDisksByBroker;
    protected FixOfflineReplicasRunnable _fixOfflineReplicasRunnable;

    public Map<Integer, Map<String, Long>> failedDisks() {
        return this._failedDisksByBroker;
    }

    public boolean fix() throws KafkaCruiseControlException {
        this._optimizationResult = new OptimizationResult(this._fixOfflineReplicasRunnable.computeResult(), null);
        boolean hasProposalsToFix = this.hasProposalsToFix();
        this._optimizationResult.discardIrrelevantAndCacheJsonAndPlaintext();
        return hasProposalsToFix;
    }

    public AnomalyType anomalyType() {
        return KafkaAnomalyType.DISK_FAILURE;
    }

    @Override
    public Supplier<String> reasonSupplier() {
        return () -> String.format("Self healing for %s: %s", new Object[]{KafkaAnomalyType.DISK_FAILURE, this});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder().append("{\n");
        this._failedDisksByBroker.forEach((brokerId, failures) -> failures.forEach((logdir, eventTime) -> sb.append(String.format("\tDisk %s on broker %d failed at %s%n ", logdir, brokerId, KafkaCruiseControlUtils.toDateString(eventTime)))));
        sb.append("}");
        return sb.toString();
    }

    @Override
    public void configure(Map<String, ?> configs) {
        super.configure(configs);
        KafkaCruiseControl kafkaCruiseControl = AnomalyUtils.extractKafkaCruiseControlObjectFromConfig(configs, KafkaAnomalyType.DISK_FAILURE);
        this._failedDisksByBroker = (Map)configs.get("failed.disks.object");
        if (this._failedDisksByBroker == null || this._failedDisksByBroker.isEmpty()) {
            throw new IllegalArgumentException("Unable to create disk failure anomaly with no failed disk specified.");
        }
        this._optimizationResult = null;
        KafkaCruiseControlConfig config = kafkaCruiseControl.config();
        boolean allowCapacityEstimation = config.getBoolean("anomaly.detection.allow.capacity.estimation");
        boolean excludeRecentlyDemotedBrokers = config.getBoolean("self.healing.exclude.recently.demoted.brokers");
        boolean excludeRecentlyRemovedBrokers = config.getBoolean("self.healing.exclude.recently.removed.brokers");
        this._fixOfflineReplicasRunnable = new FixOfflineReplicasRunnable(kafkaCruiseControl, AnomalyDetectorUtils.getSelfHealingGoalNames(config), allowCapacityEstimation, excludeRecentlyDemotedBrokers, excludeRecentlyRemovedBrokers, this._anomalyId.toString(), this.reasonSupplier());
    }
}

