/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.detector;

import com.linkedin.cruisecontrol.detector.AnomalyType;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControl;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlUtils;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.detector.AnomalyDetectorUtils;
import com.linkedin.kafka.cruisecontrol.detector.AnomalyUtils;
import com.linkedin.kafka.cruisecontrol.detector.KafkaAnomaly;
import com.linkedin.kafka.cruisecontrol.detector.notifier.KafkaAnomalyType;
import com.linkedin.kafka.cruisecontrol.exception.KafkaCruiseControlException;
import com.linkedin.kafka.cruisecontrol.servlet.handler.async.runnable.RemoveBrokersRunnable;
import com.linkedin.kafka.cruisecontrol.servlet.response.OptimizationResult;
import java.util.Map;
import java.util.function.Supplier;

public class BrokerFailures
extends KafkaAnomaly {
    protected Map<Integer, Long> _failedBrokers;
    protected RemoveBrokersRunnable _removeBrokersRunnable;
    protected boolean _fixable;

    public BrokerFailures() {
        this._detectionTimeMs = 0L;
    }

    public Map<Integer, Long> failedBrokers() {
        return this._failedBrokers;
    }

    public boolean fixable() {
        return this._fixable;
    }

    public boolean fix() throws KafkaCruiseControlException {
        boolean hasProposalsToFix = false;
        if (this._removeBrokersRunnable != null && this._fixable) {
            this._optimizationResult = new OptimizationResult(this._removeBrokersRunnable.computeResult(), null);
            hasProposalsToFix = this.hasProposalsToFix();
            this._optimizationResult.discardIrrelevantAndCacheJsonAndPlaintext();
        }
        return hasProposalsToFix;
    }

    public AnomalyType anomalyType() {
        return KafkaAnomalyType.BROKER_FAILURE;
    }

    @Override
    public Supplier<String> reasonSupplier() {
        return () -> String.format("Self healing for %s: %s", new Object[]{KafkaAnomalyType.BROKER_FAILURE, this});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder().append("{");
        sb.append(this._fixable ? "Fixable " : " Unfixable ");
        sb.append("broker failures detected: {");
        if (this._failedBrokers != null) {
            this._failedBrokers.forEach((key, value) -> sb.append("Broker ").append(key).append(" failed at ").append(KafkaCruiseControlUtils.toDateString(value)).append(",\t"));
            sb.setLength(sb.length() - 2);
        }
        sb.append("}}");
        return sb.toString();
    }

    @Override
    public void configure(Map<String, ?> configs) {
        super.configure(configs);
        KafkaCruiseControl kafkaCruiseControl = AnomalyUtils.extractKafkaCruiseControlObjectFromConfig(configs, KafkaAnomalyType.BROKER_FAILURE);
        this._failedBrokers = (Map)configs.get("failed.brokers.object");
        if (this._failedBrokers != null && this._failedBrokers.isEmpty()) {
            throw new IllegalArgumentException("Missing broker ids for failed brokers anomaly.");
        }
        this._fixable = (Boolean)configs.get("broker.failures.fixable.object");
        this._optimizationResult = null;
        KafkaCruiseControlConfig config = kafkaCruiseControl.config();
        boolean allowCapacityEstimation = config.getBoolean("anomaly.detection.allow.capacity.estimation");
        boolean excludeRecentlyDemotedBrokers = config.getBoolean("self.healing.exclude.recently.demoted.brokers");
        boolean excludeRecentlyRemovedBrokers = config.getBoolean("self.healing.exclude.recently.removed.brokers");
        this._removeBrokersRunnable = this._failedBrokers != null ? new RemoveBrokersRunnable(kafkaCruiseControl, this._failedBrokers.keySet(), AnomalyDetectorUtils.getSelfHealingGoalNames(config), allowCapacityEstimation, excludeRecentlyDemotedBrokers, excludeRecentlyRemovedBrokers, this._anomalyId.toString(), this.reasonSupplier()) : null;
    }
}

