/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.detector;

import com.linkedin.cruisecontrol.common.config.ConfigException;
import com.linkedin.cruisecontrol.detector.AnomalyType;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControl;
import com.linkedin.kafka.cruisecontrol.monitor.task.LoadMonitorTaskRunner;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public class AnomalyUtils {
    private AnomalyUtils() {
    }

    public static KafkaCruiseControl extractKafkaCruiseControlObjectFromConfig(Map<String, ?> configs, AnomalyType anomalyType) {
        KafkaCruiseControl kafkaCruiseControl = (KafkaCruiseControl)configs.get("kafka.cruise.control.object");
        if (kafkaCruiseControl == null) {
            throw new IllegalArgumentException(String.format("Missing %s when creating anomaly of type %s.", "kafka.cruise.control.object", anomalyType));
        }
        return kafkaCruiseControl;
    }

    public static boolean isLoadMonitorReady(LoadMonitorTaskRunner.LoadMonitorTaskRunnerState loadMonitorTaskRunnerState) {
        return loadMonitorTaskRunnerState != LoadMonitorTaskRunner.LoadMonitorTaskRunnerState.LOADING && loadMonitorTaskRunnerState != LoadMonitorTaskRunner.LoadMonitorTaskRunnerState.BOOTSTRAPPING;
    }

    public static Pattern buildTopicRegex(Set<String> stringsToMatch) {
        StringJoiner sj = new StringJoiner("|");
        stringsToMatch.forEach(sj::add);
        return Pattern.compile(sj.toString());
    }

    public static int parseAndGetConfig(Map<String, Object> config, String key, int defaultValue, Predicate<Integer> illegalValueCheck) {
        String valueString = (String)config.get(key);
        if (valueString == null) {
            return defaultValue;
        }
        try {
            Integer value = Integer.parseInt(valueString);
            if (illegalValueCheck.test(value)) {
                throw new ConfigException(key, (Object)value);
            }
            return value;
        }
        catch (NumberFormatException e) {
            throw new ConfigException(key, (Object)valueString, e.getMessage());
        }
    }

    public static double parseAndGetConfig(Map<String, Object> config, String key, double defaultValue, Predicate<Double> illegalValueCheck) {
        String valueString = (String)config.get(key);
        if (valueString == null) {
            return defaultValue;
        }
        try {
            Double value = Double.parseDouble(valueString);
            if (illegalValueCheck.test(value)) {
                throw new ConfigException(key, (Object)value);
            }
            return value;
        }
        catch (NumberFormatException e) {
            throw new ConfigException(key, (Object)valueString, e.getMessage());
        }
    }
}

