/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.detector;

import com.linkedin.cruisecontrol.detector.Anomaly;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class AnomalyState {
    private final Anomaly _anomaly;
    private final long _detectionMs;
    private long _statusUpdateMs;
    private Status _status;

    public AnomalyState(Anomaly anomaly) {
        this._anomaly = anomaly;
        this._statusUpdateMs = this._detectionMs = System.currentTimeMillis();
        this._status = Status.DETECTED;
    }

    public Status status() {
        return this._status;
    }

    public String anomalyId() {
        return this._anomaly.anomalyId();
    }

    public Anomaly anomaly() {
        return this._anomaly;
    }

    public long detectionMs() {
        return this._detectionMs;
    }

    public long statusUpdateMs() {
        return this._statusUpdateMs;
    }

    public void setStatus(Status status) {
        this._status = status;
        this._statusUpdateMs = System.currentTimeMillis();
    }

    public static enum Status {
        DETECTED,
        IGNORED,
        FIX_STARTED,
        FIX_FAILED_TO_START,
        CHECK_WITH_DELAY,
        LOAD_MONITOR_NOT_READY,
        COMPLETENESS_NOT_READY;

        private static final List<Status> CACHED_VALUES;

        public static List<Status> cachedValues() {
            return CACHED_VALUES;
        }

        static {
            CACHED_VALUES = Collections.unmodifiableList(Arrays.asList(Status.values()));
        }
    }
}

