/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.detector;

import com.linkedin.cruisecontrol.detector.AnomalyType;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlUtils;
import com.linkedin.kafka.cruisecontrol.detector.MeanTimeBetweenAnomaliesMs;
import com.linkedin.kafka.cruisecontrol.detector.notifier.KafkaAnomalyType;
import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseClass;
import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseField;
import java.util.HashMap;
import java.util.Map;

@JsonResponseClass
public class AnomalyMetrics {
    @JsonResponseField
    private static final String MEAN_TIME_BETWEEN_ANOMALIES_MS = "meanTimeBetweenAnomaliesMs";
    @JsonResponseField
    private static final String MEAN_TIME_TO_START_FIX_MS = "meanTimeToStartFixMs";
    @JsonResponseField
    private static final String ONGOING_ANOMALY_DURATION_MS = "ongoingAnomalyDurationMs";
    @JsonResponseField
    private static final String NUM_SELF_HEALING_STARTED = "numSelfHealingStarted";
    @JsonResponseField
    private static final String NUM_SELF_HEALING_FAILED_TO_START = "numSelfHealingFailedToStart";
    private final MeanTimeBetweenAnomaliesMs _meanTimeBetweenAnomaliesMs;
    private final double _meanTimeToStartFixMs;
    private final long _numSelfHealingStarted;
    private final long _numSelfHealingFailedToStart;
    private final long _ongoingAnomalyDurationMs;

    public AnomalyMetrics(Map<AnomalyType, Double> meanTimeBetweenAnomaliesMs, double meanTimeToStartFixMs, long numSelfHealingStarted, long numSelfHealingFailedToStart, long ongoingAnomalyDurationMs) {
        if (meanTimeBetweenAnomaliesMs == null) {
            throw new IllegalArgumentException("Attempt to set meanTimeBetweenAnomaliesMs with null.");
        }
        for (AnomalyType anomalyType : KafkaAnomalyType.cachedValues()) {
            if (meanTimeBetweenAnomaliesMs.containsKey(anomalyType)) continue;
            throw new IllegalArgumentException(anomalyType + " is missing in meanTimeBetweenAnomaliesMs metric.");
        }
        this._meanTimeBetweenAnomaliesMs = new MeanTimeBetweenAnomaliesMs(meanTimeBetweenAnomaliesMs);
        this._meanTimeToStartFixMs = meanTimeToStartFixMs;
        this._numSelfHealingStarted = numSelfHealingStarted;
        this._numSelfHealingFailedToStart = numSelfHealingFailedToStart;
        this._ongoingAnomalyDurationMs = ongoingAnomalyDurationMs;
    }

    public double meanTimeToStartFixMs() {
        return this._meanTimeToStartFixMs;
    }

    public MeanTimeBetweenAnomaliesMs meanTimeBetweenAnomaliesMs() {
        return this._meanTimeBetweenAnomaliesMs;
    }

    public long numSelfHealingStarted() {
        return this._numSelfHealingStarted;
    }

    public long numSelfHealingFailedToStart() {
        return this._numSelfHealingFailedToStart;
    }

    public long ongoingAnomalyDurationMs() {
        return this._ongoingAnomalyDurationMs;
    }

    public Map<String, Object> getJsonStructure() {
        HashMap<String, Object> metrics = new HashMap<String, Object>(5);
        metrics.put(MEAN_TIME_BETWEEN_ANOMALIES_MS, this.meanTimeBetweenAnomaliesMs().getJsonStructure());
        metrics.put(MEAN_TIME_TO_START_FIX_MS, this.meanTimeToStartFixMs());
        metrics.put(NUM_SELF_HEALING_STARTED, this.numSelfHealingStarted());
        metrics.put(NUM_SELF_HEALING_FAILED_TO_START, this.numSelfHealingFailedToStart());
        metrics.put(ONGOING_ANOMALY_DURATION_MS, this.ongoingAnomalyDurationMs());
        return metrics;
    }

    public String toString() {
        Map<AnomalyType, Double> meanTimeBetweenAnomalies = this._meanTimeBetweenAnomaliesMs.getJsonStructure();
        return String.format("{meanTimeBetweenAnomalies:{%s:%s, %s:%s, %s:%s, %s:%s, %s:%s}, meanTimeToStartFix:%s, numSelfHealingStarted:%d, numSelfHealingFailedToStart:%d, ongoingAnomalyDuration=%s}", new Object[]{KafkaAnomalyType.GOAL_VIOLATION, KafkaCruiseControlUtils.toPrettyDuration(meanTimeBetweenAnomalies.get((Object)KafkaAnomalyType.GOAL_VIOLATION)), KafkaAnomalyType.BROKER_FAILURE, KafkaCruiseControlUtils.toPrettyDuration(meanTimeBetweenAnomalies.get((Object)KafkaAnomalyType.BROKER_FAILURE)), KafkaAnomalyType.METRIC_ANOMALY, KafkaCruiseControlUtils.toPrettyDuration(meanTimeBetweenAnomalies.get((Object)KafkaAnomalyType.METRIC_ANOMALY)), KafkaAnomalyType.DISK_FAILURE, KafkaCruiseControlUtils.toPrettyDuration(meanTimeBetweenAnomalies.get((Object)KafkaAnomalyType.DISK_FAILURE)), KafkaAnomalyType.TOPIC_ANOMALY, KafkaCruiseControlUtils.toPrettyDuration(meanTimeBetweenAnomalies.get((Object)KafkaAnomalyType.TOPIC_ANOMALY)), KafkaCruiseControlUtils.toPrettyDuration(this._meanTimeToStartFixMs), this._numSelfHealingStarted, this._numSelfHealingFailedToStart, KafkaCruiseControlUtils.toPrettyDuration(this._ongoingAnomalyDurationMs)});
    }
}

