/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.detector;

import com.linkedin.cruisecontrol.detector.Anomaly;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControl;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.Goal;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.detector.AnomalyDetectionStatus;
import com.linkedin.kafka.cruisecontrol.detector.AnomalyUtils;
import com.linkedin.kafka.cruisecontrol.detector.BrokerFailures;
import com.linkedin.kafka.cruisecontrol.detector.GoalViolations;
import com.linkedin.kafka.cruisecontrol.detector.MaintenancePlan;
import com.linkedin.kafka.cruisecontrol.detector.MaintenancePlanSerde;
import com.linkedin.kafka.cruisecontrol.executor.ExecutorState;
import com.linkedin.kafka.cruisecontrol.monitor.task.LoadMonitorTaskRunner;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnomalyDetectorUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AnomalyDetectorUtils.class);
    public static final String KAFKA_CRUISE_CONTROL_OBJECT_CONFIG = "kafka.cruise.control.object";
    public static final String ANOMALY_DETECTION_TIME_MS_OBJECT_CONFIG = "anomaly.detection.time.ms.object";
    public static final long MAX_METADATA_WAIT_MS = 60000L;
    public static final Anomaly SHUTDOWN_ANOMALY = new BrokerFailures();
    public static final Random RANDOM = new Random();

    private AnomalyDetectorUtils() {
    }

    public static Consumer<String, MaintenancePlan> createMaintenanceEventConsumer(Map<String, ?> configs, String clientIdPrefix) {
        String bootstrapServers = String.join((CharSequence)",", (List)configs.get("bootstrap.servers"));
        long randomToken = RANDOM.nextLong();
        Properties consumerProps = new Properties();
        consumerProps.putAll(configs);
        consumerProps.setProperty("bootstrap.servers", bootstrapServers);
        consumerProps.setProperty("client.id", clientIdPrefix + "-consumer-" + randomToken);
        consumerProps.setProperty("auto.offset.reset", "latest");
        consumerProps.setProperty("enable.auto.commit", "false");
        consumerProps.setProperty("max.poll.records", Integer.toString(Integer.MAX_VALUE));
        consumerProps.setProperty("key.deserializer", StringDeserializer.class.getName());
        consumerProps.setProperty("value.deserializer", MaintenancePlanSerde.class.getName());
        consumerProps.setProperty("reconnect.backoff.ms", configs.get("reconnect.backoff.ms").toString());
        return new KafkaConsumer(consumerProps);
    }

    public static List<String> getSelfHealingGoalNames(KafkaCruiseControlConfig config) {
        List<Goal> goals = config.getConfiguredInstances("self.healing.goals", Goal.class);
        ArrayList<String> selfHealingGoalNames = new ArrayList<String>(goals.size());
        for (Goal goal : goals) {
            selfHealingGoalNames.add(goal.name());
        }
        return selfHealingGoalNames;
    }

    static AnomalyDetectionStatus getAnomalyDetectionStatus(KafkaCruiseControl kafkaCruiseControl, boolean checkOfflineReplica) {
        Set<Integer> brokersWithOfflineReplicas;
        if (checkOfflineReplica && !(brokersWithOfflineReplicas = kafkaCruiseControl.loadMonitor().brokersWithOfflineReplicas(60000L)).isEmpty()) {
            LOG.info("Skipping anomaly detection because there are dead brokers/disks in the cluster, flawed brokers: {}", brokersWithOfflineReplicas);
            return AnomalyDetectionStatus.SKIP_HAS_OFFLINE_REPLICAS;
        }
        LoadMonitorTaskRunner.LoadMonitorTaskRunnerState loadMonitorTaskRunnerState = kafkaCruiseControl.getLoadMonitorTaskRunnerState();
        if (!AnomalyUtils.isLoadMonitorReady(loadMonitorTaskRunnerState)) {
            LOG.info("Skipping anomaly detection because load monitor is in {} state.", (Object)loadMonitorTaskRunnerState);
            return AnomalyDetectionStatus.SKIP_LOAD_MONITOR_NOT_READY;
        }
        ExecutorState.State executionState = kafkaCruiseControl.executionState();
        if (executionState != ExecutorState.State.NO_TASK_IN_PROGRESS) {
            LOG.info("Skipping anomaly detection because the executor is in {} state.", (Object)executionState);
            return AnomalyDetectionStatus.SKIP_EXECUTOR_NOT_READY;
        }
        return AnomalyDetectionStatus.READY;
    }

    public static Comparator<Anomaly> anomalyComparator() {
        return Comparator.comparing(anomaly -> anomaly.anomalyType().priority()).thenComparingLong(Anomaly::detectionTimeMs);
    }

    public static boolean hasUnfixableGoals(GoalViolations goalViolations) {
        List<String> unfixableGoals = goalViolations.violatedGoalsByFixability().get(false);
        return unfixableGoals != null && !unfixableGoals.isEmpty();
    }
}

