/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.detector;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.linkedin.cruisecontrol.detector.Anomaly;
import com.linkedin.cruisecontrol.detector.AnomalyType;
import com.linkedin.kafka.cruisecontrol.detector.AnomalyDetails;
import com.linkedin.kafka.cruisecontrol.detector.AnomalyDetectorUtils;
import com.linkedin.kafka.cruisecontrol.detector.AnomalyMetrics;
import com.linkedin.kafka.cruisecontrol.detector.AnomalyState;
import com.linkedin.kafka.cruisecontrol.detector.GoalViolations;
import com.linkedin.kafka.cruisecontrol.detector.SelfHealingEnabledRatio;
import com.linkedin.kafka.cruisecontrol.detector.notifier.KafkaAnomalyType;
import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseClass;
import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseField;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonResponseClass
public class AnomalyDetectorState {
    private static final Logger LOG = LoggerFactory.getLogger(AnomalyDetectorState.class);
    @JsonResponseField
    private static final String SELF_HEALING_ENABLED = "selfHealingEnabled";
    @JsonResponseField
    private static final String SELF_HEALING_DISABLED = "selfHealingDisabled";
    @JsonResponseField
    private static final String SELF_HEALING_ENABLED_RATIO = "selfHealingEnabledRatio";
    @JsonResponseField
    private static final String RECENT_GOAL_VIOLATIONS = "recentGoalViolations";
    @JsonResponseField
    private static final String RECENT_BROKER_FAILURES = "recentBrokerFailures";
    @JsonResponseField
    private static final String RECENT_METRIC_ANOMALIES = "recentMetricAnomalies";
    @JsonResponseField
    private static final String RECENT_TOPIC_ANOMALIES = "recentTopicAnomalies";
    @JsonResponseField
    private static final String RECENT_MAINTENANCE_EVENTS = "recentMaintenanceEvents";
    @JsonResponseField
    private static final String RECENT_DISK_FAILURES = "recentDiskFailures";
    @JsonResponseField(required=false)
    private static final String ONGOING_SELF_HEALING_ANOMALY = "ongoingSelfHealingAnomaly";
    @JsonResponseField
    private static final String METRICS = "metrics";
    @JsonResponseField
    private static final String BALANCEDNESS_SCORE = "balancednessScore";
    private static final double INITIAL_BALANCEDNESS_SCORE = 100.0;
    static final String NUM_SELF_HEALING_STARTED = "numSelfHealingStarted";
    private static final long NO_ONGOING_ANOMALY_FLAG = -1L;
    private final Map<AnomalyType, Map<String, AnomalyState>> _recentAnomaliesByType;
    private Anomaly _ongoingSelfHealingAnomaly;
    private final Map<AnomalyType, Boolean> _selfHealingEnabled;
    SelfHealingEnabledRatio _selfHealingEnabledRatio;
    private final int _numCachedRecentAnomalyStates;
    private AnomalyMetrics _metrics;
    private volatile long _ongoingAnomalyDetectionTimeMs;
    private long _ongoingAnomalyCount;
    private double _ongoingAnomalyDurationSumForAverageMs;
    private final Time _time;
    private final AtomicLong _numSelfHealingStarted;
    private final AtomicLong _numSelfHealingFailedToStart;
    private final Map<AnomalyType, Meter> _anomalyRateByType;
    private double _balancednessScore;
    private boolean _hasUnfixableGoals;

    public AnomalyDetectorState(Time time, Map<AnomalyType, Boolean> selfHealingEnabled, int numCachedRecentAnomalyStates, MetricRegistry dropwizardMetricRegistry) {
        this._time = time;
        this._numCachedRecentAnomalyStates = numCachedRecentAnomalyStates;
        this._recentAnomaliesByType = new HashMap<AnomalyType, Map<String, AnomalyState>>(KafkaAnomalyType.cachedValues().size());
        for (AnomalyType anomalyType2 : KafkaAnomalyType.cachedValues()) {
            this._recentAnomaliesByType.put(anomalyType2, (Map<String, AnomalyState>)new LinkedHashMap<String, AnomalyState>(){

                @Override
                protected boolean removeEldestEntry(Map.Entry<String, AnomalyState> eldest) {
                    return this.size() > AnomalyDetectorState.this._numCachedRecentAnomalyStates;
                }
            });
        }
        this._selfHealingEnabled = selfHealingEnabled;
        this._selfHealingEnabledRatio = null;
        this._ongoingSelfHealingAnomaly = null;
        this._ongoingAnomalyDetectionTimeMs = -1L;
        this._ongoingAnomalyCount = 0L;
        this._ongoingAnomalyDurationSumForAverageMs = 0.0;
        this._numSelfHealingStarted = new AtomicLong(0L);
        this._numSelfHealingFailedToStart = new AtomicLong(0L);
        HashMap<AnomalyType, Double> meanTimeBetweenAnomaliesMs = new HashMap<AnomalyType, Double>(KafkaAnomalyType.cachedValues().size());
        for (AnomalyType anomalyType3 : KafkaAnomalyType.cachedValues()) {
            meanTimeBetweenAnomaliesMs.put(anomalyType3, 0.0);
        }
        this._metrics = new AnomalyMetrics(meanTimeBetweenAnomaliesMs, 0.0, 0L, 0L, 0L);
        if (dropwizardMetricRegistry != null) {
            dropwizardMetricRegistry.register(MetricRegistry.name((String)"AnomalyDetector", (String[])new String[]{"mean-time-to-start-fix-ms"}), (Metric)((Gauge)this::meanTimeToStartFixMs));
            dropwizardMetricRegistry.register(MetricRegistry.name((String)"AnomalyDetector", (String[])new String[]{"number-of-self-healing-started"}), (Metric)((Gauge)this::numSelfHealingStarted));
            dropwizardMetricRegistry.register(MetricRegistry.name((String)"AnomalyDetector", (String[])new String[]{"number-of-self-healing-failed-to-start"}), (Metric)((Gauge)this::numSelfHealingFailedToStart));
            dropwizardMetricRegistry.register(MetricRegistry.name((String)"AnomalyDetector", (String[])new String[]{"ongoing-anomaly-duration-ms"}), (Metric)((Gauge)this::ongoingAnomalyDurationMs));
            dropwizardMetricRegistry.register(MetricRegistry.name((String)"AnomalyDetector", (String[])new String[]{String.format("%s-has-unfixable-goals", new Object[]{KafkaAnomalyType.GOAL_VIOLATION})}), (Metric)((Gauge)() -> this.hasUnfixableGoals() ? 1 : 0));
            this._anomalyRateByType = new HashMap<AnomalyType, Meter>(KafkaAnomalyType.cachedValues().size());
            this._anomalyRateByType.put(KafkaAnomalyType.BROKER_FAILURE, dropwizardMetricRegistry.meter(MetricRegistry.name((String)"AnomalyDetector", (String[])new String[]{"broker-failure-rate"})));
            this._anomalyRateByType.put(KafkaAnomalyType.GOAL_VIOLATION, dropwizardMetricRegistry.meter(MetricRegistry.name((String)"AnomalyDetector", (String[])new String[]{"goal-violation-rate"})));
            this._anomalyRateByType.put(KafkaAnomalyType.METRIC_ANOMALY, dropwizardMetricRegistry.meter(MetricRegistry.name((String)"AnomalyDetector", (String[])new String[]{"metric-anomaly-rate"})));
            this._anomalyRateByType.put(KafkaAnomalyType.DISK_FAILURE, dropwizardMetricRegistry.meter(MetricRegistry.name((String)"AnomalyDetector", (String[])new String[]{"disk-failure-rate"})));
            this._anomalyRateByType.put(KafkaAnomalyType.TOPIC_ANOMALY, dropwizardMetricRegistry.meter(MetricRegistry.name((String)"AnomalyDetector", (String[])new String[]{"topic-anomaly-rate"})));
            this._anomalyRateByType.put(KafkaAnomalyType.MAINTENANCE_EVENT, dropwizardMetricRegistry.meter(MetricRegistry.name((String)"AnomalyDetector", (String[])new String[]{"maintenance-event-rate"})));
        } else {
            this._anomalyRateByType = new HashMap<AnomalyType, Meter>(KafkaAnomalyType.cachedValues().size());
            KafkaAnomalyType.cachedValues().forEach(anomalyType -> this._anomalyRateByType.put((AnomalyType)anomalyType, new Meter()));
        }
        this._balancednessScore = 100.0;
        this._hasUnfixableGoals = false;
    }

    void markAnomalyRate(AnomalyType anomalyType) {
        this._anomalyRateByType.get(anomalyType).mark();
    }

    void refreshHasUnfixableGoal(GoalViolations goalViolations) {
        this._hasUnfixableGoals = AnomalyDetectorUtils.hasUnfixableGoals(goalViolations);
    }

    public boolean hasUnfixableGoals() {
        return this._hasUnfixableGoals;
    }

    void resetHasUnfixableGoals() {
        this._hasUnfixableGoals = false;
    }

    synchronized void refreshMetrics(Map<AnomalyType, Float> selfHealingEnabledRatio, double balancednessScore) {
        if (selfHealingEnabledRatio == null) {
            throw new IllegalArgumentException("Attempt to set selfHealingEnabledRatio with null.");
        }
        HashMap<AnomalyType, Double> meanTimeBetweenAnomaliesMs = new HashMap<AnomalyType, Double>(KafkaAnomalyType.cachedValues().size());
        for (AnomalyType anomalyType : KafkaAnomalyType.cachedValues()) {
            meanTimeBetweenAnomaliesMs.put(anomalyType, this._anomalyRateByType.get(anomalyType).getMeanRate() * 1000.0);
        }
        this._metrics = new AnomalyMetrics(meanTimeBetweenAnomaliesMs, this.meanTimeToStartFixMs(), this.numSelfHealingStarted(), this.numSelfHealingFailedToStart(), this.ongoingAnomalyDurationMs());
        this._selfHealingEnabledRatio = new SelfHealingEnabledRatio(selfHealingEnabledRatio.size());
        selfHealingEnabledRatio.forEach((key, value) -> this._selfHealingEnabledRatio.put((AnomalyType)key, (Float)value));
        this._balancednessScore = balancednessScore;
    }

    private long ongoingAnomalyDurationMs() {
        return this._ongoingAnomalyDetectionTimeMs != -1L ? this._time.milliseconds() - this._ongoingAnomalyDetectionTimeMs : 0L;
    }

    private double meanTimeToStartFixMs() {
        long fixedAnomalyDurations = this._ongoingAnomalyDetectionTimeMs == -1L ? this._ongoingAnomalyCount : this._ongoingAnomalyCount - 1L;
        return fixedAnomalyDurations == 0L ? 0.0 : this._ongoingAnomalyDurationSumForAverageMs / (double)fixedAnomalyDurations;
    }

    synchronized void maybeClearOngoingAnomalyDetectionTimeMs() {
        if (this._ongoingAnomalyDetectionTimeMs != -1L) {
            double elapsed = this._time.milliseconds() - this._ongoingAnomalyDetectionTimeMs;
            this._ongoingAnomalyDurationSumForAverageMs += elapsed;
            this._ongoingAnomalyDetectionTimeMs = -1L;
        }
    }

    synchronized void maybeSetOngoingAnomalyDetectionTimeMs() {
        if (this._ongoingAnomalyDetectionTimeMs == -1L) {
            this._ongoingAnomalyDetectionTimeMs = this._time.milliseconds();
            ++this._ongoingAnomalyCount;
        }
    }

    long numSelfHealingStarted() {
        return this._numSelfHealingStarted.get();
    }

    void incrementNumSelfHealingStarted() {
        this._numSelfHealingStarted.incrementAndGet();
    }

    long numSelfHealingFailedToStart() {
        return this._numSelfHealingFailedToStart.get();
    }

    void incrementNumSelfHealingFailedToStart() {
        this._numSelfHealingFailedToStart.incrementAndGet();
    }

    Map<String, Object> metrics() {
        return this._metrics.getJsonStructure();
    }

    private SelfHealingEnabledRatio selfHealingEnabledRatio() {
        return this._selfHealingEnabledRatio == null ? new SelfHealingEnabledRatio(0) : this._selfHealingEnabledRatio;
    }

    public synchronized void markSelfHealingFinished(String anomalyId) {
        if (this._ongoingSelfHealingAnomaly == null || !this._ongoingSelfHealingAnomaly.anomalyId().equals(anomalyId)) {
            throw new IllegalStateException(String.format("Anomaly %s is not marked as %s state in AnomalyDetector.", new Object[]{anomalyId, AnomalyState.Status.FIX_STARTED}));
        }
        this._ongoingSelfHealingAnomaly = null;
    }

    void addAnomalyDetection(AnomalyType anomalyType, Anomaly anomaly) {
        this._recentAnomaliesByType.get(anomalyType).put(anomaly.anomalyId(), new AnomalyState(anomaly));
    }

    synchronized void onAnomalyHandle(Anomaly anomaly, AnomalyState.Status status) {
        AnomalyState recentAnomalyState;
        AnomalyType anomalyType = anomaly.anomalyType();
        String anomalyId = anomaly.anomalyId();
        if (status == AnomalyState.Status.FIX_STARTED) {
            this._ongoingSelfHealingAnomaly = anomaly;
        }
        if ((recentAnomalyState = this._recentAnomaliesByType.get(anomalyType).get(anomalyId)) != null) {
            recentAnomalyState.setStatus(status);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Anomaly (type: {}, anomalyId: {}) is no longer in the anomaly detector state cache.", (Object)anomalyType, (Object)anomalyId);
        }
    }

    public synchronized void setSelfHealingFor(AnomalyType anomalyType, boolean isSelfHealingEnabled) {
        this._selfHealingEnabled.put(anomalyType, isSelfHealingEnabled);
    }

    Map<AnomalyType, Map<String, AnomalyState>> recentAnomaliesByType() {
        return this._recentAnomaliesByType;
    }

    private Set<Map<String, Object>> recentAnomalies(AnomalyType anomalyType, boolean isJson) {
        Map<String, AnomalyState> anomaliesById = this._recentAnomaliesByType.get(anomalyType);
        HashSet<Map<String, Object>> recentAnomalies = new HashSet<Map<String, Object>>(this._numCachedRecentAnomalyStates);
        for (Map.Entry<String, AnomalyState> entry : anomaliesById.entrySet()) {
            recentAnomalies.add(new AnomalyDetails(entry.getValue(), anomalyType, false, isJson).populateAnomalyDetails());
        }
        return recentAnomalies;
    }

    private Map<Boolean, Set<String>> getSelfHealingByEnableStatus() {
        HashMap<Boolean, Set<String>> selfHealingByEnableStatus = new HashMap<Boolean, Set<String>>(2);
        selfHealingByEnableStatus.put(true, new HashSet(KafkaAnomalyType.cachedValues().size()));
        selfHealingByEnableStatus.put(false, new HashSet(KafkaAnomalyType.cachedValues().size()));
        this._selfHealingEnabled.forEach((key, value) -> ((Set)selfHealingByEnableStatus.get(value)).add(key.toString()));
        return selfHealingByEnableStatus;
    }

    public synchronized Map<String, Object> getJsonStructure() {
        HashMap<String, Object> anomalyDetectorState = new HashMap<String, Object>(this._recentAnomaliesByType.size() + (this._ongoingSelfHealingAnomaly == null ? 5 : 6));
        Map<Boolean, Set<String>> selfHealingByEnableStatus = this.getSelfHealingByEnableStatus();
        anomalyDetectorState.put(SELF_HEALING_ENABLED, selfHealingByEnableStatus.get(true));
        anomalyDetectorState.put(SELF_HEALING_DISABLED, selfHealingByEnableStatus.get(false));
        anomalyDetectorState.put(SELF_HEALING_ENABLED_RATIO, this.selfHealingEnabledRatio().getJsonStructure());
        anomalyDetectorState.put(RECENT_GOAL_VIOLATIONS, this.recentAnomalies(KafkaAnomalyType.GOAL_VIOLATION, true));
        anomalyDetectorState.put(RECENT_BROKER_FAILURES, this.recentAnomalies(KafkaAnomalyType.BROKER_FAILURE, true));
        anomalyDetectorState.put(RECENT_METRIC_ANOMALIES, this.recentAnomalies(KafkaAnomalyType.METRIC_ANOMALY, true));
        anomalyDetectorState.put(RECENT_DISK_FAILURES, this.recentAnomalies(KafkaAnomalyType.DISK_FAILURE, true));
        anomalyDetectorState.put(RECENT_TOPIC_ANOMALIES, this.recentAnomalies(KafkaAnomalyType.TOPIC_ANOMALY, true));
        anomalyDetectorState.put(RECENT_MAINTENANCE_EVENTS, this.recentAnomalies(KafkaAnomalyType.MAINTENANCE_EVENT, true));
        anomalyDetectorState.put(METRICS, this.metrics());
        if (this._ongoingSelfHealingAnomaly != null) {
            anomalyDetectorState.put(ONGOING_SELF_HEALING_ANOMALY, this._ongoingSelfHealingAnomaly.anomalyId());
        }
        anomalyDetectorState.put(BALANCEDNESS_SCORE, this._balancednessScore);
        return anomalyDetectorState;
    }

    public synchronized String toString() {
        Map<Boolean, Set<String>> selfHealingByEnableStatus = this.getSelfHealingByEnableStatus();
        return String.format("{%s:%s, %s:%s, %s:%s, %s:%s, %s:%s, %s:%s, %s:%s, %s:%s, %s:%s, %s:%s, %s:%s, %s:%.3f}%n", SELF_HEALING_ENABLED, selfHealingByEnableStatus.get(true), SELF_HEALING_DISABLED, selfHealingByEnableStatus.get(false), SELF_HEALING_ENABLED_RATIO, this.selfHealingEnabledRatio().getJsonStructure(), RECENT_GOAL_VIOLATIONS, this.recentAnomalies(KafkaAnomalyType.GOAL_VIOLATION, false), RECENT_BROKER_FAILURES, this.recentAnomalies(KafkaAnomalyType.BROKER_FAILURE, false), RECENT_METRIC_ANOMALIES, this.recentAnomalies(KafkaAnomalyType.METRIC_ANOMALY, false), RECENT_DISK_FAILURES, this.recentAnomalies(KafkaAnomalyType.DISK_FAILURE, false), RECENT_TOPIC_ANOMALIES, this.recentAnomalies(KafkaAnomalyType.TOPIC_ANOMALY, false), RECENT_MAINTENANCE_EVENTS, this.recentAnomalies(KafkaAnomalyType.MAINTENANCE_EVENT, false), METRICS, this._metrics, ONGOING_SELF_HEALING_ANOMALY, this._ongoingSelfHealingAnomaly == null ? "None" : this._ongoingSelfHealingAnomaly.anomalyId(), BALANCEDNESS_SCORE, this._balancednessScore);
    }
}

