/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.detector;

import com.linkedin.cruisecontrol.detector.AnomalyType;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlUtils;
import com.linkedin.kafka.cruisecontrol.detector.AnomalyState;
import com.linkedin.kafka.cruisecontrol.detector.BrokerFailures;
import com.linkedin.kafka.cruisecontrol.detector.DiskFailures;
import com.linkedin.kafka.cruisecontrol.detector.GoalViolations;
import com.linkedin.kafka.cruisecontrol.detector.KafkaMetricAnomaly;
import com.linkedin.kafka.cruisecontrol.detector.TopicAnomaly;
import com.linkedin.kafka.cruisecontrol.detector.notifier.KafkaAnomalyType;
import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseClass;
import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseField;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonResponseClass
public class AnomalyDetails {
    @JsonResponseField
    protected static final String STATUS_UPDATE_MS = "statusUpdateMs";
    protected static final String STATUS_UPDATE_DATE = "statusUpdateDate";
    @JsonResponseField
    protected static final String DETECTION_MS = "detectionMs";
    protected static final String DETECTION_DATE = "detectionDate";
    @JsonResponseField
    protected static final String STATUS = "status";
    @JsonResponseField
    protected static final String ANOMALY_ID = "anomalyId";
    @JsonResponseField(required=false)
    protected static final String FIXABLE_VIOLATED_GOALS = "fixableViolatedGoals";
    @JsonResponseField(required=false)
    protected static final String UNFIXABLE_VIOLATED_GOALS = "unfixableViolatedGoals";
    @JsonResponseField(required=false)
    protected static final String FAILED_BROKERS_BY_TIME_MS = "failedBrokersByTimeMs";
    @JsonResponseField(required=false)
    protected static final String FAILED_DISKS_BY_TIME_MS = "failedDisksByTimeMs";
    @JsonResponseField(required=false)
    protected static final String OPTIMIZATION_RESULT = "optimizationResult";
    @JsonResponseField(required=false)
    protected static final String DESCRIPTION = "description";
    protected AnomalyState _anomalyState;
    protected AnomalyType _anomalyType;
    protected boolean _hasFixStarted;
    protected boolean _isJson;

    AnomalyDetails(AnomalyState anomalyState, AnomalyType anomalyType, boolean hasFixStarted, boolean isJson) {
        this._anomalyState = anomalyState;
        this._anomalyType = anomalyType;
        this._hasFixStarted = hasFixStarted;
        this._isJson = isJson;
    }

    public Map<String, Object> populateAnomalyDetails() {
        HashMap<String, Object> anomalyDetails = new HashMap<String, Object>((this._hasFixStarted ? 6 : 5) + (this._anomalyType == KafkaAnomalyType.GOAL_VIOLATION ? 1 : 0));
        anomalyDetails.put(this._isJson ? DETECTION_MS : DETECTION_DATE, this._isJson ? Long.valueOf(this._anomalyState.detectionMs()) : KafkaCruiseControlUtils.utcDateFor(this._anomalyState.detectionMs()));
        anomalyDetails.put(STATUS, (Object)this._anomalyState.status());
        anomalyDetails.put(ANOMALY_ID, this._anomalyState.anomalyId());
        anomalyDetails.put(this._isJson ? STATUS_UPDATE_MS : STATUS_UPDATE_DATE, this._isJson ? Long.valueOf(this._anomalyState.statusUpdateMs()) : KafkaCruiseControlUtils.utcDateFor(this._anomalyState.statusUpdateMs()));
        switch ((KafkaAnomalyType)this._anomalyType) {
            case GOAL_VIOLATION: {
                GoalViolations goalViolations = (GoalViolations)this._anomalyState.anomaly();
                Map<Boolean, List<String>> violatedGoalsByFixability = goalViolations.violatedGoalsByFixability();
                anomalyDetails.put(FIXABLE_VIOLATED_GOALS, violatedGoalsByFixability.getOrDefault(true, Collections.emptyList()));
                anomalyDetails.put(UNFIXABLE_VIOLATED_GOALS, violatedGoalsByFixability.getOrDefault(false, Collections.emptyList()));
                if (!this._hasFixStarted) break;
                anomalyDetails.put(OPTIMIZATION_RESULT, goalViolations.optimizationResult(this._isJson));
                break;
            }
            case BROKER_FAILURE: {
                BrokerFailures brokerFailures = (BrokerFailures)this._anomalyState.anomaly();
                anomalyDetails.put(FAILED_BROKERS_BY_TIME_MS, brokerFailures.failedBrokers());
                if (!this._hasFixStarted) break;
                anomalyDetails.put(OPTIMIZATION_RESULT, brokerFailures.optimizationResult(this._isJson));
                break;
            }
            case DISK_FAILURE: {
                DiskFailures diskFailures = (DiskFailures)this._anomalyState.anomaly();
                anomalyDetails.put(FAILED_DISKS_BY_TIME_MS, diskFailures.failedDisks());
                if (!this._hasFixStarted) break;
                anomalyDetails.put(OPTIMIZATION_RESULT, diskFailures.optimizationResult(this._isJson));
                break;
            }
            case METRIC_ANOMALY: {
                KafkaMetricAnomaly metricAnomaly = (KafkaMetricAnomaly)this._anomalyState.anomaly();
                anomalyDetails.put(DESCRIPTION, metricAnomaly.description());
                if (!this._hasFixStarted) break;
                anomalyDetails.put(OPTIMIZATION_RESULT, metricAnomaly.optimizationResult(this._isJson));
                break;
            }
            case TOPIC_ANOMALY: {
                TopicAnomaly topicAnomaly = (TopicAnomaly)this._anomalyState.anomaly();
                anomalyDetails.put(DESCRIPTION, topicAnomaly.toString());
                if (!this._hasFixStarted) break;
                anomalyDetails.put(OPTIMIZATION_RESULT, topicAnomaly.optimizationResult(this._isJson));
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized anomaly type " + this._anomalyType);
            }
        }
        return anomalyDetails;
    }
}

