/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.config.constants;

import com.linkedin.kafka.cruisecontrol.servlet.security.BasicSecurityProvider;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.config.ConfigDef;

public class WebServerConfig {
    public static final String WEBSERVER_HTTP_PORT_CONFIG = "webserver.http.port";
    public static final int DEFAULT_WEBSERVER_HTTP_PORT = 9090;
    public static final String WEBSERVER_HTTP_PORT_DOC = "Cruise Control Webserver bind port.";
    public static final String WEBSERVER_HTTP_ADDRESS_CONFIG = "webserver.http.address";
    public static final String DEFAULT_WEBSERVER_HTTP_ADDRESS = "127.0.0.1";
    public static final String WEBSERVER_HTTP_ADDRESS_DOC = "Cruise Control Webserver bind ip address.";
    public static final String WEBSERVER_HTTP_CORS_ENABLED_CONFIG = "webserver.http.cors.enabled";
    public static final boolean DEFAULT_WEBSERVER_HTTP_CORS_ENABLED = false;
    public static final String WEBSERVER_HTTP_CORS_ENABLED_DOC = "CORS enablement flag. true if enabled, false otherwise";
    public static final String TWO_STEP_VERIFICATION_ENABLED_CONFIG = "two.step.verification.enabled";
    public static final boolean DEFAULT_TWO_STEP_VERIFICATION_ENABLED = false;
    public static final String TWO_STEP_VERIFICATION_ENABLED_DOC = "Enable two-step verification for processing POST requests.";
    public static final String WEBSERVER_HTTP_CORS_ORIGIN_CONFIG = "webserver.http.cors.origin";
    public static final String DEFAULT_WEBSERVER_HTTP_CORS_ORIGIN = "*";
    public static final String WEBSERVER_HTTP_CORS_ORIGIN_DOC = "Value for the Access-Control-Allow-Origin header.";
    public static final String WEBSERVER_HTTP_CORS_ALLOWMETHODS_CONFIG = "webserver.http.cors.allowmethods";
    public static final String DEFAULT_WEBSERVER_HTTP_CORS_ALLOWMETHODS = "OPTIONS, GET, POST";
    public static final String WEBSERVER_HTTP_CORS_ALLOWMETHODS_DOC = "Value for the Access-Control-Request-Method header.";
    public static final String WEBSERVER_HTTP_CORS_EXPOSEHEADERS_CONFIG = "webserver.http.cors.exposeheaders";
    public static final String DEFAULT_WEBSERVER_HTTP_CORS_EXPOSEHEADERS = "User-Task-ID";
    public static final String WEBSERVER_HTTP_CORS_EXPOSEHEADERS_DOC = "Value for the Access-Control-Expose-Headers header.";
    public static final String WEBSERVER_API_URLPREFIX_CONFIG = "webserver.api.urlprefix";
    public static final String DEFAULT_WEBSERVER_API_URLPREFIX = "/kafkacruisecontrol/*";
    public static final String WEBSERVER_API_URLPREFIX_DOC = "REST API default url prefix";
    public static final String WEBSERVER_UI_DISKPATH_CONFIG = "webserver.ui.diskpath";
    public static final String DEFAULT_WEBSERVER_UI_DISKPATH = "./cruise-control-ui/dist/";
    public static final String WEBSERVER_UI_DISKPATH_DOC = "Location where the Cruise Control frontend is deployed";
    public static final String WEBSERVER_UI_URLPREFIX_CONFIG = "webserver.ui.urlprefix";
    public static final String DEFAULT_WEBSERVER_UI_URLPREFIX = "/*";
    public static final String WEBSERVER_UI_URLPREFIX_DOC = "URL Path where UI is served from";
    public static final String WEBSERVER_REQUEST_MAX_BLOCK_TIME_MS_CONFIG = "webserver.request.maxBlockTimeMs";
    public static final long DEFAULT_WEBSERVER_REQUEST_MAX_BLOCK_TIME_MS = 10000L;
    public static final String WEBSERVER_REQUEST_MAX_BLOCK_TIME_MS_DOC = "Time after which request is converted to Async";
    public static final String WEBSERVER_SESSION_EXPIRY_MS_CONFIG = "webserver.session.maxExpiryTimeMs";
    public static final long DEFAULT_WEBSERVER_SESSION_EXPIRY_MS = 60000L;
    public static final String WEBSERVER_SESSION_EXPIRY_MS_DOC = "Default Session Expiry Period";
    public static final String WEBSERVER_SESSION_PATH_CONFIG = "webserver.session.path";
    public static final String DEFAULT_WEBSERVER_SESSION_PATH = "/";
    public static final String WEBSERVER_SESSION_PATH_DOC = "Default Session Path (for cookies)";
    public static final String WEBSERVER_ACCESSLOG_ENABLED_CONFIG = "webserver.accesslog.enabled";
    public static final boolean DEFAULT_WEBSERVER_ACCESSLOG_ENABLED = true;
    public static final String WEBSERVER_ACCESSLOG_ENABLED_DOC = "true if access log is enabled";
    public static final String WEBSERVER_ACCESSLOG_PATH_CONFIG = "webserver.accesslog.path";
    public static final String DEFAULT_WEBSERVER_ACCESSLOG_PATH = "access.log";
    public static final String WEBSERVER_ACCESSLOG_PATH_DOC = "HTTP Request log path";
    public static final String WEBSERVER_ACCESSLOG_RETENTION_DAYS_CONFIG = "webserver.accesslog.retention.days";
    public static final int DEFAULT_WEBSERVER_ACCESSLOG_RETENTION_DAYS = 7;
    public static final String WEBSERVER_ACCESSLOG_RETENTION_DAYS_DOC = "HTTP Request log retention days";
    public static final String TWO_STEP_PURGATORY_RETENTION_TIME_MS_CONFIG = "two.step.purgatory.retention.time.ms";
    public static final long DEFAULT_TWO_STEP_PURGATORY_RETENTION_TIME_MS = TimeUnit.HOURS.toMillis(336L);
    public static final String TWO_STEP_PURGATORY_RETENTION_TIME_MS_DOC = "The maximum time in milliseconds to retain the requests in two-step (verification) purgatory.";
    public static final String TWO_STEP_PURGATORY_MAX_REQUESTS_CONFIG = "two.step.purgatory.max.requests";
    public static final int DEFAULT_TWO_STEP_PURGATORY_MAX_REQUESTS = 25;
    public static final String TWO_STEP_PURGATORY_MAX_REQUESTS_DOC = "The maximum number of requests in two-step (verification) purgatory.";
    public static final String MAX_ACTIVE_USER_TASKS_CONFIG = "max.active.user.tasks";
    public static final int DEFAULT_MAX_ACTIVE_USER_TASKS = 5;
    public static final String MAX_ACTIVE_USER_TASKS_DOC = "The maximum number of user tasks for concurrently running in async endpoints across all users.";
    public static final String WEBSERVER_SECURITY_PROVIDER_CONFIG = "webserver.security.provider";
    private static final String DEFAULT_WEBSERVER_SECURITY_PROVIDER = BasicSecurityProvider.class.getName();
    private static final String WEBSERVER_SECURITY_PROVIDER_DOC = "SecurityProvider implementation for defining authentication and authorization rules for accessing the web API.";
    public static final String WEBSERVER_SECURITY_ENABLE_CONFIG = "webserver.security.enable";
    public static final boolean DEFAULT_WEBSERVER_SECURITY_ENABLE = false;
    private static final String WEBSERVER_SECURITY_ENABLE_DOC = "Enables the use of authentication and authorization features.";
    public static final String WEBSERVER_AUTH_CREDENTIALS_FILE_CONFIG = "webserver.auth.credentials.file";
    public static final String DEFAULT_WEBSERVER_AUTH_CREDENTIALS_FILE = "/etc/cruisecontrol-basic-auth.credentials";
    private static final String WEBSERVER_AUTH_CREDENTIALS_FILE_DOC = "A file that contains credentials for authentication and roles for authorization. The format of the file is the following: username: password [,rolename ...] which corresponds to Jetty's HashLoginService's credentials file format.";
    public static final String WEBSERVER_SSL_ENABLE_CONFIG = "webserver.ssl.enable";
    public static final boolean DEFAULT_WEBSERVER_SSL_ENABLE = false;
    private static final String WEBSERVER_SSL_ENABLE_DOC = "Enables SSL on the webserver.";
    public static final String WEBSERVER_SSL_KEYSTORE_LOCATION_CONFIG = "webserver.ssl.keystore.location";
    public static final String DEFAULT_WEBSERVER_SSL_KEYSTORE_LOCATION = null;
    private static final String WEBSERVER_SSL_KEYSTORE_LOCATION_DOC = "The location of the SSL keystore file";
    public static final String WEBSERVER_SSL_KEYSTORE_PASSWORD_CONFIG = "webserver.ssl.keystore.password";
    public static final String DEFAULT_WEBSERVER_SSL_KEYSTORE_PASSWORD = null;
    private static final String WEBSERVER_SSL_KEYSTORE_PASSWORD_DOC = "The store password for the key store file. If this isn't set we fall back to Jetty's default behavior.";
    public static final String WEBSERVER_SSL_KEYSTORE_TYPE_CONFIG = "webserver.ssl.keystore.type";
    public static final String DEFAULT_WEBSERVER_SSL_KEYSTORE_TYPE = null;
    private static final String WEBSERVER_SSL_KEYSTORE_TYPE_DOC = "The file format of the key store file. This is an optional config. If this isn't set we fall back to Jetty's default behavior.";
    public static final String WEBSERVER_SSL_KEY_PASSWORD_CONFIG = "webserver.ssl.key.password";
    public static final String DEFAULT_WEBSERVER_SSL_KEY_PASSWORD = null;
    private static final String WEBSERVER_SSL_KEY_PASSWORD_DOC = "The password of the private key in the key store file.";
    public static final String WEBSERVER_SSL_PROTOCOL_CONFIG = "webserver.ssl.protocol";
    public static final String DEFAULT_WEBSERVER_SSL_PROTOCOL = "TLS";
    private static final String WEBSERVER_SSL_PROTOCOL_DOC = "Sets the SSL protocol to use. By default it's TLS.";
    public static final String JWT_AUTHENTICATION_PROVIDER_URL_CONFIG = "jwt.authentication.provider.url";
    public static final String DEFAULT_JWT_AUTHENTICATION_PROVIDER_URL = null;
    private static final String JWT_AUTHENTICATION_PROVIDER_URL_DOC = "This is an endpoint of the token issuer. Requests without tokens will be redirected to this endpoint for authentication. The given url can contain the {redirectUrl} string which is an instruction to the authentication service to redirect to the original Cruise Control URL after a successful login. For instance www.my-auth.service.com/websso?origin={redirectUrl}.";
    public static final String JWT_COOKIE_NAME_CONFIG = "jwt.cookie.name";
    public static final String DEFAULT_JWT_COOKIE_NAME = null;
    private static final String JWT_COOKIE_NAME_DOC = "Cruise Control expects issued tokens to be forwarded in a cookie. This config specifies which one will contain the token.";
    public static final String JWT_AUTH_CERTIFICATE_LOCATION_CONFIG = "jwt.auth.certificate.location";
    public static final String DEFAULT_JWT_AUTH_CERTIFICATE_LOCATION = null;
    private static final String JWT_AUTH_CERTIFICATE_LOCATION_DOC = "A private key is used to sign the JWT token by the authentication service and its public key pair is used to validate the signature in the token. This config points to the location of the file containing that public key.";
    public static final String JWT_EXPECTED_AUDIENCES_CONFIG = "jwt.expected.audiences";
    public static final String DEFAULT_JWT_EXPECTED_AUDIENCES = null;
    private static final String JWT_EXPECTED_AUDIENCES_DOC = "A comma separated list of audiences that Cruise Control accepts. Audience is a way for the issuer to indicate what entities the token is intended for. The default value is null, which means all audiences are accepted.";
    public static final String SPNEGO_KEYTAB_FILE_CONFIG = "spnego.keytab.file";
    public static final String DEFAULT_SPNEGO_KEYTAB_FILE = null;
    private static final String SPNEGO_KEYTAB_FILE_DOC = "Specifies the path to the keytab which contains the spnego principal that is used for SPNEGO based authentication methods.";
    public static final String SPNEGO_PRINCIPAL_CONFIG = "spnego.principal";
    public static final String DEFAULT_SPNEGO_PRINCIPAL = null;
    private static final String SPNEGO_PRINCIPAL_DOC = "Specifies the spnego service principal that is used by Cruise Control to authenticate clients. This principal is stored in spnego.keytab.file. This must be a fully qualified principal in the service/host@REALM format (service is usually HTTP).";
    public static final String TRUSTED_PROXY_SERVICES_CONFIG = "trusted.proxy.services";
    public static final String DEFAULT_TRUSTED_PROXY_SERVICES = null;
    private static final String TRUSTED_PROXY_SERVICES_DOC = "A list of trusted proxies who can delegate user commands with the doAs query parameter.";
    public static final String TRUSTED_PROXY_SERVICES_IP_REGEX_CONFIG = "trusted.proxy.services.ip.regex";
    public static final String DEFAULT_TRUSTED_PROXY_SERVICES_IP_REGEX = null;
    private static final String TRUSTED_PROXY_SERVICES_IP_REGEX_DOC = "A Java regular expression that defines the whitelist of IP addresses of the trusted proxy services. If a request arrives from these addresses authenticated as one of the specified trusted.proxy.services then the operation will be delegated as the user in the doAs parameter. This is an optional parameter. Not specifying this means that the IP of the trusted proxy won't be validated.";

    private WebServerConfig() {
    }

    public static ConfigDef define(ConfigDef configDef) {
        return configDef.define(WEBSERVER_HTTP_PORT_CONFIG, ConfigDef.Type.INT, (Object)9090, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.HIGH, WEBSERVER_HTTP_PORT_DOC).define(WEBSERVER_HTTP_ADDRESS_CONFIG, ConfigDef.Type.STRING, (Object)DEFAULT_WEBSERVER_HTTP_ADDRESS, ConfigDef.Importance.HIGH, WEBSERVER_HTTP_ADDRESS_DOC).define(WEBSERVER_HTTP_CORS_ENABLED_CONFIG, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, WEBSERVER_HTTP_CORS_ENABLED_DOC).define(TWO_STEP_VERIFICATION_ENABLED_CONFIG, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.MEDIUM, TWO_STEP_VERIFICATION_ENABLED_DOC).define(WEBSERVER_HTTP_CORS_ORIGIN_CONFIG, ConfigDef.Type.STRING, (Object)DEFAULT_WEBSERVER_HTTP_CORS_ORIGIN, ConfigDef.Importance.LOW, WEBSERVER_HTTP_CORS_ORIGIN_DOC).define(WEBSERVER_HTTP_CORS_ALLOWMETHODS_CONFIG, ConfigDef.Type.STRING, (Object)DEFAULT_WEBSERVER_HTTP_CORS_ALLOWMETHODS, ConfigDef.Importance.HIGH, WEBSERVER_HTTP_CORS_ALLOWMETHODS_DOC).define(WEBSERVER_HTTP_CORS_EXPOSEHEADERS_CONFIG, ConfigDef.Type.STRING, (Object)DEFAULT_WEBSERVER_HTTP_CORS_EXPOSEHEADERS, ConfigDef.Importance.HIGH, WEBSERVER_HTTP_CORS_EXPOSEHEADERS_DOC).define(WEBSERVER_API_URLPREFIX_CONFIG, ConfigDef.Type.STRING, (Object)DEFAULT_WEBSERVER_API_URLPREFIX, ConfigDef.Importance.HIGH, WEBSERVER_API_URLPREFIX_DOC).define(WEBSERVER_UI_DISKPATH_CONFIG, ConfigDef.Type.STRING, (Object)DEFAULT_WEBSERVER_UI_DISKPATH, ConfigDef.Importance.MEDIUM, WEBSERVER_UI_DISKPATH_DOC).define(WEBSERVER_UI_URLPREFIX_CONFIG, ConfigDef.Type.STRING, (Object)DEFAULT_WEBSERVER_UI_URLPREFIX, ConfigDef.Importance.MEDIUM, WEBSERVER_UI_URLPREFIX_DOC).define(WEBSERVER_REQUEST_MAX_BLOCK_TIME_MS_CONFIG, ConfigDef.Type.LONG, (Object)10000L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0L), ConfigDef.Importance.HIGH, WEBSERVER_REQUEST_MAX_BLOCK_TIME_MS_DOC).define(WEBSERVER_SESSION_EXPIRY_MS_CONFIG, ConfigDef.Type.LONG, (Object)60000L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0L), ConfigDef.Importance.HIGH, WEBSERVER_SESSION_EXPIRY_MS_DOC).define(WEBSERVER_SESSION_PATH_CONFIG, ConfigDef.Type.STRING, (Object)DEFAULT_WEBSERVER_SESSION_PATH, ConfigDef.Importance.HIGH, WEBSERVER_SESSION_PATH_DOC).define(WEBSERVER_ACCESSLOG_ENABLED_CONFIG, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.MEDIUM, WEBSERVER_ACCESSLOG_ENABLED_DOC).define(WEBSERVER_ACCESSLOG_PATH_CONFIG, ConfigDef.Type.STRING, (Object)DEFAULT_WEBSERVER_ACCESSLOG_PATH, ConfigDef.Importance.LOW, WEBSERVER_ACCESSLOG_PATH_DOC).define(WEBSERVER_ACCESSLOG_RETENTION_DAYS_CONFIG, ConfigDef.Type.INT, (Object)7, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.LOW, WEBSERVER_ACCESSLOG_RETENTION_DAYS_DOC).define(TWO_STEP_PURGATORY_RETENTION_TIME_MS_CONFIG, ConfigDef.Type.LONG, (Object)DEFAULT_TWO_STEP_PURGATORY_RETENTION_TIME_MS, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)TimeUnit.HOURS.toMillis(1L)), ConfigDef.Importance.MEDIUM, TWO_STEP_PURGATORY_RETENTION_TIME_MS_DOC).define(TWO_STEP_PURGATORY_MAX_REQUESTS_CONFIG, ConfigDef.Type.INT, (Object)25, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, TWO_STEP_PURGATORY_MAX_REQUESTS_DOC).define(MAX_ACTIVE_USER_TASKS_CONFIG, ConfigDef.Type.INT, (Object)5, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, MAX_ACTIVE_USER_TASKS_DOC).define(WEBSERVER_SECURITY_ENABLE_CONFIG, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.MEDIUM, WEBSERVER_SECURITY_ENABLE_DOC).define(WEBSERVER_SECURITY_PROVIDER_CONFIG, ConfigDef.Type.CLASS, (Object)DEFAULT_WEBSERVER_SECURITY_PROVIDER, ConfigDef.Importance.MEDIUM, WEBSERVER_SECURITY_PROVIDER_DOC).define(WEBSERVER_AUTH_CREDENTIALS_FILE_CONFIG, ConfigDef.Type.STRING, (Object)DEFAULT_WEBSERVER_AUTH_CREDENTIALS_FILE, ConfigDef.Importance.MEDIUM, WEBSERVER_AUTH_CREDENTIALS_FILE_DOC).define(WEBSERVER_SSL_ENABLE_CONFIG, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.MEDIUM, WEBSERVER_SSL_ENABLE_DOC).define(WEBSERVER_SSL_KEYSTORE_LOCATION_CONFIG, ConfigDef.Type.STRING, (Object)DEFAULT_WEBSERVER_SSL_KEYSTORE_LOCATION, ConfigDef.Importance.MEDIUM, WEBSERVER_SSL_KEYSTORE_LOCATION_DOC).define(WEBSERVER_SSL_KEYSTORE_PASSWORD_CONFIG, ConfigDef.Type.PASSWORD, (Object)DEFAULT_WEBSERVER_SSL_KEYSTORE_PASSWORD, ConfigDef.Importance.MEDIUM, WEBSERVER_SSL_KEYSTORE_PASSWORD_DOC).define(WEBSERVER_SSL_KEYSTORE_TYPE_CONFIG, ConfigDef.Type.STRING, (Object)DEFAULT_WEBSERVER_SSL_KEYSTORE_TYPE, ConfigDef.Importance.MEDIUM, WEBSERVER_SSL_KEYSTORE_TYPE_DOC).define(WEBSERVER_SSL_KEY_PASSWORD_CONFIG, ConfigDef.Type.PASSWORD, (Object)DEFAULT_WEBSERVER_SSL_KEY_PASSWORD, ConfigDef.Importance.MEDIUM, WEBSERVER_SSL_KEY_PASSWORD_DOC).define(WEBSERVER_SSL_PROTOCOL_CONFIG, ConfigDef.Type.STRING, (Object)DEFAULT_WEBSERVER_SSL_PROTOCOL, ConfigDef.Importance.MEDIUM, WEBSERVER_SSL_PROTOCOL_DOC).define(JWT_AUTHENTICATION_PROVIDER_URL_CONFIG, ConfigDef.Type.STRING, (Object)DEFAULT_JWT_AUTHENTICATION_PROVIDER_URL, ConfigDef.Importance.MEDIUM, JWT_AUTHENTICATION_PROVIDER_URL_DOC).define(JWT_COOKIE_NAME_CONFIG, ConfigDef.Type.STRING, (Object)DEFAULT_JWT_COOKIE_NAME, ConfigDef.Importance.MEDIUM, JWT_COOKIE_NAME_DOC).define(JWT_AUTH_CERTIFICATE_LOCATION_CONFIG, ConfigDef.Type.STRING, (Object)DEFAULT_JWT_AUTH_CERTIFICATE_LOCATION, ConfigDef.Importance.MEDIUM, JWT_AUTH_CERTIFICATE_LOCATION_DOC).define(JWT_EXPECTED_AUDIENCES_CONFIG, ConfigDef.Type.LIST, (Object)DEFAULT_JWT_EXPECTED_AUDIENCES, ConfigDef.Importance.MEDIUM, JWT_EXPECTED_AUDIENCES_DOC).define(SPNEGO_KEYTAB_FILE_CONFIG, ConfigDef.Type.STRING, (Object)DEFAULT_SPNEGO_KEYTAB_FILE, ConfigDef.Importance.MEDIUM, SPNEGO_KEYTAB_FILE_DOC).define(SPNEGO_PRINCIPAL_CONFIG, ConfigDef.Type.STRING, (Object)DEFAULT_SPNEGO_PRINCIPAL, ConfigDef.Importance.MEDIUM, SPNEGO_PRINCIPAL_DOC).define(TRUSTED_PROXY_SERVICES_CONFIG, ConfigDef.Type.LIST, (Object)DEFAULT_TRUSTED_PROXY_SERVICES, ConfigDef.Importance.MEDIUM, TRUSTED_PROXY_SERVICES_DOC).define(TRUSTED_PROXY_SERVICES_IP_REGEX_CONFIG, ConfigDef.Type.STRING, (Object)DEFAULT_TRUSTED_PROXY_SERVICES_IP_REGEX, ConfigDef.Importance.MEDIUM, TRUSTED_PROXY_SERVICES_IP_REGEX_DOC);
    }
}

