/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.config.constants;

import com.linkedin.kafka.cruisecontrol.common.KafkaNetworkClientProvider;
import com.linkedin.kafka.cruisecontrol.config.BrokerCapacityConfigFileResolver;
import com.linkedin.kafka.cruisecontrol.config.KafkaTopicConfigProvider;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.CruiseControlMetricsReporterSampler;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.DefaultMetricSamplerPartitionAssignor;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.KafkaSampleStore;
import org.apache.kafka.clients.CommonClientConfigs;
import org.apache.kafka.common.config.ConfigDef;

public class MonitorConfig {
    public static final String BOOTSTRAP_SERVERS_CONFIG = "bootstrap.servers";
    public static final String BOOTSTRAP_SERVERS_DOC = "A list of host/port pairs to use for establishing the initial connection to the Kafka cluster. The client will make use of all servers irrespective of which servers are specified here for bootstrapping&mdash;this list only impacts the initial hosts used to discover the full set of servers. This list should be in the form <code>host1:port1,host2:port2,...</code>. Since these servers are just used for the initial connection to discover the full cluster membership (which may change dynamically), this list need not contain the full set of servers (you may want more than one, though, in case a server is down).";
    public static final String SECURITY_PROTOCOL_CONFIG = "security.protocol";
    public static final String DEFAULT_SECURITY_PROTOCOL = "PLAINTEXT";
    public static final String SECURITY_PROTOCOL_DOC = CommonClientConfigs.SECURITY_PROTOCOL_DOC;
    public static final String METADATA_MAX_AGE_CONFIG = "metadata.max.age.ms";
    public static final long DEFAULT_METADATA_MAX_AGE = 55000L;
    public static final String METADATA_MAX_AGE_DOC = "The period of time in milliseconds after which we force a refresh of metadata even if we haven't seen any partition leadership changes to proactively discover any new brokers or partitions.";
    public static final String CLIENT_ID_CONFIG = "client.id";
    public static final String DEFAULT_CLIENT_ID = "kafka-cruise-control";
    public static final String CLIENT_ID_DOC = "An id string to pass to the server when making requests. The purpose of this is to be able to track the source of requests beyond just ip/port by allowing a logical application name to be included in server-side request logging.";
    public static final String SEND_BUFFER_CONFIG = "send.buffer.bytes";
    public static final int DEFAULT_SEND_BUFFER = 131072;
    public static final String SEND_BUFFER_DOC = "The size of the TCP send buffer (SO_SNDBUF) to use when sending data. If the value is -1, the OS default will be used.";
    public static final String RECEIVE_BUFFER_CONFIG = "receive.buffer.bytes";
    public static final int DEFAULT_RECEIVE_BUFFER = 32768;
    public static final String RECEIVE_BUFFER_DOC = "The size of the TCP receive buffer (SO_RCVBUF) to use when reading data. If the value is -1, the OS default will be used.";
    public static final String CONNECTIONS_MAX_IDLE_MS_CONFIG = "connections.max.idle.ms";
    public static final long DEFAULT_CONNECTIONS_MAX_IDLE_MS = 540000L;
    public static final String CONNECTIONS_MAX_IDLE_MS_DOC = "Close idle connections after the number of milliseconds specified by this config.";
    public static final String RECONNECT_BACKOFF_MS_CONFIG = "reconnect.backoff.ms";
    public static final long DEFAULT_RECONNECT_BACKOFF_MS = 50L;
    public static final String RECONNECT_BACKOFF_MS_DOC = "The base amount of time to wait before attempting to reconnect to a given host. This avoids repeatedly connecting to a host in a tight loop. This backoff applies to all connection attempts by the client to a broker.";
    public static final String REQUEST_TIMEOUT_MS_CONFIG = "request.timeout.ms";
    public static final int DEFAULT_REQUEST_TIMEOUT_MS = 30000;
    public static final String REQUEST_TIMEOUT_MS_DOC = "The configuration controls the maximum amount of time the client will wait for the response of a request. If the response is not received before the timeout elapses the client will resend the request if necessary or fail the request if retries are exhausted.";
    public static final String PARTITION_METRICS_WINDOW_MS_CONFIG = "partition.metrics.window.ms";
    public static final long DEFAULT_PARTITION_METRICS_WINDOW_MS = 3600000L;
    public static final String PARTITION_METRICS_WINDOW_MS_DOC = "The size of the window in milliseconds to aggregate the Kafka partition metrics.";
    public static final String NUM_PARTITION_METRICS_WINDOWS_CONFIG = "num.partition.metrics.windows";
    public static final int DEFAULT_NUM_PARTITION_METRICS_WINDOWS = 5;
    public static final String NUM_PARTITION_METRICS_WINDOWS_DOC = "The total number of windows to keep for partition metric samples";
    public static final String NETWORK_CLIENT_PROVIDER_CLASS_CONFIG = "network.client.provider.class";
    public static final String DEFAULT_NETWORK_CLIENT_PROVIDER_CLASS = KafkaNetworkClientProvider.class.getName();
    public static final String NETWORK_CLIENT_PROVIDER_CLASS_DOC = "The network client provider class to generate a network client with given properties.";
    public static final String SKIP_LOADING_SAMPLES_CONFIG = "skip.loading.samples";
    public static final boolean DEFAULT_SKIP_LOADING_SAMPLES = false;
    public static final String SKIP_LOADING_SAMPLES_DOC = "Specify if sample loading will be skipped upon startup.";
    public static final String MIN_SAMPLES_PER_PARTITION_METRICS_WINDOW_CONFIG = "min.samples.per.partition.metrics.window";
    public static final int DEFAULT_MIN_SAMPLES_PER_PARTITION_METRICS_WINDOW = 3;
    public static final String MIN_SAMPLES_PER_PARTITION_METRICS_WINDOW_DOC = "The minimum number of PartitionMetricSamples needed to make a partition metrics window valid without extrapolation.";
    public static final String MAX_ALLOWED_EXTRAPOLATIONS_PER_PARTITION_CONFIG = "max.allowed.extrapolations.per.partition";
    public static final int DEFAULT_MAX_ALLOWED_EXTRAPOLATIONS_PER_PARTITION = 5;
    public static final String MAX_ALLOWED_EXTRAPOLATIONS_PER_PARTITION_DOC = "The maximum allowed number of extrapolations for each partition. A partition will be considered as invalid if the total number extrapolations in all the windows goes above this number.";
    public static final String PARTITION_METRIC_SAMPLE_AGGREGATOR_COMPLETENESS_CACHE_SIZE_CONFIG = "partition.metric.sample.aggregator.completeness.cache.size";
    public static final int DEFAULT_PARTITION_METRIC_SAMPLE_AGGREGATOR_COMPLETENESS_CACHE_SIZE = 5;
    public static final String PARTITION_METRIC_SAMPLE_AGGREGATOR_COMPLETENESS_CACHE_SIZE_DOC = "The metric sample aggregator caches the completeness metadata for fast query. The completeness describes the confidence level of the data in the metric sample aggregator. It is primarily measured by the validity of the metricssamples in different windows. This configuration configures The number of completeness cache slots to maintain.";
    public static final String BROKER_METRICS_WINDOW_MS_CONFIG = "broker.metrics.window.ms";
    public static final long DEFAULT_BROKER_METRICS_WINDOW_MS = 3600000L;
    public static final String BROKER_METRICS_WINDOW_MS_DOC = "The size of the window in milliseconds to aggregate the Kafka broker metrics.";
    public static final String NUM_BROKER_METRICS_WINDOWS_CONFIG = "num.broker.metrics.windows";
    public static final int DEFAULT_NUM_BROKER_METRICS_WINDOWS = 5;
    public static final String NUM_BROKER_METRICS_WINDOWS_DOC = "The total number of windows to keep for broker metric samples";
    public static final String MIN_SAMPLES_PER_BROKER_METRICS_WINDOW_CONFIG = "min.samples.per.broker.metrics.window";
    public static final int DEFAULT_MIN_SAMPLES_PER_BROKER_METRICS_WINDOW = 3;
    public static final String MIN_SAMPLES_PER_BROKER_METRICS_WINDOW_DOC = "The minimum number of BrokerMetricSamples needed to make a broker metrics window valid without extrapolation.";
    public static final String MAX_ALLOWED_EXTRAPOLATIONS_PER_BROKER_CONFIG = "max.allowed.extrapolations.per.broker";
    public static final int DEFAULT_MAX_ALLOWED_EXTRAPOLATIONS_PER_BROKER = 5;
    public static final String MAX_ALLOWED_EXTRAPOLATIONS_PER_BROKER_DOC = "The maximum allowed number of extrapolations for each broker. A broker will be considered as invalid if the total number extrapolations in all the windows goes above this number.";
    public static final String BROKER_METRIC_SAMPLE_AGGREGATOR_COMPLETENESS_CACHE_SIZE_CONFIG = "broker.metric.sample.aggregator.completeness.cache.size";
    public static final int DEFAULT_METRIC_SAMPLE_AGGREGATOR_COMPLETENESS_CACHE_SIZE_CONFIG = 5;
    public static final String BROKER_METRIC_SAMPLE_AGGREGATOR_COMPLETENESS_CACHE_SIZE_DOC = "The metric sample aggregator caches the completeness metadata for fast query. The completeness describes the confidence level of the data in the metric sample aggregator. It is primarily measured by the validity of the metricssamples in different windows. This configuration configures The number of completeness cache slots to maintain.";
    @Deprecated
    public static final String NUM_METRIC_FETCHERS_CONFIG = "num.metric.fetchers";
    public static final int DEFAULT_NUM_METRIC_FETCHERS = 1;
    public static final String NUM_METRIC_FETCHERS_DOC = "The number of metric fetchers to fetch from the Kafka cluster.";
    public static final String METRIC_SAMPLER_CLASS_CONFIG = "metric.sampler.class";
    public static final String DEFAULT_METRIC_SAMPLER_CLASS = CruiseControlMetricsReporterSampler.class.getName();
    public static final String METRIC_SAMPLER_CLASS_DOC = "The class name of the metric sampler";
    public static final String METRIC_SAMPLER_PARTITION_ASSIGNOR_CLASS_CONFIG = "metric.sampler.partition.assignor.class";
    public static final String DEFAULT_METRIC_SAMPLER_PARTITION_ASSIGNOR_CLASS = DefaultMetricSamplerPartitionAssignor.class.getName();
    public static final String METRIC_SAMPLER_PARTITION_ASSIGNOR_CLASS_DOC = "The class used to assign the partitions to the metric samplers.";
    public static final String METRIC_SAMPLING_INTERVAL_MS_CONFIG = "metric.sampling.interval.ms";
    public static final long DEFAULT_METRIC_SAMPLING_INTERVAL_MS = 60000L;
    public static final String METRIC_SAMPLING_INTERVAL_MS_DOC = "The interval of metric sampling.";
    public static final String MIN_VALID_PARTITION_RATIO_CONFIG = "min.valid.partition.ratio";
    public static final double DEFAULT_MIN_VALID_PARTITION_RATIO = 0.995;
    public static final String MIN_VALID_PARTITION_RATIO_DOC = "The minimum percentage of the total partitions required to be monitored in order to generate a valid load model. Because the topic and partitions in a Kafka cluster are dynamically changing. The load monitor will exclude some of the topics that does not have sufficient metric samples. This configuration defines the minimum required percentage of the partitions that must be included in the load model.";
    public static final String LEADER_NETWORK_INBOUND_WEIGHT_FOR_CPU_UTIL_CONFIG = "leader.network.inbound.weight.for.cpu.util";
    public static final double DEFAULT_LEADER_NETWORK_INBOUND_WEIGHT_FOR_CPU_UTIL = 0.7;
    public static final String LEADER_NETWORK_INBOUND_WEIGHT_FOR_CPU_UTIL_DOC = "Kafka Cruise Control uses the following model to derive replica level CPU utilization: REPLICA_CPU_UTIL = a * LEADER_BYTES_IN_RATE + b * LEADER_BYTES_OUT_RATE + c * FOLLOWER_BYTES_IN_RATE. This configuration will be used as the weight for LEADER_BYTES_IN_RATE.";
    public static final String LEADER_NETWORK_OUTBOUND_WEIGHT_FOR_CPU_UTIL_CONFIG = "leader.network.outbound.weight.for.cpu.util";
    public static final double DEFAULT_LEADER_NETWORK_OUTBOUND_WEIGHT_FOR_CPU_UTIL = 0.15;
    public static final String LEADER_NETWORK_OUTBOUND_WEIGHT_FOR_CPU_UTIL_DOC = "Kafka Cruise Control uses the following model to derive replica level CPU utilization: REPLICA_CPU_UTIL = a * LEADER_BYTES_IN_RATE + b * LEADER_BYTES_OUT_RATE + c * FOLLOWER_BYTES_IN_RATE. This configuration will be used as the weight for LEADER_BYTES_OUT_RATE.";
    public static final String FOLLOWER_NETWORK_INBOUND_WEIGHT_FOR_CPU_UTIL_CONFIG = "follower.network.inbound.weight.for.cpu.util";
    public static final double DEFAULT_FOLLOWER_NETWORK_INBOUND_WEIGHT_FOR_CPU_UTIL = 0.15;
    public static final String FOLLOWER_NETWORK_INBOUND_WEIGHT_FOR_CPU_UTIL_DOC = "Kafka Cruise Control uses the following model to derive replica level CPU utilization: REPLICA_CPU_UTIL = a * LEADER_BYTES_IN_RATE + b * LEADER_BYTES_OUT_RATE + c * FOLLOWER_BYTES_IN_RATE. This configuration will be used as the weight for FOLLOWER_BYTES_IN_RATE.";
    public static final String LINEAR_REGRESSION_MODEL_CPU_UTIL_BUCKET_SIZE_CONFIG = "linear.regression.model.cpu.util.bucket.size";
    public static final int DEFAULT_LINEAR_REGRESSION_MODEL_CPU_UTIL_BUCKET_SIZE = 5;
    public static final String LINEAR_REGRESSION_MODEL_CPU_UTIL_BUCKET_SIZE_DOC = "The CPU utilization bucket size for linear regression model training data. The unit is percents.";
    public static final String LINEAR_REGRESSION_MODEL_REQUIRED_SAMPLES_PER_CPU_UTIL_BUCKET_CONFIG = "linear.regression.model.required.samples.per.bucket";
    public static final int DEFAULT_LINEAR_REGRESSION_MODEL_REQUIRED_SAMPLES_PER_CPU_UTIL_BUCKET = 100;
    public static final String LINEAR_REGRESSION_MODEL_REQUIRED_SAMPLES_PER_CPU_UTIL_BUCKET_DOC = "The number of training samples required in each CPU utilization bucket specified by linear.regression.model.cpu.util.bucket";
    public static final String LINEAR_REGRESSION_MODEL_MIN_NUM_CPU_UTIL_BUCKETS_CONFIG = "linear.regression.model.min.num.cpu.util.buckets";
    public static final int DEFAULT_LINEAR_REGRESSION_MODEL_MIN_NUM_CPU_UTIL_BUCKETS = 5;
    public static final String LINEAR_REGRESSION_MODEL_MIN_NUM_CPU_UTIL_BUCKETS_DOC = "The minimum number of full CPU utilization buckets required to generate a linear regression model.";
    public static final String SAMPLING_ALLOW_CPU_CAPACITY_ESTIMATION_CONFIG = "sampling.allow.cpu.capacity.estimation";
    public static final boolean DEFAULT_SAMPLING_ALLOW_CPU_CAPACITY_ESTIMATION = true;
    public static final String SAMPLING_ALLOW_CPU_CAPACITY_ESTIMATION_DOC = "The flag to indicate whether sampling process allows CPU capacity estimation of brokers used for CPU utilization estimation.";
    public static final String USE_LINEAR_REGRESSION_MODEL_CONFIG = "use.linear.regression.model";
    public static final boolean DEFAULT_USE_LINEAR_REGRESSION_MODEL_CONFIG = false;
    public static final String USE_LINEAR_REGRESSION_MODEL_DOC = "Use the linear regression model to estimate the cpu utilization.";
    public static final String SAMPLE_STORE_CLASS_CONFIG = "sample.store.class";
    public static final String DEFAULT_SAMPLE_STORE_CLASS = KafkaSampleStore.class.getName();
    public static final String SAMPLE_STORE_CLASS_DOC = "The sample store class name. User may configure a sample store that persist the metric samples that have already been aggregated into Kafka Cruise Control. Later on the persisted samples can be reloaded from the sample store to Kafka Cruise Control.";
    public static final String TOPIC_CONFIG_PROVIDER_CLASS_CONFIG = "topic.config.provider.class";
    public static final String DEFAULT_TOPIC_CONFIG_PROVIDER_CLASS = KafkaTopicConfigProvider.class.getName();
    public static final String TOPIC_CONFIG_PROVIDER_CLASS_DOC = "The provider class that reports the active configuration of topics.";
    public static final String BROKER_CAPACITY_CONFIG_RESOLVER_CLASS_CONFIG = "broker.capacity.config.resolver.class";
    public static final String DEFAULT_BROKER_CAPACITY_CONFIG_RESOLVER_CLASS = BrokerCapacityConfigFileResolver.class.getName();
    public static final String BROKER_CAPACITY_CONFIG_RESOLVER_CLASS_DOC = "The broker capacity configuration resolver class name. The broker capacity configuration resolver is responsible for getting the broker capacity. The default implementation is a file based solution.";
    public static final String MONITOR_STATE_UPDATE_INTERVAL_MS_CONFIG = "monitor.state.update.interval.ms";
    public static final long DEFAULT_MONITOR_STATE_UPDATE_INTERVAL_MS = 30000L;
    public static final String MONITOR_STATE_UPDATE_INTERVAL_MS_DOC = "The load monitor interval to refresh the monitor state.";

    private MonitorConfig() {
    }

    public static ConfigDef define(ConfigDef configDef) {
        return configDef.define(BOOTSTRAP_SERVERS_CONFIG, ConfigDef.Type.LIST, ConfigDef.Importance.HIGH, BOOTSTRAP_SERVERS_DOC).define(SECURITY_PROTOCOL_CONFIG, ConfigDef.Type.STRING, (Object)DEFAULT_SECURITY_PROTOCOL, ConfigDef.Importance.MEDIUM, SECURITY_PROTOCOL_DOC).define(METADATA_MAX_AGE_CONFIG, ConfigDef.Type.LONG, (Object)55000L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.LOW, METADATA_MAX_AGE_DOC).define(CLIENT_ID_CONFIG, ConfigDef.Type.STRING, (Object)DEFAULT_CLIENT_ID, ConfigDef.Importance.MEDIUM, CLIENT_ID_DOC).define(SEND_BUFFER_CONFIG, ConfigDef.Type.INT, (Object)131072, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, SEND_BUFFER_DOC).define(RECEIVE_BUFFER_CONFIG, ConfigDef.Type.INT, (Object)32768, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, RECEIVE_BUFFER_DOC).define(CONNECTIONS_MAX_IDLE_MS_CONFIG, ConfigDef.Type.LONG, (Object)540000L, ConfigDef.Importance.MEDIUM, CONNECTIONS_MAX_IDLE_MS_DOC).define(RECONNECT_BACKOFF_MS_CONFIG, ConfigDef.Type.LONG, (Object)50L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0L), ConfigDef.Importance.LOW, RECONNECT_BACKOFF_MS_DOC).define(REQUEST_TIMEOUT_MS_CONFIG, ConfigDef.Type.INT, (Object)30000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, REQUEST_TIMEOUT_MS_DOC).define(PARTITION_METRICS_WINDOW_MS_CONFIG, ConfigDef.Type.LONG, (Object)3600000L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, PARTITION_METRICS_WINDOW_MS_DOC).define(NUM_PARTITION_METRICS_WINDOWS_CONFIG, ConfigDef.Type.INT, (Object)5, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, NUM_PARTITION_METRICS_WINDOWS_DOC).define(NETWORK_CLIENT_PROVIDER_CLASS_CONFIG, ConfigDef.Type.CLASS, (Object)DEFAULT_NETWORK_CLIENT_PROVIDER_CLASS, ConfigDef.Importance.LOW, NETWORK_CLIENT_PROVIDER_CLASS_DOC).define(SKIP_LOADING_SAMPLES_CONFIG, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.MEDIUM, SKIP_LOADING_SAMPLES_DOC).define(MIN_SAMPLES_PER_PARTITION_METRICS_WINDOW_CONFIG, ConfigDef.Type.INT, (Object)3, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, MIN_SAMPLES_PER_PARTITION_METRICS_WINDOW_DOC).define(MAX_ALLOWED_EXTRAPOLATIONS_PER_PARTITION_CONFIG, ConfigDef.Type.INT, (Object)5, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, MAX_ALLOWED_EXTRAPOLATIONS_PER_PARTITION_DOC).define(PARTITION_METRIC_SAMPLE_AGGREGATOR_COMPLETENESS_CACHE_SIZE_CONFIG, ConfigDef.Type.INT, (Object)5, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.LOW, "The metric sample aggregator caches the completeness metadata for fast query. The completeness describes the confidence level of the data in the metric sample aggregator. It is primarily measured by the validity of the metricssamples in different windows. This configuration configures The number of completeness cache slots to maintain.").define(BROKER_METRICS_WINDOW_MS_CONFIG, ConfigDef.Type.LONG, (Object)3600000L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, BROKER_METRICS_WINDOW_MS_DOC).define(NUM_BROKER_METRICS_WINDOWS_CONFIG, ConfigDef.Type.INT, (Object)5, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, NUM_BROKER_METRICS_WINDOWS_DOC).define(MIN_SAMPLES_PER_BROKER_METRICS_WINDOW_CONFIG, ConfigDef.Type.INT, (Object)3, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, MIN_SAMPLES_PER_BROKER_METRICS_WINDOW_DOC).define(MAX_ALLOWED_EXTRAPOLATIONS_PER_BROKER_CONFIG, ConfigDef.Type.INT, (Object)5, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, MAX_ALLOWED_EXTRAPOLATIONS_PER_BROKER_DOC).define(BROKER_METRIC_SAMPLE_AGGREGATOR_COMPLETENESS_CACHE_SIZE_CONFIG, ConfigDef.Type.INT, (Object)5, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.LOW, "The metric sample aggregator caches the completeness metadata for fast query. The completeness describes the confidence level of the data in the metric sample aggregator. It is primarily measured by the validity of the metricssamples in different windows. This configuration configures The number of completeness cache slots to maintain.").define(NUM_METRIC_FETCHERS_CONFIG, ConfigDef.Type.INT, (Object)1, ConfigDef.Importance.HIGH, NUM_METRIC_FETCHERS_DOC).define(METRIC_SAMPLER_CLASS_CONFIG, ConfigDef.Type.CLASS, (Object)DEFAULT_METRIC_SAMPLER_CLASS, ConfigDef.Importance.HIGH, METRIC_SAMPLER_CLASS_DOC).define(METRIC_SAMPLER_PARTITION_ASSIGNOR_CLASS_CONFIG, ConfigDef.Type.CLASS, (Object)DEFAULT_METRIC_SAMPLER_PARTITION_ASSIGNOR_CLASS, ConfigDef.Importance.LOW, METRIC_SAMPLER_PARTITION_ASSIGNOR_CLASS_DOC).define(METRIC_SAMPLING_INTERVAL_MS_CONFIG, ConfigDef.Type.LONG, (Object)60000L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.HIGH, METRIC_SAMPLING_INTERVAL_MS_DOC).define(MIN_VALID_PARTITION_RATIO_CONFIG, ConfigDef.Type.DOUBLE, (Object)0.995, (ConfigDef.Validator)ConfigDef.Range.between((Number)0, (Number)1), ConfigDef.Importance.HIGH, MIN_VALID_PARTITION_RATIO_DOC).define(LEADER_NETWORK_INBOUND_WEIGHT_FOR_CPU_UTIL_CONFIG, ConfigDef.Type.DOUBLE, (Object)0.7, (ConfigDef.Validator)ConfigDef.Range.between((Number)0, (Number)1), ConfigDef.Importance.MEDIUM, LEADER_NETWORK_INBOUND_WEIGHT_FOR_CPU_UTIL_DOC).define(LEADER_NETWORK_OUTBOUND_WEIGHT_FOR_CPU_UTIL_CONFIG, ConfigDef.Type.DOUBLE, (Object)0.15, (ConfigDef.Validator)ConfigDef.Range.between((Number)0, (Number)1), ConfigDef.Importance.MEDIUM, LEADER_NETWORK_OUTBOUND_WEIGHT_FOR_CPU_UTIL_DOC).define(FOLLOWER_NETWORK_INBOUND_WEIGHT_FOR_CPU_UTIL_CONFIG, ConfigDef.Type.DOUBLE, (Object)0.15, (ConfigDef.Validator)ConfigDef.Range.between((Number)0, (Number)1), ConfigDef.Importance.MEDIUM, FOLLOWER_NETWORK_INBOUND_WEIGHT_FOR_CPU_UTIL_DOC).define(LINEAR_REGRESSION_MODEL_CPU_UTIL_BUCKET_SIZE_CONFIG, ConfigDef.Type.INT, (Object)5, (ConfigDef.Validator)ConfigDef.Range.between((Number)0, (Number)100), ConfigDef.Importance.MEDIUM, LINEAR_REGRESSION_MODEL_CPU_UTIL_BUCKET_SIZE_DOC).define(LINEAR_REGRESSION_MODEL_REQUIRED_SAMPLES_PER_CPU_UTIL_BUCKET_CONFIG, ConfigDef.Type.INT, (Object)100, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, LINEAR_REGRESSION_MODEL_REQUIRED_SAMPLES_PER_CPU_UTIL_BUCKET_DOC).define(LINEAR_REGRESSION_MODEL_MIN_NUM_CPU_UTIL_BUCKETS_CONFIG, ConfigDef.Type.INT, (Object)5, ConfigDef.Importance.MEDIUM, LINEAR_REGRESSION_MODEL_MIN_NUM_CPU_UTIL_BUCKETS_DOC).define(SAMPLING_ALLOW_CPU_CAPACITY_ESTIMATION_CONFIG, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, SAMPLING_ALLOW_CPU_CAPACITY_ESTIMATION_DOC).define(USE_LINEAR_REGRESSION_MODEL_CONFIG, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.MEDIUM, USE_LINEAR_REGRESSION_MODEL_DOC).define(SAMPLE_STORE_CLASS_CONFIG, ConfigDef.Type.CLASS, (Object)DEFAULT_SAMPLE_STORE_CLASS, ConfigDef.Importance.LOW, SAMPLE_STORE_CLASS_DOC).define(TOPIC_CONFIG_PROVIDER_CLASS_CONFIG, ConfigDef.Type.CLASS, (Object)DEFAULT_TOPIC_CONFIG_PROVIDER_CLASS, ConfigDef.Importance.LOW, TOPIC_CONFIG_PROVIDER_CLASS_DOC).define(BROKER_CAPACITY_CONFIG_RESOLVER_CLASS_CONFIG, ConfigDef.Type.CLASS, (Object)DEFAULT_BROKER_CAPACITY_CONFIG_RESOLVER_CLASS, ConfigDef.Importance.MEDIUM, BROKER_CAPACITY_CONFIG_RESOLVER_CLASS_DOC).define(MONITOR_STATE_UPDATE_INTERVAL_MS_CONFIG, ConfigDef.Type.LONG, (Object)30000L, ConfigDef.Importance.LOW, MONITOR_STATE_UPDATE_INTERVAL_MS_DOC);
    }
}

