/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.config;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlUtils;
import com.linkedin.kafka.cruisecontrol.config.TopicConfigProvider;
import com.linkedin.kafka.cruisecontrol.config.constants.ExecutorConfig;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import kafka.server.ConfigType;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import scala.collection.JavaConversions;
import scala.collection.Map;

public class KafkaTopicConfigProvider
implements TopicConfigProvider {
    public static final String CLUSTER_CONFIGS_FILE = "cluster.configs.file";
    public static final String ZK_KAFKA_TOPIC_CONFIG_PROVIDER_METRIC_GROUP = "KafkaTopicConfigProvider";
    public static final String ZK_KAFKA_TOPIC_CONFIG_PROVIDER_METRIC_TYPE = "GetAllActiveTopicConfigs";
    private String _connectString;
    private boolean _zkSecurityEnabled;
    private static Properties _clusterConfigs;

    @Override
    public Properties clusterConfigs() {
        return _clusterConfigs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties topicConfigs(String topic) {
        KafkaZkClient kafkaZkClient = KafkaCruiseControlUtils.createKafkaZkClient(this._connectString, ZK_KAFKA_TOPIC_CONFIG_PROVIDER_METRIC_GROUP, ZK_KAFKA_TOPIC_CONFIG_PROVIDER_METRIC_TYPE, this._zkSecurityEnabled);
        try {
            AdminZkClient adminZkClient = new AdminZkClient(kafkaZkClient);
            Properties properties = adminZkClient.fetchEntityConfig(ConfigType.Topic(), topic);
            return properties;
        }
        finally {
            KafkaCruiseControlUtils.closeKafkaZkClientWithTimeout(kafkaZkClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public java.util.Map<String, Properties> allTopicConfigs() {
        KafkaZkClient kafkaZkClient = KafkaCruiseControlUtils.createKafkaZkClient(this._connectString, ZK_KAFKA_TOPIC_CONFIG_PROVIDER_METRIC_GROUP, ZK_KAFKA_TOPIC_CONFIG_PROVIDER_METRIC_TYPE, this._zkSecurityEnabled);
        try {
            AdminZkClient adminZkClient = new AdminZkClient(kafkaZkClient);
            java.util.Map map = JavaConversions.mapAsJavaMap((Map)adminZkClient.getAllTopicConfigs());
            return map;
        }
        finally {
            KafkaCruiseControlUtils.closeKafkaZkClientWithTimeout(kafkaZkClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadClusterConfigs(String clusterConfigsFile) throws FileNotFoundException {
        JsonReader reader = new JsonReader((Reader)new InputStreamReader((InputStream)new FileInputStream(clusterConfigsFile), StandardCharsets.UTF_8));
        try {
            Gson gson = new Gson();
            _clusterConfigs = (Properties)gson.fromJson(reader, Properties.class);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void configure(java.util.Map<String, ?> configs) {
        this._connectString = (String)configs.get(ExecutorConfig.ZOOKEEPER_CONNECT_CONFIG);
        this._zkSecurityEnabled = (Boolean)configs.get("zookeeper.security.enabled");
        String configFile = KafkaCruiseControlUtils.getRequiredConfig(configs, CLUSTER_CONFIGS_FILE);
        try {
            this.loadClusterConfigs(configFile);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void close() {
    }
}

