/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.config;

import com.linkedin.cruisecontrol.common.CruiseControlConfigurable;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfigUtils;
import com.linkedin.kafka.cruisecontrol.config.constants.AnalyzerConfig;
import com.linkedin.kafka.cruisecontrol.config.constants.AnomalyDetectorConfig;
import com.linkedin.kafka.cruisecontrol.config.constants.CruiseControlParametersConfig;
import com.linkedin.kafka.cruisecontrol.config.constants.CruiseControlRequestConfig;
import com.linkedin.kafka.cruisecontrol.config.constants.ExecutorConfig;
import com.linkedin.kafka.cruisecontrol.config.constants.MonitorConfig;
import com.linkedin.kafka.cruisecontrol.config.constants.UserTaskManagerConfig;
import com.linkedin.kafka.cruisecontrol.config.constants.WebServerConfig;
import com.linkedin.kafka.cruisecontrol.metricsreporter.CruiseControlMetricsReporterConfig;
import com.linkedin.kafka.cruisecontrol.servlet.security.BasicSecurityProvider;
import com.linkedin.kafka.cruisecontrol.servlet.security.SecurityProvider;
import com.linkedin.kafka.cruisecontrol.servlet.security.jwt.JwtSecurityProvider;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;

public class KafkaCruiseControlConfig
extends AbstractConfig {
    private static final ConfigDef CONFIG = CruiseControlRequestConfig.define(CruiseControlParametersConfig.define(AnomalyDetectorConfig.define(AnalyzerConfig.define(ExecutorConfig.define(MonitorConfig.define(WebServerConfig.define(UserTaskManagerConfig.define(new ConfigDef())))))))).withClientSslSupport().withClientSaslSupport();

    public Map<String, Object> mergedConfigValues() {
        Map conf = this.originals();
        this.values().forEach((k, v) -> {
            if (v != null) {
                conf.put(k, v);
            }
        });
        return conf;
    }

    public <T> T getConfiguredInstance(String key, Class<T> t) {
        Object o = super.getConfiguredInstance(key, t);
        if (o instanceof CruiseControlConfigurable) {
            ((CruiseControlConfigurable)o).configure(this.mergedConfigValues());
        }
        return (T)o;
    }

    public <T> List<T> getConfiguredInstances(String key, Class<T> t) {
        List objects = super.getConfiguredInstances(key, t);
        for (Object o : objects) {
            if (!(o instanceof CruiseControlConfigurable)) continue;
            ((CruiseControlConfigurable)o).configure(this.mergedConfigValues());
        }
        return objects;
    }

    public <T> List<T> getConfiguredInstances(String key, Class<T> t, Map<String, Object> configOverrides) {
        List objects = super.getConfiguredInstances(key, t, configOverrides);
        Map<String, Object> configPairs = this.mergedConfigValues();
        configPairs.putAll(configOverrides);
        for (Object o : objects) {
            if (!(o instanceof CruiseControlConfigurable)) continue;
            ((CruiseControlConfigurable)o).configure(configPairs);
        }
        return objects;
    }

    public <T> T getConfiguredInstance(String key, Class<T> t, Map<String, Object> configOverrides) {
        Class c = this.getClass(key);
        Map<String, Object> configPairs = this.mergedConfigValues();
        configPairs.putAll(configOverrides);
        return KafkaCruiseControlConfigUtils.getConfiguredInstance(c, t, configPairs);
    }

    private void sanityCheckGoalNames() {
        List interBrokerGoalNames = this.getList("goals");
        if (interBrokerGoalNames.isEmpty()) {
            throw new ConfigException("Attempt to configure goals configuration with an empty list of goals.");
        }
        List intraBrokerGoalNames = this.getList("intra.broker.goals");
        if (intraBrokerGoalNames.isEmpty()) {
            throw new ConfigException("Attempt to configure intra-broker goals configuration with an empty list of goals.");
        }
        HashSet commonGoals = new HashSet(interBrokerGoalNames);
        commonGoals.retainAll(intraBrokerGoalNames);
        if (!commonGoals.isEmpty()) {
            throw new ConfigException(String.format("Attempt to configure inter-broker (%s) and intra-broker (%s) goals with common goals (%s).", interBrokerGoalNames, intraBrokerGoalNames, commonGoals));
        }
        TreeSet<String> caseInsensitiveGoalNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (String goalName : interBrokerGoalNames) {
            if (caseInsensitiveGoalNames.add(goalName.replaceAll(".*\\.", ""))) continue;
            throw new ConfigException("Attempt to configure goals with case sensitive names.");
        }
        for (String goalName : intraBrokerGoalNames) {
            if (caseInsensitiveGoalNames.add(goalName.replaceAll(".*\\.", ""))) continue;
            throw new ConfigException("Attempt to configure intra-broker goals with case sensitive names.");
        }
        List defaultGoalNames = this.getList("default.goals");
        if (defaultGoalNames.isEmpty()) {
            throw new ConfigException("Attempt to configure default goals configuration with an empty list of goals.");
        }
        if (defaultGoalNames.stream().anyMatch(g -> !interBrokerGoalNames.contains(g))) {
            throw new ConfigException(String.format("Attempt to configure default goals with unsupported goals (%s:%s and %s:%s).", "default.goals", defaultGoalNames, "goals", interBrokerGoalNames));
        }
        List hardGoalNames = this.getList("hard.goals");
        if (hardGoalNames.stream().anyMatch(g -> !defaultGoalNames.contains(g))) {
            throw new ConfigException(String.format("Attempt to configure hard goals with unsupported goals (%s:%s and %s:%s).", "hard.goals", hardGoalNames, "default.goals", defaultGoalNames));
        }
        List selfHealingGoalNames = this.getList("self.healing.goals");
        if (selfHealingGoalNames.stream().anyMatch(g -> !defaultGoalNames.contains(g))) {
            throw new ConfigException(String.format("Attempt to configure self healing goals with unsupported goals (%s:%s and %s:%s).", "self.healing.goals", selfHealingGoalNames, "default.goals", defaultGoalNames));
        }
        List anomalyDetectionGoalNames = this.getList("anomaly.detection.goals");
        if (anomalyDetectionGoalNames.stream().anyMatch(g -> selfHealingGoalNames.isEmpty() ? !defaultGoalNames.contains(g) : !selfHealingGoalNames.contains(g))) {
            throw new ConfigException("Attempt to configure anomaly detection goals as a superset of self healing goals.");
        }
    }

    void sanityCheckConcurrency() {
        long defaultExecutionProgressCheckIntervalMs;
        int maxClusterPartitionMovementConcurrency = this.getInt("max.num.cluster.movements");
        int interBrokerPartitionMovementConcurrency = this.getInt("num.concurrent.partition.movements.per.broker");
        if (interBrokerPartitionMovementConcurrency >= maxClusterPartitionMovementConcurrency) {
            throw new ConfigException(String.format("Inter-broker partition movement concurrency [%d] must be smaller than the maximum number of allowed movements in cluster [%d].", interBrokerPartitionMovementConcurrency, maxClusterPartitionMovementConcurrency));
        }
        int intraBrokerPartitionMovementConcurrency = this.getInt("num.concurrent.intra.broker.partition.movements");
        if (intraBrokerPartitionMovementConcurrency >= maxClusterPartitionMovementConcurrency) {
            throw new ConfigException(String.format("Intra-broker partition movement concurrency [%d] must be smaller than the maximum number of allowed movements in cluster [%d].", intraBrokerPartitionMovementConcurrency, maxClusterPartitionMovementConcurrency));
        }
        int leadershipMovementConcurrency = this.getInt("num.concurrent.leader.movements");
        if (leadershipMovementConcurrency > maxClusterPartitionMovementConcurrency) {
            throw new ConfigException(String.format("Leadership movement concurrency [%d] cannot be greater than the maximum number of allowed movements in cluster [%d].", leadershipMovementConcurrency, maxClusterPartitionMovementConcurrency));
        }
        int concurrencyAdjusterMaxPartitionMovementsPerBroker = this.getInt("concurrency.adjuster.max.partition.movements.per.broker");
        if (interBrokerPartitionMovementConcurrency >= concurrencyAdjusterMaxPartitionMovementsPerBroker) {
            throw new ConfigException(String.format("Inter-broker partition movement concurrency [%d] must be smaller than the concurrency adjuster maximum partition movements per broker [%d].", interBrokerPartitionMovementConcurrency, concurrencyAdjusterMaxPartitionMovementsPerBroker));
        }
        if (concurrencyAdjusterMaxPartitionMovementsPerBroker > maxClusterPartitionMovementConcurrency) {
            throw new ConfigException(String.format("Maximum partition movements per broker of concurrency adjuster [%d] cannot be greater than the maximum number of allowed movements in cluster [%d].", concurrencyAdjusterMaxPartitionMovementsPerBroker, maxClusterPartitionMovementConcurrency));
        }
        int concurrencyAdjusterMinPartitionMovementsPerBroker = this.getInt("concurrency.adjuster.min.partition.movements.per.broker");
        if (interBrokerPartitionMovementConcurrency < concurrencyAdjusterMinPartitionMovementsPerBroker) {
            throw new ConfigException(String.format("Inter-broker partition movement concurrency [%d] cannot be smaller than the concurrency adjuster minimum partition movements per broker [%d].", interBrokerPartitionMovementConcurrency, concurrencyAdjusterMinPartitionMovementsPerBroker));
        }
        int concurrencyAdjusterMinLeadershipMovements = this.getInt("concurrency.adjuster.min.leadership.movements");
        if (leadershipMovementConcurrency < concurrencyAdjusterMinLeadershipMovements) {
            throw new ConfigException(String.format("Leadership movement concurrency [%d] cannot be smaller than the concurrency adjuster minimum leadership movements [%d].", leadershipMovementConcurrency, concurrencyAdjusterMinLeadershipMovements));
        }
        int concurrencyAdjusterMaxLeadershipMovements = this.getInt("concurrency.adjuster.max.leadership.movements");
        if (leadershipMovementConcurrency > concurrencyAdjusterMaxLeadershipMovements) {
            throw new ConfigException(String.format("Leadership movement concurrency [%d] cannot be greater than the concurrency adjuster maximum leadership movements [%d].", leadershipMovementConcurrency, concurrencyAdjusterMaxLeadershipMovements));
        }
        if (concurrencyAdjusterMaxLeadershipMovements > maxClusterPartitionMovementConcurrency) {
            throw new ConfigException(String.format("Maximum leadership movements of concurrency adjuster [%d] cannot be greater than the maximum number of allowed movements in cluster [%d].", concurrencyAdjusterMaxLeadershipMovements, maxClusterPartitionMovementConcurrency));
        }
        long minExecutionProgressCheckIntervalMs = this.getLong("min.execution.progress.check.interval.ms");
        if (minExecutionProgressCheckIntervalMs > (defaultExecutionProgressCheckIntervalMs = this.getLong("execution.progress.check.interval.ms").longValue())) {
            throw new ConfigException(String.format("Minimum execution progress check interval [%d] cannot be greater than the default execution progress check interval [%d].", minExecutionProgressCheckIntervalMs, defaultExecutionProgressCheckIntervalMs));
        }
    }

    private void sanityCheckTaskExecutionAlertingThreshold() {
        long leaderMovementTimeoutMs = this.getLong("leader.movement.timeout.ms");
        long taskExecutionAlertingThresholdMs = this.getLong("task.execution.alerting.threshold.ms");
        if (taskExecutionAlertingThresholdMs >= leaderMovementTimeoutMs) {
            throw new ConfigException(String.format("Task execution time alerting threshold [%dms] cannot be greater than leader movement timeout [%sms].", taskExecutionAlertingThresholdMs, leaderMovementTimeoutMs));
        }
    }

    private void sanityCheckSamplingPeriod(Map<?, ?> originals) {
        long samplingIntervalMs = this.getLong("metric.sampling.interval.ms");
        long metadataTimeoutMs = this.getLong("metadata.max.age.ms");
        if (metadataTimeoutMs > samplingIntervalMs) {
            throw new ConfigException("Attempt to set metadata refresh timeout [" + metadataTimeoutMs + "] to be longer than sampling period [" + samplingIntervalMs + "].");
        }
        long partitionSampleWindowMs = this.getLong("partition.metrics.window.ms");
        short partitionSamplingFrequency = (short)(partitionSampleWindowMs / samplingIntervalMs);
        if (partitionSamplingFrequency > 127) {
            throw new ConfigException(String.format("Configured sampling frequency (%d) exceeds the maximum allowed value (%d). Decrease the value of %s or increase the value of %s to ensure that their ratio is under this limit.", partitionSamplingFrequency, (byte)127, "partition.metrics.window.ms", "metric.sampling.interval.ms"));
        }
        long brokerSampleWindowMs = this.getLong("broker.metrics.window.ms");
        short brokerSamplingFrequency = (short)(brokerSampleWindowMs / samplingIntervalMs);
        if (brokerSamplingFrequency > 127) {
            throw new ConfigException(String.format("Configured sampling frequency (%d) exceeds the maximum allowed value (%d). Decrease the value of %s or increase the value of %s to ensure that their ratio is under this limit.", brokerSamplingFrequency, (byte)127, "broker.metrics.window.ms", "metric.sampling.interval.ms"));
        }
        CruiseControlMetricsReporterConfig reporterConfig = new CruiseControlMetricsReporterConfig(originals, false);
        long reportingIntervalMs = reporterConfig.getLong("cruise.control.metrics.reporter.metrics.reporting.interval.ms");
        if (reportingIntervalMs > samplingIntervalMs) {
            throw new ConfigException(String.format("Configured metric reporting interval (%d) exceeds metric sampling interval (%d). Decrease the value of %s or increase the value of %s to ensure that reported metrics can be properly sampled.", reportingIntervalMs, samplingIntervalMs, "cruise.control.metrics.reporter.metrics.reporting.interval.ms", "metric.sampling.interval.ms"));
        }
        Long metricAnomalyDetectionIntervalMs = this.getLong("metric.anomaly.detection.interval.ms");
        if (metricAnomalyDetectionIntervalMs == null) {
            metricAnomalyDetectionIntervalMs = this.getLong("anomaly.detection.interval.ms");
        }
        if (samplingIntervalMs > metricAnomalyDetectionIntervalMs) {
            throw new ConfigException(String.format("Configured metric sampling interval (%d) exceeds metric anomaly detection interval (%d). Decrease the value of %s or increase the value of %s (or %s if %s is not specified) to ensure that metrics anomaly detection does not run too frequently.", samplingIntervalMs, metricAnomalyDetectionIntervalMs, "metric.sampling.interval.ms", "metric.anomaly.detection.interval.ms", "anomaly.detection.interval.ms", "metric.anomaly.detection.interval.ms"));
        }
        long concurrencyAdjusterIntervalMs = this.getLong("concurrency.adjuster.interval.ms");
        if (samplingIntervalMs > concurrencyAdjusterIntervalMs) {
            throw new ConfigException(String.format("Configured metric sampling interval (%d) exceeds concurrency adjuster interval (%d). Decrease the value of %s or increase the value of %s to ensure that concurrency adjuster can be properly retrieve and evaluate the latest broker metrics.", samplingIntervalMs, concurrencyAdjusterIntervalMs, "metric.sampling.interval.ms", "concurrency.adjuster.interval.ms"));
        }
    }

    void sanityCheckSecurity() {
        Boolean securityEnabled;
        Boolean sslEnabled = this.getBoolean("webserver.ssl.enable");
        if (sslEnabled.booleanValue()) {
            if (this.getString("webserver.ssl.keystore.location") == null) {
                throw new ConfigException("If webserver SSL is enabled, the keystore location must be set.");
            }
            if (this.getString("webserver.ssl.protocol") == null) {
                throw new ConfigException("If webserver SSL is enabled, a valid SSL protocol must be set.");
            }
        }
        if ((securityEnabled = this.getBoolean("webserver.security.enable")).booleanValue()) {
            Class securityProvider = this.getClass("webserver.security.provider");
            if (securityProvider == null || !SecurityProvider.class.isAssignableFrom(securityProvider)) {
                throw new ConfigException(String.format("If webserver security is enabled, a valid security provider must be set that is an implementation of %s.", SecurityProvider.class.getName()));
            }
            String authCredentialsFile = this.getString("webserver.auth.credentials.file");
            if (BasicSecurityProvider.class == securityProvider && !this.fileExists(authCredentialsFile)) {
                throw new ConfigException(String.format("If %s is used, an existing credentials file must be set.", BasicSecurityProvider.class.getName()));
            }
            if (JwtSecurityProvider.class == securityProvider) {
                String providerUrl = this.getString("jwt.authentication.provider.url");
                if (providerUrl == null || providerUrl.isEmpty()) {
                    throw new ConfigException(String.format("When %s is used, %s must be set.", JwtSecurityProvider.class.getName(), "jwt.authentication.provider.url"));
                }
                String certificateFile = this.getString("jwt.auth.certificate.location");
                if (!this.fileExists(certificateFile)) {
                    throw new ConfigException(String.format("If %s is used, an existing certificate file must be set.", JwtSecurityProvider.class.getName()));
                }
                String privilegesFile = this.getString("webserver.auth.credentials.file");
                if (!this.fileExists(privilegesFile)) {
                    throw new ConfigException(String.format("If %s is used, an existing certificate file must be set.", JwtSecurityProvider.class.getName()));
                }
            }
        }
    }

    private boolean fileExists(String file) {
        return file != null && Files.exists(Paths.get(file, new String[0]), new LinkOption[0]);
    }

    public KafkaCruiseControlConfig(Map<?, ?> originals) {
        this(originals, true);
    }

    public KafkaCruiseControlConfig(Map<?, ?> originals, boolean doLog) {
        super(CONFIG, originals, doLog);
        this.sanityCheckGoalNames();
        this.sanityCheckSamplingPeriod(originals);
        this.sanityCheckConcurrency();
        this.sanityCheckTaskExecutionAlertingThreshold();
        this.sanityCheckSecurity();
    }
}

