/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.config;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.ConfigData;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.provider.ConfigProvider;

public class EnvConfigProvider
implements ConfigProvider {
    private Map<String, String> _preConfiguredEnvironmentVariables;

    public ConfigData get(String path) {
        EnvConfigProvider.assertNoPath(path);
        return new ConfigData(this.getenv());
    }

    public ConfigData get(String path, Set<String> keys) {
        EnvConfigProvider.assertNoPath(path);
        HashMap<String, String> filtered = new HashMap<String, String>(this.getenv());
        filtered.keySet().retainAll(keys);
        return new ConfigData(filtered);
    }

    public void close() {
        this._preConfiguredEnvironmentVariables.clear();
    }

    public void configure(Map<String, ?> configs) {
        this._preConfiguredEnvironmentVariables = configs.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, kv -> (String)kv.getValue()));
    }

    private static void assertNoPath(String path) {
        if (path != null && !path.isEmpty()) {
            throw new ConfigException("EnvConfigProvider does not support paths. Found: " + path);
        }
    }

    private Map<String, String> getenv() {
        if (this._preConfiguredEnvironmentVariables == null) {
            return System.getenv();
        }
        return this._preConfiguredEnvironmentVariables;
    }
}

