/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.config;

import com.linkedin.kafka.cruisecontrol.common.Resource;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class BrokerCapacityInfo {
    public static final short DEFAULT_NUM_CPU_CORES = 1;
    private static final String DEFAULT_ESTIMATION_INFO = "";
    private static final Map<String, Double> DEFAULT_DISK_CAPACITY_BY_LOGDIR = null;
    private final Map<Resource, Double> _capacity;
    private final String _estimationInfo;
    private final Map<String, Double> _diskCapacityByLogDir;
    private final short _numCpuCores;

    public BrokerCapacityInfo(Map<Resource, Double> capacity, String estimationInfo, Map<String, Double> diskCapacityByLogDir, short numCpuCores) {
        BrokerCapacityInfo.sanityCheckCapacity(capacity);
        this._capacity = capacity;
        this._estimationInfo = estimationInfo == null ? DEFAULT_ESTIMATION_INFO : estimationInfo;
        this._diskCapacityByLogDir = diskCapacityByLogDir;
        this._numCpuCores = numCpuCores;
    }

    public BrokerCapacityInfo(Map<Resource, Double> capacity, Map<String, Double> diskCapacityByLogDir, short numCpuCores) {
        this(capacity, DEFAULT_ESTIMATION_INFO, diskCapacityByLogDir, numCpuCores);
    }

    public BrokerCapacityInfo(Map<Resource, Double> capacity, short numCpuCores) {
        this(capacity, DEFAULT_ESTIMATION_INFO, DEFAULT_DISK_CAPACITY_BY_LOGDIR, numCpuCores);
    }

    public BrokerCapacityInfo(Map<Resource, Double> capacity, String estimationInfo, Map<String, Double> diskCapacityByLogDir) {
        this(capacity, estimationInfo, diskCapacityByLogDir, 1);
    }

    public BrokerCapacityInfo(Map<Resource, Double> capacity, String estimationInfo) {
        this(capacity, estimationInfo, DEFAULT_DISK_CAPACITY_BY_LOGDIR, 1);
    }

    public BrokerCapacityInfo(Map<Resource, Double> capacity, Map<String, Double> diskCapacityByLogDir) {
        this(capacity, DEFAULT_ESTIMATION_INFO, diskCapacityByLogDir, 1);
    }

    public BrokerCapacityInfo(Map<Resource, Double> capacity) {
        this(capacity, DEFAULT_ESTIMATION_INFO, DEFAULT_DISK_CAPACITY_BY_LOGDIR, 1);
    }

    public Map<Resource, Double> capacity() {
        return this._capacity;
    }

    public boolean isEstimated() {
        return !this._estimationInfo.isEmpty();
    }

    public String estimationInfo() {
        return this._estimationInfo;
    }

    public Map<String, Double> diskCapacityByLogDir() {
        return this._diskCapacityByLogDir;
    }

    public short numCpuCores() {
        return this._numCpuCores;
    }

    static void sanityCheckCapacity(Map<Resource, Double> capacity) {
        Set<Resource> providedResource = capacity.keySet();
        Set missingResource = Resource.cachedValues().stream().filter(r -> !providedResource.contains(r)).collect(Collectors.toSet());
        if (!missingResource.isEmpty()) {
            throw new IllegalArgumentException(String.format("Provided capacity information missing value for resource %s.", missingResource));
        }
    }
}

