/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.config;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlUtils;
import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.config.BrokerCapacityConfigResolver;
import com.linkedin.kafka.cruisecontrol.config.BrokerCapacityInfo;
import com.linkedin.kafka.cruisecontrol.exception.BrokerCapacityResolutionException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class BrokerCapacityConfigFileResolver
implements BrokerCapacityConfigResolver {
    public static final String CAPACITY_CONFIG_FILE = "capacity.config.file";
    public static final int DEFAULT_CAPACITY_BROKER_ID = -1;
    private static final String NUM_CORES_CONFIG = "num.cores";
    public static final double DEFAULT_CPU_CAPACITY_WITH_CORES = 100.0;
    private static Map<Integer, BrokerCapacityInfo> _capacitiesForBrokers;
    private String _configFile;

    public void configure(Map<String, ?> configs) {
        this._configFile = KafkaCruiseControlUtils.getRequiredConfig(configs, CAPACITY_CONFIG_FILE);
        try {
            this.loadCapacities();
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public BrokerCapacityInfo capacityForBroker(String rack, String host, int brokerId, long timeoutMs, boolean allowCapacityEstimation) throws BrokerCapacityResolutionException {
        if (brokerId >= 0) {
            BrokerCapacityInfo capacity = _capacitiesForBrokers.get(brokerId);
            if (capacity != null) {
                return capacity;
            }
            if (allowCapacityEstimation) {
                String info = String.format("Missing broker id(%d) in capacity config file.", brokerId);
                return new BrokerCapacityInfo(_capacitiesForBrokers.get(-1).capacity(), info, _capacitiesForBrokers.get(-1).diskCapacityByLogDir(), _capacitiesForBrokers.get(-1).numCpuCores());
            }
            throw new BrokerCapacityResolutionException(String.format("Unable to resolve capacity of broker %d. Either (1) adding the default broker capacity (via adding capacity for broker %d and allowing capacity estimation) or (2) adding missing broker's capacity in file %s.", brokerId, -1, this._configFile));
        }
        throw new IllegalArgumentException("The broker id(" + brokerId + ") should be non-negative.");
    }

    private static boolean isJBOD(Map<Resource, Object> brokerCapacity) {
        return brokerCapacity.get((Object)Resource.DISK) instanceof Map;
    }

    private static Short getUserSpecifiedNumCores(Map<Resource, Object> brokerCapacity) {
        if (brokerCapacity.get((Object)Resource.CPU) instanceof Map) {
            String stringNumCores = (String)((Map)brokerCapacity.get((Object)Resource.CPU)).get(NUM_CORES_CONFIG);
            if (stringNumCores == null) {
                throw new IllegalArgumentException("Missing num.cores config for brokers in capacity config file.");
            }
            return Short.parseShort(stringNumCores);
        }
        return null;
    }

    private static Map<Resource, Double> getTotalCapacity(Map<Resource, Object> brokerCapacity, boolean hasNumCores) {
        HashMap<Resource, Double> totalCapacity = new HashMap<Resource, Double>(brokerCapacity.size());
        if (BrokerCapacityConfigFileResolver.isJBOD(brokerCapacity)) {
            for (Map.Entry<Resource, Object> entry : brokerCapacity.entrySet()) {
                Resource resource = entry.getKey();
                if (resource == Resource.DISK) {
                    double totalDiskCapacity = 0.0;
                    for (Map.Entry diskEntry : ((Map)brokerCapacity.get((Object)resource)).entrySet()) {
                        if (!Paths.get((String)diskEntry.getKey(), new String[0]).isAbsolute()) {
                            throw new IllegalArgumentException("The logDir " + (String)diskEntry.getKey() + " must be an absolute path.");
                        }
                        totalDiskCapacity += Double.parseDouble((String)diskEntry.getValue());
                    }
                    totalCapacity.put(resource, totalDiskCapacity);
                    continue;
                }
                if (hasNumCores && resource == Resource.CPU) {
                    totalCapacity.put(resource, 100.0);
                    continue;
                }
                totalCapacity.put(resource, Double.parseDouble((String)entry.getValue()));
            }
        } else {
            brokerCapacity.forEach((key, value) -> totalCapacity.put((Resource)((Object)key), hasNumCores && key == Resource.CPU ? 100.0 : Double.parseDouble((String)value)));
        }
        return totalCapacity;
    }

    private static Map<String, Double> getDiskCapacityByLogDir(Map<Resource, Object> brokerCapacity) {
        if (!BrokerCapacityConfigFileResolver.isJBOD(brokerCapacity)) {
            return null;
        }
        Map stringDiskCapacityByLogDir = (Map)brokerCapacity.get((Object)Resource.DISK);
        HashMap<String, Double> diskCapacityByLogDir = new HashMap<String, Double>(stringDiskCapacityByLogDir.size());
        stringDiskCapacityByLogDir.forEach((key, value) -> diskCapacityByLogDir.put((String)key, Double.parseDouble(value)));
        return diskCapacityByLogDir;
    }

    private static void numCoresConfigConsistencyChecker(Set<Boolean> numCoresConfigConsistency) {
        if (numCoresConfigConsistency.size() > 1) {
            throw new IllegalArgumentException("Inconsistent num.cores config for brokers in capacity config file. This config must be provided by either all or non of the brokers.");
        }
    }

    private BrokerCapacityInfo getBrokerCapacityInfo(BrokerCapacity bc, Set<Boolean> numCoresConfigConsistency) {
        Short userSpecifiedNumCores = BrokerCapacityConfigFileResolver.getUserSpecifiedNumCores(bc.capacity);
        boolean hasNumCores = userSpecifiedNumCores != null;
        numCoresConfigConsistency.add(hasNumCores);
        BrokerCapacityConfigFileResolver.numCoresConfigConsistencyChecker(numCoresConfigConsistency);
        boolean isDefault = bc.brokerId == -1;
        Map<Resource, Double> totalCapacity = BrokerCapacityConfigFileResolver.getTotalCapacity(bc.capacity, hasNumCores);
        Map<String, Double> diskCapacityByLogDir = BrokerCapacityConfigFileResolver.getDiskCapacityByLogDir(bc.capacity);
        BrokerCapacityInfo brokerCapacityInfo = hasNumCores ? (isDefault ? new BrokerCapacityInfo(totalCapacity, "The default broker capacity.", diskCapacityByLogDir, userSpecifiedNumCores) : new BrokerCapacityInfo(totalCapacity, diskCapacityByLogDir, userSpecifiedNumCores)) : (isDefault ? new BrokerCapacityInfo(totalCapacity, "The default broker capacity.", diskCapacityByLogDir) : new BrokerCapacityInfo(totalCapacity, diskCapacityByLogDir));
        return brokerCapacityInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCapacities() throws FileNotFoundException {
        JsonReader reader = null;
        try {
            reader = new JsonReader((Reader)new InputStreamReader((InputStream)new FileInputStream(this._configFile), StandardCharsets.UTF_8));
            Gson gson = new Gson();
            Set<BrokerCapacity> brokerCapacities = ((BrokerCapacities)gson.fromJson((JsonReader)reader, BrokerCapacities.class)).brokerCapacities;
            _capacitiesForBrokers = new HashMap<Integer, BrokerCapacityInfo>(brokerCapacities.size());
            HashSet<Boolean> numCoresConfigConsistency = new HashSet<Boolean>(1);
            for (BrokerCapacity bc : brokerCapacities) {
                _capacitiesForBrokers.put(bc.brokerId, this.getBrokerCapacityInfo(bc, numCoresConfigConsistency));
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public void close() throws Exception {
    }

    private static class BrokerCapacity {
        private final int brokerId;
        private final Map<Resource, Object> capacity;

        BrokerCapacity(int brokerId, Map<Resource, Object> capacity) {
            this.brokerId = brokerId;
            this.capacity = capacity;
        }
    }

    private static class BrokerCapacities {
        private Set<BrokerCapacity> brokerCapacities;

        private BrokerCapacities() {
        }
    }
}

