/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum Resource {
    CPU("cpu", 0, true, true, 0.001),
    NW_IN("networkInbound", 1, true, false, 10.0),
    NW_OUT("networkOutbound", 2, true, false, 10.0),
    DISK("disk", 3, false, true, 100.0);

    private static final double EPSILON_PERCENT = 8.0E-4;
    private final String _resource;
    private final int _id;
    private final boolean _isHostResource;
    private final boolean _isBrokerResource;
    private double _epsilon;
    private static final List<Resource> CACHED_VALUES;

    public static List<Resource> cachedValues() {
        return CACHED_VALUES;
    }

    private Resource(String resource, int id, boolean isHostResource, boolean isBrokerResource, double epsilon) {
        this._resource = resource;
        this._id = id;
        this._isHostResource = isHostResource;
        this._isBrokerResource = isBrokerResource;
        this._epsilon = epsilon;
    }

    public String resource() {
        return this._resource;
    }

    public int id() {
        return this._id;
    }

    public boolean isHostResource() {
        return this._isHostResource;
    }

    public boolean isBrokerResource() {
        return this._isBrokerResource;
    }

    public double epsilon(double value1, double value2) {
        return Math.max(this._epsilon, 8.0E-4 * (value1 + value2));
    }

    public String toString() {
        return this._resource;
    }

    static {
        CACHED_VALUES = Collections.unmodifiableList(Arrays.asList(Resource.values()));
    }
}

