/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.common;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaCruiseControlThreadFactory
implements ThreadFactory {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaCruiseControlThreadFactory.class);
    private final String _name;
    private final boolean _daemon;
    private final AtomicInteger _id = new AtomicInteger(0);
    private final Logger _logger;

    public KafkaCruiseControlThreadFactory(String name, boolean daemon, Logger logger) {
        this._name = name;
        this._daemon = daemon;
        this._logger = logger == null ? LOG : logger;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(r, this._name + "-" + this._id.getAndIncrement());
        t.setDaemon(this._daemon);
        t.setUncaughtExceptionHandler((t1, e) -> this._logger.error("Uncaught exception in " + t1.getName() + ": ", e));
        return t;
    }
}

