/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.async.progress;

import com.linkedin.kafka.cruisecontrol.async.progress.OperationStep;
import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseClass;
import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseField;
import java.util.HashMap;
import java.util.Map;

@JsonResponseClass
public class StepProgress {
    @JsonResponseField
    protected static final String STEP = "step";
    @JsonResponseField
    protected static final String DESCRIPTION = "description";
    @JsonResponseField
    protected static final String TIME_IN_MS = "time-in-ms";
    @JsonResponseField
    protected static final String COMPLETION_PERCENTAGE = "completionPercentage";
    protected final OperationStep _step;
    protected final long _duration;

    public StepProgress(OperationStep step, long duration) {
        this._step = step;
        this._duration = duration;
    }

    protected Map<String, Object> getJsonStructure() {
        HashMap<String, Object> stepProgressMap = new HashMap<String, Object>(4);
        stepProgressMap.put(STEP, this._step.name());
        stepProgressMap.put(DESCRIPTION, this._step.description());
        stepProgressMap.put(TIME_IN_MS, this._duration);
        stepProgressMap.put(COMPLETION_PERCENTAGE, (double)this._step.completionPercentage() * 100.0);
        return stepProgressMap;
    }

    public String toString() {
        return String.format("(%6d ms) - (%3.1f%%) %s: %s%n", this._duration, (double)this._step.completionPercentage() * 100.0, this._step.name(), this._step.description());
    }
}

