/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.async.progress;

import com.linkedin.kafka.cruisecontrol.async.progress.OperationStep;
import com.linkedin.kafka.cruisecontrol.async.progress.StepProgress;
import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseClass;
import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseField;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonResponseClass
public class OperationProgress {
    @JsonResponseField
    protected static final String OPERATION = "operation";
    @JsonResponseField
    protected static final String OPERATION_PROGRESS = "operationProgress";
    private boolean _mutable = true;
    private List<OperationStep> _steps = new ArrayList<OperationStep>();
    private List<Long> _startTimes = new ArrayList<Long>();
    private final String _operation;

    public OperationProgress() {
        this("");
    }

    public OperationProgress(String operation) {
        this._operation = operation;
    }

    public synchronized void addStep(OperationStep step) {
        this.ensureMutable();
        this._steps.add(step);
        this._startTimes.add(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refer(OperationProgress other) {
        List<Long> startTimes;
        List<OperationStep> steps;
        OperationProgress operationProgress = other;
        synchronized (operationProgress) {
            steps = other._steps;
            startTimes = other._startTimes;
        }
        operationProgress = this;
        synchronized (operationProgress) {
            this.ensureMutable();
            this._steps = steps;
            this._startTimes = startTimes;
            this._mutable = false;
        }
    }

    public synchronized List<OperationStep> progress() {
        return Collections.unmodifiableList(this._steps);
    }

    public synchronized void clear() {
        this._mutable = true;
        this._steps.clear();
        this._startTimes.clear();
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this._steps.size(); ++i) {
            OperationStep step = this._steps.get(i);
            long time = (i == this._steps.size() - 1 ? System.currentTimeMillis() : this._startTimes.get(i + 1)) - this._startTimes.get(i);
            sb.append(new StepProgress(step, time).toString());
        }
        return sb.toString();
    }

    public Map<String, Object> getJsonStructure() {
        HashMap<String, Object> operationProgress = new HashMap<String, Object>(2);
        operationProgress.put(OPERATION, this._operation);
        operationProgress.put(OPERATION_PROGRESS, this.getProgress());
        return operationProgress;
    }

    private synchronized Object[] getProgress() {
        Object[] progressArray = new Object[this._steps.size()];
        for (int i = 0; i < this._steps.size(); ++i) {
            OperationStep step = this._steps.get(i);
            long time = (i == this._steps.size() - 1 ? System.currentTimeMillis() : this._startTimes.get(i + 1)) - this._startTimes.get(i);
            progressArray[i] = new StepProgress(step, time).getJsonStructure();
        }
        return progressArray;
    }

    private void ensureMutable() {
        if (!this._mutable) {
            throw new IllegalStateException("Cannot change this operation progress because it is immutable.");
        }
    }
}

