/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.async.progress;

import com.linkedin.kafka.cruisecontrol.async.progress.OperationStep;
import java.util.concurrent.atomic.AtomicInteger;

public class GeneratingClusterModel
implements OperationStep {
    private final int _totalNumPartitions;
    private final AtomicInteger _populatedNumPartitions;

    public GeneratingClusterModel(int totalNumPartitions) {
        this._totalNumPartitions = totalNumPartitions;
        this._populatedNumPartitions = new AtomicInteger(0);
    }

    public void incrementPopulatedNumPartitions() {
        this._populatedNumPartitions.incrementAndGet();
    }

    @Override
    public String name() {
        return "GENERATING_CLUSTER_MODEL";
    }

    @Override
    public float completionPercentage() {
        return this._totalNumPartitions <= 0 ? 1.0f : Math.min(1.0f, (float)this._populatedNumPartitions.get() / (float)this._totalNumPartitions);
    }

    @Override
    public String description() {
        return "Generating the cluster model for the cluster.";
    }
}

