/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals.internals;

import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.Replica;
import java.util.Comparator;
import java.util.NavigableSet;
import java.util.TreeSet;

public class BrokerAndSortedReplicas {
    private final Broker _broker;
    private final NavigableSet<Replica> _sortedReplicas;

    public BrokerAndSortedReplicas(Broker broker, Comparator<Replica> comparator) {
        this._broker = broker;
        this._sortedReplicas = new TreeSet<Replica>((r1, r2) -> {
            int result = comparator.compare((Replica)r1, (Replica)r2);
            return result == 0 ? r1.compareTo((Replica)r2) : result;
        });
        this._sortedReplicas.addAll(broker.replicas());
    }

    public Broker broker() {
        return this._broker;
    }

    public NavigableSet<Replica> sortedReplicas() {
        return this._sortedReplicas;
    }

    public int hashCode() {
        return this._broker.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof BrokerAndSortedReplicas && this._broker.equals(((BrokerAndSortedReplicas)obj).broker());
    }
}

