/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals;

import com.linkedin.kafka.cruisecontrol.analyzer.ActionAcceptance;
import com.linkedin.kafka.cruisecontrol.analyzer.ActionType;
import com.linkedin.kafka.cruisecontrol.analyzer.BalancingAction;
import com.linkedin.kafka.cruisecontrol.analyzer.BalancingConstraint;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizationOptions;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.AbstractGoal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.Goal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.GoalUtils;
import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.common.Statistic;
import com.linkedin.kafka.cruisecontrol.exception.OptimizationFailureException;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.model.ClusterModelStats;
import com.linkedin.kafka.cruisecontrol.model.Load;
import com.linkedin.kafka.cruisecontrol.model.Replica;
import com.linkedin.kafka.cruisecontrol.model.ReplicaSortFunctionFactory;
import com.linkedin.kafka.cruisecontrol.model.SortedReplicasHelper;
import com.linkedin.kafka.cruisecontrol.monitor.ModelCompletenessRequirements;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResourceDistributionGoal
extends AbstractGoal {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceDistributionGoal.class);
    private static final double BALANCE_MARGIN = 0.9;
    private static final long PER_BROKER_SWAP_TIMEOUT_MS = 1000L;
    private boolean _fixOfflineReplicasOnly;
    private double _balanceUpperThreshold;
    private double _balanceLowerThreshold;
    private final Comparator<Broker> _brokerComparator = (b1, b2) -> {
        int result = Double.compare(GoalUtils.utilizationPercentage(b1, this.resource()), GoalUtils.utilizationPercentage(b2, this.resource()));
        return result != 0 ? result : b1.compareTo((Broker)b2);
    };

    public ResourceDistributionGoal() {
    }

    ResourceDistributionGoal(BalancingConstraint constraint) {
        this();
        this._balancingConstraint = constraint;
    }

    protected abstract Resource resource();

    @Override
    public ActionAcceptance actionAcceptance(BalancingAction action, ClusterModel clusterModel) {
        Replica sourceReplica = clusterModel.broker(action.sourceBrokerId()).replica(action.topicPartition());
        Broker destinationBroker = clusterModel.broker(action.destinationBrokerId());
        switch (action.balancingAction()) {
            case INTER_BROKER_REPLICA_SWAP: {
                boolean bothBrokersCurrentlyWithinLimit;
                Replica destinationReplica = destinationBroker.replica(action.destinationTopicPartition());
                double sourceUtilizationDelta = destinationReplica.load().expectedUtilizationFor(this.resource()) - sourceReplica.load().expectedUtilizationFor(this.resource());
                if (sourceUtilizationDelta == 0.0) {
                    return ActionAcceptance.ACCEPT;
                }
                boolean bl = sourceUtilizationDelta > 0.0 ? this.isLoadAboveBalanceLowerLimit(destinationBroker) && this.isLoadUnderBalanceUpperLimit(sourceReplica.broker()) : (bothBrokersCurrentlyWithinLimit = this.isLoadAboveBalanceLowerLimit(sourceReplica.broker()) && this.isLoadUnderBalanceUpperLimit(destinationBroker));
                if (bothBrokersCurrentlyWithinLimit) {
                    return this.isSwapViolatingLimit(sourceReplica, destinationReplica) ? ActionAcceptance.REPLICA_REJECT : ActionAcceptance.ACCEPT;
                }
                return this.isSelfSatisfiedAfterSwap(sourceReplica, destinationReplica) ? ActionAcceptance.ACCEPT : ActionAcceptance.REPLICA_REJECT;
            }
            case INTER_BROKER_REPLICA_MOVEMENT: 
            case LEADERSHIP_MOVEMENT: {
                if (this.isLoadAboveBalanceLowerLimit(sourceReplica.broker()) && this.isLoadUnderBalanceUpperLimit(destinationBroker)) {
                    return this.isLoadUnderBalanceUpperLimitAfterChange(sourceReplica.load(), destinationBroker, ChangeType.ADD) && this.isLoadAboveBalanceLowerLimitAfterChange(sourceReplica.load(), sourceReplica.broker(), ChangeType.REMOVE) ? ActionAcceptance.ACCEPT : ActionAcceptance.REPLICA_REJECT;
                }
                return this.isAcceptableAfterReplicaMove(sourceReplica, destinationBroker) ? ActionAcceptance.ACCEPT : ActionAcceptance.REPLICA_REJECT;
            }
        }
        throw new IllegalArgumentException("Unsupported balancing action " + action.balancingAction() + " is provided.");
    }

    @Override
    public Goal.ClusterModelStatsComparator clusterModelStatsComparator() {
        return new ResourceDistributionGoalStatsComparator();
    }

    @Override
    public ModelCompletenessRequirements clusterModelCompletenessRequirements() {
        return new ModelCompletenessRequirements(Math.max(1, this._numWindows / 14), this._minMonitoredPartitionPercentage, false);
    }

    @Override
    public abstract String name();

    @Override
    public boolean isHardGoal() {
        return false;
    }

    @Override
    protected SortedSet<Broker> brokersToBalance(ClusterModel clusterModel) {
        return clusterModel.newBrokers().isEmpty() ? clusterModel.brokers() : clusterModel.newBrokers();
    }

    @Override
    protected boolean selfSatisfied(ClusterModel clusterModel, BalancingAction action) {
        Broker destinationBroker = clusterModel.broker(action.destinationBrokerId());
        Replica sourceReplica = clusterModel.broker(action.sourceBrokerId()).replica(action.topicPartition());
        if (this._fixOfflineReplicasOnly && sourceReplica.broker().replica(action.topicPartition()).isCurrentOffline()) {
            return action.balancingAction() == ActionType.INTER_BROKER_REPLICA_MOVEMENT;
        }
        switch (action.balancingAction()) {
            case INTER_BROKER_REPLICA_SWAP: {
                Replica destinationReplica = destinationBroker.replica(action.destinationTopicPartition());
                double sourceUtilizationDelta = destinationReplica.load().expectedUtilizationFor(this.resource()) - sourceReplica.load().expectedUtilizationFor(this.resource());
                return sourceUtilizationDelta != 0.0 && !this.isSwapViolatingLimit(sourceReplica, destinationReplica);
            }
            case INTER_BROKER_REPLICA_MOVEMENT: 
            case LEADERSHIP_MOVEMENT: {
                return this.isLoadUnderBalanceUpperLimitAfterChange(sourceReplica.load(), destinationBroker, ChangeType.ADD) && this.isLoadAboveBalanceLowerLimitAfterChange(sourceReplica.load(), sourceReplica.broker(), ChangeType.REMOVE);
            }
        }
        throw new IllegalArgumentException("Unsupported balancing action " + action.balancingAction() + " is provided.");
    }

    @Override
    protected void initGoalState(ClusterModel clusterModel, OptimizationOptions optimizationOptions) {
        this._fixOfflineReplicasOnly = false;
        this._balanceUpperThreshold = this.computeBalanceUpperThreshold(clusterModel, optimizationOptions);
        this._balanceLowerThreshold = this.computeBalanceLowerThreshold(clusterModel, optimizationOptions);
    }

    protected double balanceUpperThreshold() {
        return this._balanceUpperThreshold;
    }

    protected double balanceLowerThreshold() {
        return this._balanceLowerThreshold;
    }

    @Override
    protected void updateGoalState(ClusterModel clusterModel, OptimizationOptions optimizationOptions) throws OptimizationFailureException {
        HashSet<Integer> brokerIdsAboveBalanceUpperLimit = new HashSet<Integer>();
        HashSet<Integer> brokerIdsUnderBalanceLowerLimit = new HashSet<Integer>();
        for (Broker broker : clusterModel.aliveBrokers()) {
            if (!this.isLoadUnderBalanceUpperLimit(broker)) {
                brokerIdsAboveBalanceUpperLimit.add(broker.id());
            }
            if (this.isLoadAboveBalanceLowerLimit(broker)) continue;
            brokerIdsUnderBalanceLowerLimit.add(broker.id());
        }
        if (!brokerIdsAboveBalanceUpperLimit.isEmpty()) {
            LOG.debug("Utilization for broker ids:{} {} above the balance limit for:{} after {}.", new Object[]{brokerIdsAboveBalanceUpperLimit, brokerIdsAboveBalanceUpperLimit.size() > 1 ? "are" : "is", this.resource(), clusterModel.selfHealingEligibleReplicas().isEmpty() ? "rebalance" : "self-healing"});
            this._succeeded = false;
        }
        if (!brokerIdsUnderBalanceLowerLimit.isEmpty()) {
            LOG.debug("Utilization for broker ids:{} {} under the balance limit for:{} after {}.", new Object[]{brokerIdsUnderBalanceLowerLimit, brokerIdsUnderBalanceLowerLimit.size() > 1 ? "are" : "is", this.resource(), clusterModel.selfHealingEligibleReplicas().isEmpty() ? "rebalance" : "self-healing"});
            this._succeeded = false;
        }
        try {
            GoalUtils.ensureNoOfflineReplicas(clusterModel, this.name());
        }
        catch (OptimizationFailureException ofe) {
            if (this._fixOfflineReplicasOnly) {
                throw ofe;
            }
            this._fixOfflineReplicasOnly = true;
            LOG.info("Ignoring resource balance limit to move replicas from dead brokers/disks.");
            return;
        }
        GoalUtils.ensureReplicasMoveOffBrokersWithBadDisks(clusterModel, this.name());
        this.finish();
    }

    @Override
    public void finish() {
        this._finished = true;
    }

    @Override
    protected void rebalanceForBroker(Broker broker, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions) {
        int numOfflineReplicas = broker.currentOfflineReplicas().size();
        boolean requireLessLoad = numOfflineReplicas > 0 || !this.isLoadUnderBalanceUpperLimit(broker);
        boolean requireMoreLoad = !this.isLoadAboveBalanceLowerLimit(broker);
        boolean moveImmigrantsOnly = false;
        if (broker.currentOfflineReplicas().isEmpty()) {
            if (!requireMoreLoad && !requireLessLoad) {
                return;
            }
            boolean bl = moveImmigrantsOnly = !clusterModel.selfHealingEligibleReplicas().isEmpty() || optimizationOptions.onlyMoveImmigrantReplicas();
            if (moveImmigrantsOnly && requireLessLoad && broker.immigrantReplicas().isEmpty()) {
                return;
            }
        }
        if (!(this.resource() != Resource.NW_OUT && this.resource() != Resource.CPU || this._fixOfflineReplicasOnly && !broker.currentOfflineReplicas().isEmpty())) {
            if (requireLessLoad && !this.rebalanceByMovingLoadOut(broker, clusterModel, optimizedGoals, ActionType.LEADERSHIP_MOVEMENT, optimizationOptions)) {
                LOG.debug("Successfully balanced {} for broker {} by moving out leaders.", (Object)this.resource(), (Object)broker.id());
                requireLessLoad = false;
            }
            if (requireMoreLoad && !this.rebalanceByMovingLoadIn(broker, clusterModel, optimizedGoals, ActionType.LEADERSHIP_MOVEMENT, optimizationOptions, false)) {
                LOG.debug("Successfully balanced {} for broker {} by moving in leaders.", (Object)this.resource(), (Object)broker.id());
                requireMoreLoad = false;
            }
        }
        boolean unbalanced = false;
        if (requireLessLoad && this.rebalanceByMovingLoadOut(broker, clusterModel, optimizedGoals, ActionType.INTER_BROKER_REPLICA_MOVEMENT, optimizationOptions)) {
            unbalanced = this.rebalanceBySwappingLoadOut(broker, clusterModel, optimizedGoals, optimizationOptions, moveImmigrantsOnly);
        }
        if (requireMoreLoad && this.rebalanceByMovingLoadIn(broker, clusterModel, optimizedGoals, ActionType.INTER_BROKER_REPLICA_MOVEMENT, optimizationOptions, moveImmigrantsOnly)) {
            boolean bl = unbalanced = unbalanced || this.rebalanceBySwappingLoadIn(broker, clusterModel, optimizedGoals, optimizationOptions, moveImmigrantsOnly);
        }
        if (!unbalanced) {
            LOG.debug("Successfully balanced {} for broker {} by moving leaders and replicas.", (Object)this.resource(), (Object)broker.id());
        }
    }

    private boolean rebalanceByMovingLoadIn(Broker broker, ClusterModel clusterModel, Set<Goal> optimizedGoals, ActionType actionType, OptimizationOptions optimizationOptions, boolean moveImmigrantsOnly) {
        if (!clusterModel.newBrokers().isEmpty() && !broker.isNew()) {
            return true;
        }
        Set<String> excludedTopics = optimizationOptions.excludedTopics();
        boolean moveFollowersOnly = optimizationOptions.excludedBrokersForLeadership().contains(broker.id());
        PriorityQueue<Broker> candidateBrokerPQ = new PriorityQueue<Broker>(this._brokerComparator.reversed());
        double clusterUtilization = clusterModel.load().expectedUtilizationFor(this.resource()) / clusterModel.capacityFor(this.resource());
        String replicaSortName = null;
        for (Broker candidate : clusterModel.aliveBrokers()) {
            if (!(GoalUtils.utilizationPercentage(candidate, this.resource()) > clusterUtilization)) continue;
            replicaSortName = this.sortedCandidateReplicas(candidate, excludedTopics, 0.0, false, moveFollowersOnly, this.resource() == Resource.NW_OUT, moveImmigrantsOnly);
            candidateBrokerPQ.add(candidate);
        }
        block1: while (!candidateBrokerPQ.isEmpty() && (actionType == ActionType.INTER_BROKER_REPLICA_MOVEMENT || actionType == ActionType.LEADERSHIP_MOVEMENT && broker.leaderReplicas().size() != broker.replicas().size())) {
            Broker cb = candidateBrokerPQ.poll();
            SortedSet<Replica> candidateReplicasToReceive = cb.trackedSortedReplicas(replicaSortName).sortedReplicas(true);
            Iterator iterator = candidateReplicasToReceive.iterator();
            while (iterator.hasNext()) {
                Replica replica = (Replica)iterator.next();
                Broker b = this.maybeApplyBalancingAction(clusterModel, replica, Collections.singletonList(broker), actionType, optimizedGoals, optimizationOptions);
                if (b == null) continue;
                if (this.isLoadAboveBalanceLowerLimit(broker)) {
                    clusterModel.untrackSortedReplicas(replicaSortName);
                    return false;
                }
                if (actionType == ActionType.INTER_BROKER_REPLICA_MOVEMENT) {
                    iterator.remove();
                }
                if (candidateBrokerPQ.isEmpty() || !(GoalUtils.utilizationPercentage(cb, this.resource()) < GoalUtils.utilizationPercentage(candidateBrokerPQ.peek(), this.resource()))) continue;
                candidateBrokerPQ.add(cb);
                continue block1;
            }
        }
        clusterModel.untrackSortedReplicas(replicaSortName);
        return true;
    }

    private String sortedCandidateReplicas(Broker broker, Set<String> excludedTopics, double loadLimit, boolean isAscending, boolean followersOnly, boolean leadersOnly, boolean immigrantsOnly) {
        SortedReplicasHelper helper = new SortedReplicasHelper();
        helper.maybeAddSelectionFunc(ReplicaSortFunctionFactory.selectFollowers(), followersOnly).maybeAddSelectionFunc(ReplicaSortFunctionFactory.selectLeaders(), leadersOnly).maybeAddSelectionFunc(ReplicaSortFunctionFactory.selectImmigrants(), immigrantsOnly).addSelectionFunc(ReplicaSortFunctionFactory.selectReplicasBasedOnExcludedTopics(excludedTopics)).addPriorityFunc(ReplicaSortFunctionFactory.prioritizeOfflineReplicas());
        if (isAscending) {
            helper.addSelectionFunc(ReplicaSortFunctionFactory.selectReplicasBelowLimit(this.resource(), loadLimit)).setScoreFunc(ReplicaSortFunctionFactory.sortByMetricGroupValue(this.resource().name()));
        } else {
            helper.addSelectionFunc(ReplicaSortFunctionFactory.selectReplicasAboveLimit(this.resource(), loadLimit)).setScoreFunc(ReplicaSortFunctionFactory.reverseSortByMetricGroupValue(this.resource().name()));
        }
        String replicaSortName = GoalUtils.replicaSortName(this, !isAscending, leadersOnly);
        helper.trackSortedReplicasFor(replicaSortName, broker);
        return replicaSortName;
    }

    private double getMaxReplicaLoad(SortedSet<Replica> sortedReplicas) {
        double maxReplicaLoad = sortedReplicas.first().load().expectedUtilizationFor(this.resource());
        for (Replica replica : sortedReplicas) {
            if (replica.isCurrentOffline()) continue;
            if (!(replica.load().expectedUtilizationFor(this.resource()) > maxReplicaLoad)) break;
            maxReplicaLoad = replica.load().expectedUtilizationFor(this.resource());
            break;
        }
        return maxReplicaLoad;
    }

    private double getMinReplicaLoad(SortedSet<Replica> sortedReplicas) {
        double minReplicaLoad = sortedReplicas.first().load().expectedUtilizationFor(this.resource());
        for (Replica replica : sortedReplicas) {
            if (replica.isCurrentOffline()) continue;
            if (!(replica.load().expectedUtilizationFor(this.resource()) < minReplicaLoad)) break;
            minReplicaLoad = replica.load().expectedUtilizationFor(this.resource());
            break;
        }
        return minReplicaLoad;
    }

    private boolean rebalanceBySwappingLoadOut(Broker broker, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions, boolean moveImmigrantsOnly) {
        long swapStartTimeMs = System.currentTimeMillis();
        if (!broker.isAlive() || optimizationOptions.excludedBrokersForReplicaMove().contains(broker.id())) {
            return true;
        }
        Set<String> excludedTopics = optimizationOptions.excludedTopics();
        String sourceReplicaSortName = this.sortedCandidateReplicas(broker, excludedTopics, 0.0, false, false, this.resource() == Resource.NW_OUT, moveImmigrantsOnly);
        SortedSet<Replica> sourceReplicas = broker.trackedSortedReplicas(sourceReplicaSortName).sortedReplicas(false);
        if (sourceReplicas.isEmpty()) {
            broker.untrackSortedReplicas(sourceReplicaSortName);
            return true;
        }
        double maxSourceReplicaLoad = this.getMaxReplicaLoad(sourceReplicas);
        boolean swapWithFollowersOnly = optimizationOptions.excludedBrokersForLeadership().contains(broker.id());
        PriorityQueue<Broker> candidateBrokerPQ = new PriorityQueue<Broker>(this._brokerComparator);
        String candidateReplicaSortName = null;
        for (Broker candidate : clusterModel.aliveBrokersUnderThreshold(this.resource(), this._balanceUpperThreshold).stream().filter(b -> !b.replicas().isEmpty()).collect(Collectors.toSet())) {
            candidateReplicaSortName = this.sortedCandidateReplicas(candidate, excludedTopics, maxSourceReplicaLoad, true, swapWithFollowersOnly, false, moveImmigrantsOnly);
            candidateBrokerPQ.add(candidate);
        }
        while (!candidateBrokerPQ.isEmpty()) {
            if (this.remainingPerBrokerSwapTimeMs(swapStartTimeMs) <= 0L) {
                LOG.debug("Swap load out timeout for broker {}.", (Object)broker.id());
                break;
            }
            Broker cb = candidateBrokerPQ.poll();
            Replica swappedInReplica = null;
            for (Replica sourceReplica : sourceReplicas) {
                Replica swappedIn = this.maybeApplySwapAction(clusterModel, sourceReplica, cb.trackedSortedReplicas(candidateReplicaSortName).sortedReplicas(false), optimizedGoals, optimizationOptions);
                if (swappedIn != null) {
                    if (this.isLoadUnderBalanceUpperLimit(broker)) {
                        clusterModel.clearSortedReplicas();
                        return false;
                    }
                    swappedInReplica = swappedIn;
                    break;
                }
                if (this.remainingPerBrokerSwapTimeMs(swapStartTimeMs) > 0L) continue;
                LOG.debug("Swap load out timeout for source replica {}.", (Object)sourceReplica);
                clusterModel.clearSortedReplicas();
                return true;
            }
            if (swappedInReplica == null) continue;
            sourceReplicas = broker.trackedSortedReplicas(sourceReplicaSortName).sortedReplicas(false);
            candidateBrokerPQ.add(cb);
        }
        clusterModel.clearSortedReplicas();
        return true;
    }

    private long remainingPerBrokerSwapTimeMs(long swapStartTimeMs) {
        return 1000L - (System.currentTimeMillis() - swapStartTimeMs);
    }

    private boolean rebalanceBySwappingLoadIn(Broker broker, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions, boolean moveImmigrantsOnly) {
        long swapStartTimeMs = System.currentTimeMillis();
        if (!broker.isAlive() || optimizationOptions.excludedBrokersForReplicaMove().contains(broker.id())) {
            return true;
        }
        Set<String> excludedTopics = optimizationOptions.excludedTopics();
        String sourceReplicaSortName = this.sortedCandidateReplicas(broker, excludedTopics, Double.MAX_VALUE, true, false, false, moveImmigrantsOnly);
        SortedSet<Replica> sourceReplicas = broker.trackedSortedReplicas(sourceReplicaSortName).sortedReplicas(false);
        if (sourceReplicas.isEmpty()) {
            broker.untrackSortedReplicas(sourceReplicaSortName);
            return true;
        }
        double minSourceReplicaLoad = this.getMinReplicaLoad(sourceReplicas);
        boolean swapWithFollowersOnly = optimizationOptions.excludedBrokersForLeadership().contains(broker.id());
        PriorityQueue<Broker> candidateBrokerPQ = new PriorityQueue<Broker>(this._brokerComparator.reversed());
        String candidateReplicaSortName = null;
        for (Broker candidate : clusterModel.aliveBrokersOverThreshold(this.resource(), this._balanceLowerThreshold)) {
            candidateReplicaSortName = this.sortedCandidateReplicas(candidate, excludedTopics, minSourceReplicaLoad, false, swapWithFollowersOnly, this.resource() == Resource.NW_OUT, moveImmigrantsOnly);
            candidateBrokerPQ.add(candidate);
        }
        while (!candidateBrokerPQ.isEmpty()) {
            if (this.remainingPerBrokerSwapTimeMs(swapStartTimeMs) <= 0L) {
                LOG.debug("Swap load in timeout for broker {}.", (Object)broker.id());
                break;
            }
            Broker cb = candidateBrokerPQ.poll();
            Replica swappedInReplica = null;
            for (Replica sourceReplica : sourceReplicas) {
                SortedSet<Replica> candidateReplicas;
                Replica swappedIn = this.maybeApplySwapAction(clusterModel, sourceReplica, candidateReplicas = cb.trackedSortedReplicas(candidateReplicaSortName).sortedReplicas(false), optimizedGoals, optimizationOptions);
                if (swappedIn != null) {
                    if (this.isLoadAboveBalanceLowerLimit(broker)) {
                        clusterModel.clearSortedReplicas();
                        return false;
                    }
                    swappedInReplica = swappedIn;
                    break;
                }
                if (this.remainingPerBrokerSwapTimeMs(swapStartTimeMs) > 0L) continue;
                LOG.debug("Swap load in timeout for source replica {}.", (Object)sourceReplica);
                clusterModel.clearSortedReplicas();
                return true;
            }
            if (swappedInReplica == null) continue;
            sourceReplicas = broker.trackedSortedReplicas(sourceReplicaSortName).sortedReplicas(false);
            candidateBrokerPQ.add(cb);
        }
        clusterModel.clearSortedReplicas();
        return true;
    }

    private boolean rebalanceByMovingLoadOut(Broker broker, ClusterModel clusterModel, Set<Goal> optimizedGoals, ActionType actionType, OptimizationOptions optimizationOptions) {
        Replica replica;
        Set<String> excludedTopics = optimizationOptions.excludedTopics();
        TreeSet<Broker> candidateBrokers = new TreeSet<Broker>(Comparator.comparingDouble(b -> GoalUtils.utilizationPercentage(b, this.resource())).thenComparingInt(Broker::id));
        if (this._fixOfflineReplicasOnly) {
            candidateBrokers.addAll(clusterModel.aliveBrokers());
        } else {
            candidateBrokers.addAll(clusterModel.aliveBrokersUnderThreshold(this.resource(), this._balanceUpperThreshold));
        }
        new SortedReplicasHelper().maybeAddSelectionFunc(ReplicaSortFunctionFactory.selectLeaders(), actionType == ActionType.LEADERSHIP_MOVEMENT).maybeAddSelectionFunc(ReplicaSortFunctionFactory.selectImmigrants(), optimizationOptions.onlyMoveImmigrantReplicas()).maybeAddSelectionFunc(ReplicaSortFunctionFactory.selectImmigrantOrOfflineReplicas(), !clusterModel.selfHealingEligibleReplicas().isEmpty() && broker.isAlive()).addSelectionFunc(ReplicaSortFunctionFactory.selectReplicasBasedOnExcludedTopics(excludedTopics)).addPriorityFunc(ReplicaSortFunctionFactory.prioritizeOfflineReplicas()).maybeAddPriorityFunc(ReplicaSortFunctionFactory.prioritizeImmigrants(), !optimizationOptions.onlyMoveImmigrantReplicas()).setScoreFunc(ReplicaSortFunctionFactory.reverseSortByMetricGroupValue(this.resource().name())).trackSortedReplicasFor(GoalUtils.replicaSortName(this, true, actionType == ActionType.LEADERSHIP_MOVEMENT), broker);
        SortedSet<Replica> replicasToMove = broker.trackedSortedReplicas(GoalUtils.replicaSortName(this, true, actionType == ActionType.LEADERSHIP_MOVEMENT)).sortedReplicas(true);
        Iterator iterator = replicasToMove.iterator();
        while (iterator.hasNext() && ((replica = (Replica)iterator.next()).load().expectedUtilizationFor(this.resource()) != 0.0 || replica.isCurrentOffline())) {
            Broker b2;
            TreeSet<Broker> eligibleBrokers;
            if (actionType == ActionType.LEADERSHIP_MOVEMENT) {
                eligibleBrokers = new TreeSet<Broker>(Comparator.comparingDouble(b -> GoalUtils.utilizationPercentage(b, this.resource())).thenComparingInt(Broker::id));
                clusterModel.partition(replica.topicPartition()).onlineFollowerBrokers().forEach(b -> {
                    if (candidateBrokers.contains(b)) {
                        eligibleBrokers.add((Broker)b);
                    }
                });
            } else {
                eligibleBrokers = candidateBrokers;
            }
            if ((b2 = this.maybeApplyBalancingAction(clusterModel, replica, eligibleBrokers, actionType, optimizedGoals, optimizationOptions)) == null) continue;
            if (this.isLoadUnderBalanceUpperLimit(broker) && (!this._fixOfflineReplicasOnly || broker.currentOfflineReplicas().isEmpty())) {
                broker.clearSortedReplicas();
                return false;
            }
            candidateBrokers.remove(b2);
            if (!(GoalUtils.utilizationPercentage(b2, this.resource()) < this._balanceUpperThreshold)) continue;
            candidateBrokers.add(b2);
        }
        broker.clearSortedReplicas();
        return !broker.replicas().isEmpty();
    }

    private boolean isLoadAboveBalanceLowerLimit(Broker broker) {
        return this.isLoadAboveBalanceLowerLimitAfterChange(null, broker, ChangeType.ADD);
    }

    private boolean isLoadUnderBalanceUpperLimit(Broker broker) {
        return this.isLoadUnderBalanceUpperLimitAfterChange(null, broker, ChangeType.REMOVE);
    }

    private boolean isLoadAboveBalanceLowerLimitAfterChange(Load load, Broker broker, ChangeType changeType) {
        boolean isBrokerAboveLowerLimit;
        double utilizationDelta = load == null ? 0.0 : load.expectedUtilizationFor(this.resource());
        double brokerBalanceLowerLimit = broker.capacityFor(this.resource()) * this._balanceLowerThreshold;
        double brokerUtilization = broker.load().expectedUtilizationFor(this.resource());
        boolean bl = changeType == ChangeType.ADD ? brokerUtilization + utilizationDelta >= brokerBalanceLowerLimit : (isBrokerAboveLowerLimit = brokerUtilization - utilizationDelta >= brokerBalanceLowerLimit);
        if (this.resource().isHostResource()) {
            double hostBalanceLowerLimit = broker.host().capacityFor(this.resource()) * this._balanceLowerThreshold;
            double hostUtilization = broker.host().load().expectedUtilizationFor(this.resource());
            boolean isHostAboveLowerLimit = changeType == ChangeType.ADD ? hostUtilization + utilizationDelta >= hostBalanceLowerLimit : hostUtilization - utilizationDelta >= hostBalanceLowerLimit;
            return isHostAboveLowerLimit || isBrokerAboveLowerLimit;
        }
        return isBrokerAboveLowerLimit;
    }

    private boolean isLoadUnderBalanceUpperLimitAfterChange(Load load, Broker broker, ChangeType changeType) {
        boolean isBrokerUnderUpperLimit;
        double utilizationDelta = load == null ? 0.0 : load.expectedUtilizationFor(this.resource());
        double brokerBalanceUpperLimit = broker.capacityFor(this.resource()) * this._balanceUpperThreshold;
        double brokerUtilization = broker.load().expectedUtilizationFor(this.resource());
        boolean bl = changeType == ChangeType.ADD ? brokerUtilization + utilizationDelta <= brokerBalanceUpperLimit : (isBrokerUnderUpperLimit = brokerUtilization - utilizationDelta <= brokerBalanceUpperLimit);
        if (this.resource().isHostResource()) {
            double hostBalanceUpperLimit = broker.host().capacityFor(this.resource()) * this._balanceUpperThreshold;
            double hostUtilization = broker.host().load().expectedUtilizationFor(this.resource());
            boolean isHostUnderUpperLimit = changeType == ChangeType.ADD ? hostUtilization + utilizationDelta <= hostBalanceUpperLimit : hostUtilization - utilizationDelta <= hostBalanceUpperLimit;
            return isHostUnderUpperLimit || isBrokerUnderUpperLimit;
        }
        return isBrokerUnderUpperLimit;
    }

    private boolean isAcceptableAfterReplicaMove(Replica sourceReplica, Broker destinationBroker) {
        double sourceUtilizationDelta = -sourceReplica.load().expectedUtilizationFor(this.resource());
        return this.isGettingMoreBalanced(sourceReplica.broker(), sourceUtilizationDelta, destinationBroker);
    }

    private boolean isSelfSatisfiedAfterSwap(Replica sourceReplica, Replica destinationReplica) {
        double sourceUtilizationDelta = destinationReplica.load().expectedUtilizationFor(this.resource()) - sourceReplica.load().expectedUtilizationFor(this.resource());
        return this.isGettingMoreBalanced(sourceReplica.broker(), sourceUtilizationDelta, destinationReplica.broker());
    }

    private boolean isGettingMoreBalanced(Broker sourceBroker, double sourceUtilizationDelta, Broker destinationBroker) {
        double destinationBrokerCapacity;
        double sourceBrokerUtilization = sourceBroker.load().expectedUtilizationFor(this.resource());
        double destinationBrokerUtilization = destinationBroker.load().expectedUtilizationFor(this.resource());
        double sourceBrokerCapacity = sourceBroker.capacityFor(this.resource());
        double prevDiff = sourceBrokerUtilization / sourceBrokerCapacity - destinationBrokerUtilization / (destinationBrokerCapacity = destinationBroker.capacityFor(this.resource()));
        double nextDiff = prevDiff + sourceUtilizationDelta / sourceBrokerCapacity + sourceUtilizationDelta / destinationBrokerCapacity;
        return Math.abs(nextDiff) < Math.abs(prevDiff);
    }

    private boolean isSwapViolatingLimit(Replica sourceReplica, Replica destinationReplica) {
        double sourceUtilizationDelta = destinationReplica.load().expectedUtilizationFor(this.resource()) - sourceReplica.load().expectedUtilizationFor(this.resource());
        boolean swapViolatingBrokerLimit = this.isSwapViolatingContainerLimit(sourceUtilizationDelta, sourceReplica, destinationReplica, r -> r.broker().load(), r -> r.broker().capacityFor(this.resource()));
        if (!swapViolatingBrokerLimit || !this.resource().isHostResource()) {
            return swapViolatingBrokerLimit;
        }
        return this.isSwapViolatingContainerLimit(sourceUtilizationDelta, sourceReplica, destinationReplica, r -> r.broker().host().load(), r -> r.broker().host().capacityFor(this.resource()));
    }

    private boolean isSwapViolatingContainerLimit(double sourceUtilizationDelta, Replica sourceReplica, Replica destinationReplica, Function<Replica, Load> loadFunction, Function<Replica, Double> capacityFunction) {
        double destinationContainerBalanceLowerLimit;
        double sourceContainerBalanceLowerLimit;
        boolean isContainerUnderUpperLimit;
        double sourceContainerUtilization = loadFunction.apply(sourceReplica).expectedUtilizationFor(this.resource());
        double destinationContainerUtilization = loadFunction.apply(destinationReplica).expectedUtilizationFor(this.resource());
        if (sourceUtilizationDelta > 0.0) {
            double sourceContainerBalanceUpperLimit = capacityFunction.apply(sourceReplica) * this._balanceUpperThreshold;
            isContainerUnderUpperLimit = sourceContainerUtilization + sourceUtilizationDelta <= sourceContainerBalanceUpperLimit;
        } else {
            double destinationContainerBalanceUpperLimit = capacityFunction.apply(destinationReplica) * this._balanceUpperThreshold;
            boolean bl = isContainerUnderUpperLimit = destinationContainerUtilization - sourceUtilizationDelta <= destinationContainerBalanceUpperLimit;
        }
        if (!isContainerUnderUpperLimit) {
            return true;
        }
        boolean isContainerAboveLowerLimit = sourceUtilizationDelta < 0.0 ? sourceContainerUtilization + sourceUtilizationDelta >= (sourceContainerBalanceLowerLimit = capacityFunction.apply(sourceReplica) * this._balanceLowerThreshold) : destinationContainerUtilization - sourceUtilizationDelta >= (destinationContainerBalanceLowerLimit = capacityFunction.apply(destinationReplica) * this._balanceLowerThreshold);
        return !isContainerAboveLowerLimit;
    }

    private double computeBalanceUpperThreshold(ClusterModel clusterModel, OptimizationOptions optimizationOptions) {
        return clusterModel.load().expectedUtilizationFor(this.resource()) / clusterModel.capacityFor(this.resource()) * (1.0 + this.balancePercentageWithMargin(optimizationOptions));
    }

    private double computeBalanceLowerThreshold(ClusterModel clusterModel, OptimizationOptions optimizationOptions) {
        return clusterModel.load().expectedUtilizationFor(this.resource()) / clusterModel.capacityFor(this.resource()) * Math.max(0.0, 1.0 - this.balancePercentageWithMargin(optimizationOptions));
    }

    private double balancePercentageWithMargin(OptimizationOptions optimizationOptions) {
        double balancePercentage = optimizationOptions.isTriggeredByGoalViolation() ? this._balancingConstraint.resourceBalancePercentage(this.resource()) * this._balancingConstraint.goalViolationDistributionThresholdMultiplier() : this._balancingConstraint.resourceBalancePercentage(this.resource());
        return (balancePercentage - 1.0) * 0.9;
    }

    protected static enum ChangeType {
        ADD,
        REMOVE;

    }

    private class ResourceDistributionGoalStatsComparator
    implements Goal.ClusterModelStatsComparator {
        private String _reasonForLastNegativeResult;

        private ResourceDistributionGoalStatsComparator() {
        }

        @Override
        public int compare(ClusterModelStats stats1, ClusterModelStats stats2) {
            int numBalancedBroker1 = stats1.numBalancedBrokersByResource().get((Object)ResourceDistributionGoal.this.resource());
            int numBalancedBroker2 = stats2.numBalancedBrokersByResource().get((Object)ResourceDistributionGoal.this.resource());
            if (numBalancedBroker2 > numBalancedBroker1) {
                double afterUtilizationStd = stats1.resourceUtilizationStats().get((Object)Statistic.ST_DEV).get((Object)ResourceDistributionGoal.this.resource());
                double beforeUtilizationStd = stats2.resourceUtilizationStats().get((Object)Statistic.ST_DEV).get((Object)ResourceDistributionGoal.this.resource());
                if (Double.compare(beforeUtilizationStd, afterUtilizationStd) < 0) {
                    this._reasonForLastNegativeResult = String.format("Violated %s. [Number of Balanced Brokers] for resource %s. post-optimization:%d pre-optimization:%d without improving the standard dev. of utilization. post-optimization:%.2f pre-optimization:%.2f", new Object[]{ResourceDistributionGoal.this.name(), ResourceDistributionGoal.this.resource(), numBalancedBroker1, numBalancedBroker2, afterUtilizationStd, beforeUtilizationStd});
                    return -1;
                }
            }
            return 1;
        }

        @Override
        public String explainLastComparison() {
            return this._reasonForLastNegativeResult;
        }
    }
}

