/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals;

import com.linkedin.kafka.cruisecontrol.analyzer.ActionAcceptance;
import com.linkedin.kafka.cruisecontrol.analyzer.BalancingAction;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizationOptions;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.AbstractGoal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.GoalUtils;
import com.linkedin.kafka.cruisecontrol.exception.OptimizationFailureException;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.monitor.ModelCompletenessRequirements;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReplicaDistributionAbstractGoal
extends AbstractGoal {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicaDistributionAbstractGoal.class);
    private static final double BALANCE_MARGIN = 0.9;
    protected boolean _fixOfflineReplicasOnly;
    protected final Set<Integer> _brokerIdsAboveBalanceUpperLimit = new HashSet<Integer>();
    protected final Set<Integer> _brokerIdsUnderBalanceLowerLimit = new HashSet<Integer>();
    protected double _avgReplicasOnAliveBroker;
    protected int _balanceUpperLimit;
    protected int _balanceLowerLimit;

    private double adjustedBalancePercentage(OptimizationOptions optimizationOptions, double balancePercentage) {
        double adjustedBalancePercentage = optimizationOptions.isTriggeredByGoalViolation() ? balancePercentage * this._balancingConstraint.goalViolationDistributionThresholdMultiplier() : balancePercentage;
        return (adjustedBalancePercentage - 1.0) * 0.9;
    }

    private int balanceUpperLimit(OptimizationOptions optimizationOptions, double balancePercentage) {
        return (int)Math.ceil(this._avgReplicasOnAliveBroker * (1.0 + this.adjustedBalancePercentage(optimizationOptions, balancePercentage)));
    }

    private int balanceLowerLimit(OptimizationOptions optimizationOptions, double balancePercentage) {
        return (int)Math.floor(this._avgReplicasOnAliveBroker * Math.max(0.0, 1.0 - this.adjustedBalancePercentage(optimizationOptions, balancePercentage)));
    }

    boolean isReplicaCountUnderBalanceUpperLimitAfterChange(Broker broker, int currentReplicaCount, ChangeType changeType) {
        int brokerBalanceUpperLimit;
        int n = brokerBalanceUpperLimit = broker.isAlive() ? this._balanceUpperLimit : 0;
        return changeType == ChangeType.ADD ? currentReplicaCount + 1 <= brokerBalanceUpperLimit : currentReplicaCount - 1 <= brokerBalanceUpperLimit;
    }

    boolean isReplicaCountAboveBalanceLowerLimitAfterChange(Broker broker, int currentReplicaCount, ChangeType changeType) {
        int brokerBalanceLowerLimit;
        int n = brokerBalanceLowerLimit = broker.isAlive() ? this._balanceLowerLimit : 0;
        return changeType == ChangeType.ADD ? currentReplicaCount + 1 >= brokerBalanceLowerLimit : currentReplicaCount - 1 >= brokerBalanceLowerLimit;
    }

    @Override
    public ModelCompletenessRequirements clusterModelCompletenessRequirements() {
        return new ModelCompletenessRequirements(1, 0.0, true);
    }

    @Override
    public boolean isHardGoal() {
        return false;
    }

    @Override
    protected SortedSet<Broker> brokersToBalance(ClusterModel clusterModel) {
        return clusterModel.brokers();
    }

    @Override
    protected void initGoalState(ClusterModel clusterModel, OptimizationOptions optimizationOptions) {
        this._avgReplicasOnAliveBroker = (double)this.numInterestedReplicas(clusterModel) / (double)clusterModel.aliveBrokers().size();
        if (clusterModel.topics().equals(optimizationOptions.excludedTopics())) {
            LOG.warn("All replicas are excluded from {}.", (Object)this.name());
        }
        this._fixOfflineReplicasOnly = false;
        this._balanceUpperLimit = this.balanceUpperLimit(optimizationOptions, this.balancePercentage());
        this._balanceLowerLimit = this.balanceLowerLimit(optimizationOptions, this.balancePercentage());
    }

    abstract int numInterestedReplicas(ClusterModel var1);

    abstract double balancePercentage();

    @Override
    protected boolean selfSatisfied(ClusterModel clusterModel, BalancingAction action) {
        Broker sourceBroker = clusterModel.broker(action.sourceBrokerId());
        if (this._fixOfflineReplicasOnly && sourceBroker.replica(action.topicPartition()).isCurrentOffline()) {
            return true;
        }
        return this.actionAcceptance(action, clusterModel) == ActionAcceptance.ACCEPT;
    }

    @Override
    protected void updateGoalState(ClusterModel clusterModel, OptimizationOptions optimizationOptions) throws OptimizationFailureException {
        if (!this._brokerIdsAboveBalanceUpperLimit.isEmpty()) {
            LOG.debug("Replicas count on broker ids:{} {} above the balance limit of {} after {}.", new Object[]{this._brokerIdsAboveBalanceUpperLimit, this._brokerIdsAboveBalanceUpperLimit.size() > 1 ? "are" : "is", this._balanceUpperLimit, clusterModel.selfHealingEligibleReplicas().isEmpty() ? "rebalance" : "self-healing"});
            this._brokerIdsAboveBalanceUpperLimit.clear();
            this._succeeded = false;
        }
        if (!this._brokerIdsUnderBalanceLowerLimit.isEmpty()) {
            LOG.debug("Replica count on broker ids:{} {} under the balance limit of {} after {}.", new Object[]{this._brokerIdsUnderBalanceLowerLimit, this._brokerIdsUnderBalanceLowerLimit.size() > 1 ? "are" : "is", this._balanceLowerLimit, clusterModel.selfHealingEligibleReplicas().isEmpty() ? "rebalance" : "self-healing"});
            this._brokerIdsUnderBalanceLowerLimit.clear();
            this._succeeded = false;
        }
        try {
            GoalUtils.ensureNoOfflineReplicas(clusterModel, this.name());
        }
        catch (OptimizationFailureException ofe) {
            if (this._fixOfflineReplicasOnly) {
                throw ofe;
            }
            this._fixOfflineReplicasOnly = true;
            LOG.info("Ignoring replica balance limit to move replicas from dead brokers/disks.");
            return;
        }
        GoalUtils.ensureReplicasMoveOffBrokersWithBadDisks(clusterModel, this.name());
        this.finish();
    }

    @Override
    public void finish() {
        this._finished = true;
    }

    protected static enum ChangeType {
        ADD,
        REMOVE;

    }
}

