/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals;

import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlUtils;
import com.linkedin.kafka.cruisecontrol.analyzer.ActionAcceptance;
import com.linkedin.kafka.cruisecontrol.analyzer.BalancingAction;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizationOptions;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.Goal;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.model.ClusterModelStats;
import com.linkedin.kafka.cruisecontrol.model.Disk;
import com.linkedin.kafka.cruisecontrol.model.Partition;
import com.linkedin.kafka.cruisecontrol.model.Replica;
import com.linkedin.kafka.cruisecontrol.monitor.ModelCompletenessRequirements;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreferredLeaderElectionGoal
implements Goal {
    private static final Logger LOG = LoggerFactory.getLogger(PreferredLeaderElectionGoal.class);
    private final boolean _skipUrpDemotion;
    private final boolean _excludeFollowerDemotion;
    private Cluster _kafkaCluster;

    public PreferredLeaderElectionGoal() {
        this(false, false, null);
    }

    public PreferredLeaderElectionGoal(boolean skipUrpDemotion, boolean excludeFollowerDemotion, Cluster kafkaCluster) {
        if (skipUrpDemotion && kafkaCluster == null) {
            throw new IllegalArgumentException("Cluster information is not provided.");
        }
        this._skipUrpDemotion = skipUrpDemotion;
        this._excludeFollowerDemotion = excludeFollowerDemotion;
        this._kafkaCluster = kafkaCluster;
    }

    private void sanityCheckOptimizationOptions(OptimizationOptions optimizationOptions) {
        if (optimizationOptions.isTriggeredByGoalViolation()) {
            throw new IllegalArgumentException(String.format("%s goal does not support use by goal violation detector.", this.name()));
        }
    }

    private void maybeMoveReplicaToEndOfReplicaList(Replica replica, ClusterModel clusterModel) {
        if (!(this._skipUrpDemotion && KafkaCruiseControlUtils.isPartitionUnderReplicated(this._kafkaCluster, replica.topicPartition()) || this._excludeFollowerDemotion && !replica.isLeader())) {
            Partition p = clusterModel.partition(replica.topicPartition());
            p.moveReplicaToEnd(replica);
        }
    }

    private void maybeChangeLeadershipForPartition(Set<Replica> leaderReplicas, Set<TopicPartition> partitionsToMove) {
        leaderReplicas.stream().filter(r -> !this._skipUrpDemotion || !KafkaCruiseControlUtils.isPartitionUnderReplicated(this._kafkaCluster, r.topicPartition())).forEach(r -> partitionsToMove.add(r.topicPartition()));
    }

    @Override
    public boolean optimize(ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions) {
        this.sanityCheckOptimizationOptions(optimizationOptions);
        boolean hasBrokerOrDiskToBeDemoted = false;
        HashSet<TopicPartition> partitionsToMove = new HashSet<TopicPartition>();
        for (Broker b : clusterModel.aliveBrokers()) {
            if (b.isDemoted()) {
                hasBrokerOrDiskToBeDemoted = true;
                for (Replica replica : b.replicas()) {
                    this.maybeMoveReplicaToEndOfReplicaList(replica, clusterModel);
                }
                this.maybeChangeLeadershipForPartition(b.leaderReplicas(), partitionsToMove);
                continue;
            }
            for (Disk disk : b.disks()) {
                if (disk.state() != Disk.State.DEMOTED) continue;
                hasBrokerOrDiskToBeDemoted = true;
                for (Replica r : disk.replicas()) {
                    this.maybeMoveReplicaToEndOfReplicaList(r, clusterModel);
                }
                this.maybeChangeLeadershipForPartition(disk.leaderReplicas(), partitionsToMove);
            }
        }
        boolean relocatedLeadership = false;
        Set<Integer> excludedBrokersForLeadership = optimizationOptions.excludedBrokersForLeadership();
        for (List list : clusterModel.getPartitionsByTopic().values()) {
            block5: for (Partition p : list) {
                if (hasBrokerOrDiskToBeDemoted && !partitionsToMove.contains(p.topicPartition())) continue;
                for (int i = 0; i < p.replicas().size() && (hasBrokerOrDiskToBeDemoted || i <= 0); ++i) {
                    Replica r = p.replicas().get(i);
                    Broker leaderCandidate = r.broker();
                    if (!leaderCandidate.isAlive()) continue;
                    if (r.isCurrentOffline()) {
                        LOG.warn("The preferred replica of partition {} on broker {} is offline.", (Object)p.topicPartition(), (Object)leaderCandidate);
                        continue;
                    }
                    if (!r.isLeader()) {
                        if (excludedBrokersForLeadership.contains(leaderCandidate.id())) {
                            LOG.warn("Skipped leadership transfer of partition {} to broker {} because it is among brokers excluded for leadership {}.", new Object[]{p.topicPartition(), leaderCandidate, excludedBrokersForLeadership});
                            continue;
                        }
                        clusterModel.relocateLeadership(r.topicPartition(), p.leader().broker().id(), leaderCandidate.id());
                        relocatedLeadership = true;
                    }
                    if (clusterModel.demotedBrokers().contains(leaderCandidate)) {
                        LOG.warn("The leader of partition {} has to be on a demoted broker {} because all the alive replicas are demoted.", (Object)p.topicPartition(), (Object)leaderCandidate.id());
                    }
                    if (r.disk() == null || r.disk().state() != Disk.State.DEMOTED) continue block5;
                    LOG.warn("The leader of partition {} has to be on a demoted disk {} of broker {} because all the alive replicas are demoted.", new Object[]{p.topicPartition(), r.disk().logDir(), leaderCandidate.id()});
                    continue block5;
                }
            }
        }
        this.finish();
        return relocatedLeadership;
    }

    @Override
    public ActionAcceptance actionAcceptance(BalancingAction action, ClusterModel clusterModel) {
        return ActionAcceptance.ACCEPT;
    }

    @Override
    public Goal.ClusterModelStatsComparator clusterModelStatsComparator() {
        return new Goal.ClusterModelStatsComparator(){

            @Override
            public int compare(ClusterModelStats stats1, ClusterModelStats stats2) {
                return 0;
            }

            @Override
            public String explainLastComparison() {
                return String.format("Comparison for the %s is irrelevant.", PreferredLeaderElectionGoal.this.name());
            }
        };
    }

    @Override
    public ModelCompletenessRequirements clusterModelCompletenessRequirements() {
        return new ModelCompletenessRequirements(1, 0.0, true);
    }

    @Override
    public String name() {
        return PreferredLeaderElectionGoal.class.getSimpleName();
    }

    @Override
    public void finish() {
        this._kafkaCluster = null;
    }

    @Override
    public boolean isHardGoal() {
        return false;
    }

    public void configure(Map<String, ?> configs) {
    }
}

