/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals;

import com.linkedin.kafka.cruisecontrol.analyzer.ActionAcceptance;
import com.linkedin.kafka.cruisecontrol.analyzer.ActionType;
import com.linkedin.kafka.cruisecontrol.analyzer.AnalyzerUtils;
import com.linkedin.kafka.cruisecontrol.analyzer.BalancingAction;
import com.linkedin.kafka.cruisecontrol.analyzer.BalancingConstraint;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizationOptions;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.Goal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.GoalUtils;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.ReplicaDistributionAbstractGoal;
import com.linkedin.kafka.cruisecontrol.common.Statistic;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.model.ClusterModelStats;
import com.linkedin.kafka.cruisecontrol.model.Replica;
import com.linkedin.kafka.cruisecontrol.model.ReplicaSortFunctionFactory;
import com.linkedin.kafka.cruisecontrol.model.SortedReplicasHelper;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeaderReplicaDistributionGoal
extends ReplicaDistributionAbstractGoal {
    private static final Logger LOG = LoggerFactory.getLogger(LeaderReplicaDistributionGoal.class);

    public LeaderReplicaDistributionGoal() {
    }

    public LeaderReplicaDistributionGoal(BalancingConstraint balancingConstraint) {
        this();
        this._balancingConstraint = balancingConstraint;
    }

    @Override
    int numInterestedReplicas(ClusterModel clusterModel) {
        return clusterModel.numLeaderReplicas();
    }

    @Override
    double balancePercentage() {
        return this._balancingConstraint.leaderReplicaBalancePercentage();
    }

    @Override
    public ActionAcceptance actionAcceptance(BalancingAction action, ClusterModel clusterModel) {
        Broker sourceBroker = clusterModel.broker(action.sourceBrokerId());
        Replica sourceReplica = sourceBroker.replica(action.topicPartition());
        Broker destinationBroker = clusterModel.broker(action.destinationBrokerId());
        switch (action.balancingAction()) {
            case INTER_BROKER_REPLICA_SWAP: {
                Replica destinationReplica = destinationBroker.replica(action.destinationTopicPartition());
                if (sourceReplica.isLeader() && !destinationReplica.isLeader()) {
                    return this.isLeaderMovementSatisfiable(sourceBroker, destinationBroker);
                }
                if (!sourceReplica.isLeader() && destinationReplica.isLeader()) {
                    return this.isLeaderMovementSatisfiable(destinationBroker, sourceBroker);
                }
                return ActionAcceptance.ACCEPT;
            }
            case INTER_BROKER_REPLICA_MOVEMENT: {
                if (sourceReplica.isLeader()) {
                    return this.isLeaderMovementSatisfiable(sourceBroker, destinationBroker);
                }
                return ActionAcceptance.ACCEPT;
            }
            case LEADERSHIP_MOVEMENT: {
                return this.isLeaderMovementSatisfiable(sourceBroker, destinationBroker);
            }
        }
        throw new IllegalArgumentException("Unsupported balancing action " + action.balancingAction() + " is provided.");
    }

    private ActionAcceptance isLeaderMovementSatisfiable(Broker sourceBroker, Broker destinationBroker) {
        return this.isReplicaCountUnderBalanceUpperLimitAfterChange(destinationBroker, destinationBroker.leaderReplicas().size(), ReplicaDistributionAbstractGoal.ChangeType.ADD) && this.isReplicaCountAboveBalanceLowerLimitAfterChange(sourceBroker, sourceBroker.leaderReplicas().size(), ReplicaDistributionAbstractGoal.ChangeType.REMOVE) ? ActionAcceptance.ACCEPT : ActionAcceptance.REPLICA_REJECT;
    }

    @Override
    public Goal.ClusterModelStatsComparator clusterModelStatsComparator() {
        return new LeaderReplicaDistributionGoalStatsComparator();
    }

    @Override
    public String name() {
        return LeaderReplicaDistributionGoal.class.getSimpleName();
    }

    @Override
    protected void rebalanceForBroker(Broker broker, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions) {
        boolean requireLessReplicas;
        LOG.debug("Rebalancing broker {} [limits] lower: {} upper: {}.", new Object[]{broker.id(), this._balanceLowerLimit, this._balanceUpperLimit});
        int numLeaderReplicas = broker.leaderReplicas().size();
        boolean requireLessLeaderReplicas = broker.isAlive() && numLeaderReplicas > this._balanceUpperLimit;
        boolean requireMoreLeaderReplicas = broker.isAlive() && numLeaderReplicas < this._balanceLowerLimit;
        boolean bl = requireLessReplicas = this._fixOfflineReplicasOnly && broker.currentOfflineReplicas().size() > 0;
        if ((requireLessLeaderReplicas && this.rebalanceByMovingLeadershipOut(broker, clusterModel, optimizedGoals, optimizationOptions) || requireLessReplicas) && this.rebalanceByMovingReplicasOut(broker, clusterModel, optimizedGoals, optimizationOptions)) {
            if (!requireLessReplicas) {
                this._brokerIdsAboveBalanceUpperLimit.add(broker.id());
                LOG.debug("Failed to sufficiently decrease leader replica count in broker {}. Leader replicas: {}.", (Object)broker.id(), (Object)broker.leaderReplicas().size());
            }
        } else if (requireMoreLeaderReplicas && this.rebalanceByMovingLeadershipIn(broker, clusterModel, optimizedGoals, optimizationOptions) && this.rebalanceByMovingLeaderReplicasIn(broker, clusterModel, optimizedGoals, optimizationOptions)) {
            this._brokerIdsUnderBalanceLowerLimit.add(broker.id());
            LOG.debug("Failed to sufficiently increase leader replica count in broker {}. Leader replicas: {}.", (Object)broker.id(), (Object)broker.leaderReplicas().size());
        }
    }

    private boolean rebalanceByMovingLeadershipOut(Broker broker, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions) {
        if (!clusterModel.deadBrokers().isEmpty()) {
            return true;
        }
        int numLeaderReplicas = broker.leaderReplicas().size();
        Set<String> excludedTopics = optimizationOptions.excludedTopics();
        for (Replica leader : new HashSet<Replica>(broker.leaderReplicas())) {
            Set<Broker> candidateBrokers;
            Broker b2;
            if (excludedTopics.contains(leader.topicPartition().topic()) || (b2 = this.maybeApplyBalancingAction(clusterModel, leader, candidateBrokers = clusterModel.partition(leader.topicPartition()).partitionBrokers().stream().filter(b -> b != broker && !b.replica(leader.topicPartition()).isCurrentOffline()).collect(Collectors.toSet()), ActionType.LEADERSHIP_MOVEMENT, optimizedGoals, optimizationOptions)) == null || --numLeaderReplicas > this._balanceUpperLimit) continue;
            return false;
        }
        return true;
    }

    private boolean rebalanceByMovingLeadershipIn(Broker broker, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions) {
        if (!clusterModel.deadBrokers().isEmpty() || optimizationOptions.excludedBrokersForLeadership().contains(broker.id())) {
            return true;
        }
        int numLeaderReplicas = broker.leaderReplicas().size();
        Set<Broker> candidateBrokers = Collections.singleton(broker);
        Set<String> excludedTopics = optimizationOptions.excludedTopics();
        for (Replica replica : broker.replicas()) {
            Broker b;
            if (replica.isLeader() || replica.isCurrentOffline() || excludedTopics.contains(replica.topicPartition().topic()) || (b = this.maybeApplyBalancingAction(clusterModel, clusterModel.partition(replica.topicPartition()).leader(), candidateBrokers, ActionType.LEADERSHIP_MOVEMENT, optimizedGoals, optimizationOptions)) == null || ++numLeaderReplicas < this._balanceLowerLimit) continue;
            return false;
        }
        return true;
    }

    private boolean rebalanceByMovingReplicasOut(Broker broker, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions) {
        TreeSet<Broker> candidateBrokers;
        if (this._fixOfflineReplicasOnly) {
            candidateBrokers = new TreeSet<Broker>(Comparator.comparingInt(b -> b.replicas().size()).thenComparingInt(Broker::id));
            candidateBrokers.addAll(clusterModel.aliveBrokers());
        } else {
            candidateBrokers = new TreeSet<Broker>(Comparator.comparingInt(b -> b.leaderReplicas().size()).thenComparingInt(Broker::id));
            candidateBrokers.addAll(clusterModel.aliveBrokers().stream().filter(b -> b.leaderReplicas().size() < this._balanceUpperLimit).collect(Collectors.toSet()));
        }
        int balanceUpperLimit = this._fixOfflineReplicasOnly ? 0 : this._balanceUpperLimit;
        Set<String> excludedTopics = optimizationOptions.excludedTopics();
        String replicaSortName = GoalUtils.replicaSortName(this, false, !this._fixOfflineReplicasOnly);
        new SortedReplicasHelper().maybeAddSelectionFunc(ReplicaSortFunctionFactory.selectLeaders(), !this._fixOfflineReplicasOnly).maybeAddSelectionFunc(ReplicaSortFunctionFactory.selectOfflineReplicas(), this._fixOfflineReplicasOnly).maybeAddSelectionFunc(ReplicaSortFunctionFactory.selectImmigrants(), !this._fixOfflineReplicasOnly && !clusterModel.selfHealingEligibleReplicas().isEmpty() || optimizationOptions.onlyMoveImmigrantReplicas()).addSelectionFunc(ReplicaSortFunctionFactory.selectReplicasBasedOnExcludedTopics(excludedTopics)).trackSortedReplicasFor(replicaSortName, broker);
        SortedSet<Replica> candidateReplicas = broker.trackedSortedReplicas(replicaSortName).sortedReplicas(true);
        int numReplicas = candidateReplicas.size();
        for (Replica replica : candidateReplicas) {
            Broker b2 = this.maybeApplyBalancingAction(clusterModel, replica, candidateBrokers, ActionType.INTER_BROKER_REPLICA_MOVEMENT, optimizedGoals, optimizationOptions);
            if (b2 == null) continue;
            if (--numReplicas <= balanceUpperLimit) {
                broker.untrackSortedReplicas(replicaSortName);
                return false;
            }
            candidateBrokers.remove(b2);
            if (b2.leaderReplicas().size() >= this._balanceUpperLimit && !this._fixOfflineReplicasOnly) continue;
            candidateBrokers.add(b2);
        }
        broker.untrackSortedReplicas(replicaSortName);
        return true;
    }

    private boolean rebalanceByMovingLeaderReplicasIn(Broker broker, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions) {
        if (optimizationOptions.excludedBrokersForLeadership().contains(broker.id())) {
            return true;
        }
        PriorityQueue<Broker> eligibleBrokers = new PriorityQueue<Broker>((b1, b2) -> {
            int result = Integer.compare(b2.leaderReplicas().size(), b1.leaderReplicas().size());
            return result == 0 ? Integer.compare(b1.id(), b2.id()) : result;
        });
        for (Broker aliveBroker : clusterModel.aliveBrokers()) {
            if (aliveBroker.leaderReplicas().size() <= this._balanceLowerLimit) continue;
            eligibleBrokers.add(aliveBroker);
        }
        List<Broker> candidateBrokers = Collections.singletonList(broker);
        Set<String> excludedTopics = optimizationOptions.excludedTopics();
        boolean onlyMoveImmigrantReplicas = optimizationOptions.onlyMoveImmigrantReplicas();
        String replicaSortName = GoalUtils.replicaSortName(this, false, true);
        new SortedReplicasHelper().addSelectionFunc(ReplicaSortFunctionFactory.selectLeaders()).maybeAddSelectionFunc(ReplicaSortFunctionFactory.selectImmigrants(), !clusterModel.brokenBrokers().isEmpty() || onlyMoveImmigrantReplicas).addSelectionFunc(ReplicaSortFunctionFactory.selectReplicasBasedOnExcludedTopics(excludedTopics)).trackSortedReplicasFor(replicaSortName, clusterModel);
        int numLeaderReplicas = broker.leaderReplicas().size();
        block1: while (!eligibleBrokers.isEmpty()) {
            Broker sourceBroker = (Broker)eligibleBrokers.poll();
            for (Replica replica : sourceBroker.trackedSortedReplicas(replicaSortName).sortedReplicas(true)) {
                Broker b = this.maybeApplyBalancingAction(clusterModel, replica, candidateBrokers, ActionType.INTER_BROKER_REPLICA_MOVEMENT, optimizedGoals, optimizationOptions);
                if (b == null) continue;
                if (++numLeaderReplicas >= this._balanceLowerLimit) {
                    clusterModel.untrackSortedReplicas(replicaSortName);
                    return false;
                }
                if (eligibleBrokers.isEmpty() || sourceBroker.leaderReplicas().size() >= ((Broker)eligibleBrokers.peek()).leaderReplicas().size()) continue;
                eligibleBrokers.add(sourceBroker);
                continue block1;
            }
        }
        clusterModel.untrackSortedReplicas(replicaSortName);
        return true;
    }

    private class LeaderReplicaDistributionGoalStatsComparator
    implements Goal.ClusterModelStatsComparator {
        private String _reasonForLastNegativeResult;

        private LeaderReplicaDistributionGoalStatsComparator() {
        }

        @Override
        public int compare(ClusterModelStats stats1, ClusterModelStats stats2) {
            double stDev1 = stats1.leaderReplicaStats().get((Object)Statistic.ST_DEV).doubleValue();
            double stDev2 = stats2.leaderReplicaStats().get((Object)Statistic.ST_DEV).doubleValue();
            int result = AnalyzerUtils.compare(stDev2, stDev1, 1.0E-5);
            if (result < 0) {
                this._reasonForLastNegativeResult = String.format("Violated %s. [Std Deviation of Leader Replica Distribution] post-optimization:%.3f pre-optimization:%.3f", LeaderReplicaDistributionGoal.this.name(), stDev1, stDev2);
            }
            return result;
        }

        @Override
        public String explainLastComparison() {
            return this._reasonForLastNegativeResult;
        }
    }
}

