/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals;

import com.linkedin.kafka.cruisecontrol.analyzer.ActionAcceptance;
import com.linkedin.kafka.cruisecontrol.analyzer.ActionType;
import com.linkedin.kafka.cruisecontrol.analyzer.BalancingAction;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizationOptions;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.AbstractGoal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.Goal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.GoalUtils;
import com.linkedin.kafka.cruisecontrol.exception.OptimizationFailureException;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.model.Replica;
import com.linkedin.kafka.cruisecontrol.monitor.ModelCompletenessRequirements;
import java.util.Set;
import java.util.SortedSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRackAwareGoal
extends AbstractGoal {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRackAwareGoal.class);

    @Override
    public Goal.ClusterModelStatsComparator clusterModelStatsComparator() {
        return new GoalUtils.HardGoalStatsComparator();
    }

    @Override
    public ModelCompletenessRequirements clusterModelCompletenessRequirements() {
        return new ModelCompletenessRequirements(1, 0.0, true);
    }

    @Override
    protected SortedSet<Broker> brokersToBalance(ClusterModel clusterModel) {
        return clusterModel.brokers();
    }

    @Override
    public boolean isHardGoal() {
        return true;
    }

    @Override
    protected boolean selfSatisfied(ClusterModel clusterModel, BalancingAction action) {
        return true;
    }

    @Override
    public void finish() {
        this._finished = true;
    }

    @Override
    public ActionAcceptance actionAcceptance(BalancingAction action, ClusterModel clusterModel) {
        switch (action.balancingAction()) {
            case LEADERSHIP_MOVEMENT: {
                return ActionAcceptance.ACCEPT;
            }
            case INTER_BROKER_REPLICA_MOVEMENT: 
            case INTER_BROKER_REPLICA_SWAP: {
                if (this.doesReplicaMoveViolateActionAcceptance(clusterModel, clusterModel.broker(action.sourceBrokerId()).replica(action.topicPartition()), clusterModel.broker(action.destinationBrokerId()))) {
                    return ActionAcceptance.BROKER_REJECT;
                }
                if (action.balancingAction() == ActionType.INTER_BROKER_REPLICA_SWAP && this.doesReplicaMoveViolateActionAcceptance(clusterModel, clusterModel.broker(action.destinationBrokerId()).replica(action.destinationTopicPartition()), clusterModel.broker(action.sourceBrokerId()))) {
                    return ActionAcceptance.REPLICA_REJECT;
                }
                return ActionAcceptance.ACCEPT;
            }
        }
        throw new IllegalArgumentException("Unsupported balancing action " + action.balancingAction() + " is provided.");
    }

    protected abstract boolean doesReplicaMoveViolateActionAcceptance(ClusterModel var1, Replica var2, Broker var3);

    protected void rebalanceForBroker(Broker broker, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions, boolean throwExceptionIfCannotMove) throws OptimizationFailureException {
        for (Replica replica : broker.trackedSortedReplicas(GoalUtils.replicaSortName(this, false, false)).sortedReplicas(true)) {
            SortedSet<Broker> eligibleBrokers;
            if (broker.isAlive() && !broker.currentOfflineReplicas().contains(replica) && this.shouldKeepInTheCurrentRack(replica, clusterModel) || this.maybeApplyBalancingAction(clusterModel, replica, eligibleBrokers = this.rackAwareEligibleBrokers(replica, clusterModel), ActionType.INTER_BROKER_REPLICA_MOVEMENT, optimizedGoals, optimizationOptions) != null) continue;
            if (throwExceptionIfCannotMove) {
                throw new OptimizationFailureException(String.format("Cannot move replica %s to any broker in %s", replica, eligibleBrokers));
            }
            LOG.debug("Cannot move replica {} to any broker in {}", (Object)replica, eligibleBrokers);
        }
    }

    protected abstract boolean shouldKeepInTheCurrentRack(Replica var1, ClusterModel var2);

    protected abstract SortedSet<Broker> rackAwareEligibleBrokers(Replica var1, ClusterModel var2);
}

