/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals;

import com.linkedin.kafka.cruisecontrol.analyzer.ActionAcceptance;
import com.linkedin.kafka.cruisecontrol.analyzer.ActionType;
import com.linkedin.kafka.cruisecontrol.analyzer.AnalyzerUtils;
import com.linkedin.kafka.cruisecontrol.analyzer.BalancingAction;
import com.linkedin.kafka.cruisecontrol.analyzer.BalancingConstraint;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizationOptions;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.Goal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.GoalUtils;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.exception.OptimizationFailureException;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.model.ClusterModelStats;
import com.linkedin.kafka.cruisecontrol.model.Disk;
import com.linkedin.kafka.cruisecontrol.model.Replica;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGoal
implements Goal {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractGoal.class);
    protected boolean _finished = false;
    protected boolean _succeeded = true;
    protected BalancingConstraint _balancingConstraint;
    protected int _numWindows;
    protected double _minMonitoredPartitionPercentage;

    public void configure(Map<String, ?> configs) {
        KafkaCruiseControlConfig parsedConfig = new KafkaCruiseControlConfig(configs, false);
        this._balancingConstraint = new BalancingConstraint(parsedConfig);
        this._numWindows = parsedConfig.getInt("num.partition.metrics.windows");
        this._minMonitoredPartitionPercentage = parsedConfig.getDouble("min.valid.partition.ratio");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean optimize(ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions) throws OptimizationFailureException {
        try {
            Goal.ClusterModelStatsComparator comparator;
            this._succeeded = true;
            LOG.debug("Starting optimization for {}.", (Object)this.name());
            ClusterModelStats statsBeforeOptimization = clusterModel.getClusterStats(this._balancingConstraint);
            LOG.trace("[PRE - {}] {}", (Object)this.name(), (Object)statsBeforeOptimization);
            this._finished = false;
            long goalStartTime = System.currentTimeMillis();
            this.initGoalState(clusterModel, optimizationOptions);
            SortedSet<Broker> brokenBrokers = clusterModel.brokenBrokers();
            while (!this._finished) {
                for (Broker broker : this.brokersToBalance(clusterModel)) {
                    this.rebalanceForBroker(broker, clusterModel, optimizedGoals, optimizationOptions);
                }
                this.updateGoalState(clusterModel, optimizationOptions);
            }
            ClusterModelStats statsAfterOptimization = clusterModel.getClusterStats(this._balancingConstraint);
            LOG.trace("[POST - {}] {}", (Object)this.name(), (Object)statsAfterOptimization);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Finished optimization for {} in {}ms.", (Object)this.name(), (Object)(System.currentTimeMillis() - goalStartTime));
            }
            LOG.trace("Cluster after optimization is {}", (Object)clusterModel);
            if (brokenBrokers.isEmpty() && (comparator = this.clusterModelStatsComparator()).compare(statsAfterOptimization, statsBeforeOptimization) < 0) {
                String mitigation = GoalUtils.mitigationForOptimizationFailures(optimizationOptions);
                throw new OptimizationFailureException(String.format("Optimization for goal %s failed because the optimized result is worse than before. Detailed reason: %s. %s", this.name(), comparator.explainLastComparison(), mitigation));
            }
            boolean bl = this._succeeded;
            return bl;
        }
        finally {
            clusterModel.clearSortedReplicas();
        }
    }

    @Override
    public abstract String name();

    protected abstract SortedSet<Broker> brokersToBalance(ClusterModel var1);

    protected abstract boolean selfSatisfied(ClusterModel var1, BalancingAction var2);

    protected abstract void initGoalState(ClusterModel var1, OptimizationOptions var2) throws OptimizationFailureException;

    protected abstract void updateGoalState(ClusterModel var1, OptimizationOptions var2) throws OptimizationFailureException;

    protected abstract void rebalanceForBroker(Broker var1, ClusterModel var2, Set<Goal> var3, OptimizationOptions var4) throws OptimizationFailureException;

    protected Broker maybeApplyBalancingAction(ClusterModel clusterModel, Replica replica, Collection<Broker> candidateBrokers, ActionType action, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions) {
        if (!clusterModel.deadBrokers().isEmpty() && replica.originalBroker().isAlive() || !clusterModel.brokersWithBadDisks().isEmpty() && !replica.isOriginalOffline()) {
            LOG.trace("Applying {} to an online replica in in self-healing mode.", (Object)action);
        }
        List<Broker> eligibleBrokers = GoalUtils.eligibleBrokers(clusterModel, replica, candidateBrokers, action, optimizationOptions);
        for (Broker broker : eligibleBrokers) {
            BalancingAction proposal = new BalancingAction(replica.topicPartition(), replica.broker().id(), broker.id(), action);
            if (!GoalUtils.legitMove(replica, broker, clusterModel, action)) {
                LOG.trace("Replica move to broker is not legit for {}.", (Object)proposal);
                continue;
            }
            if (!this.selfSatisfied(clusterModel, proposal)) {
                LOG.trace("Unable to self-satisfy proposal {}.", (Object)proposal);
                continue;
            }
            ActionAcceptance acceptance = AnalyzerUtils.isProposalAcceptableForOptimizedGoals(optimizedGoals, proposal, clusterModel);
            LOG.trace("Trying to apply legit and self-satisfied action {}, actionAcceptance = {}", (Object)proposal, (Object)acceptance);
            if (acceptance != ActionAcceptance.ACCEPT) continue;
            if (action == ActionType.LEADERSHIP_MOVEMENT) {
                clusterModel.relocateLeadership(replica.topicPartition(), replica.broker().id(), broker.id());
            } else if (action == ActionType.INTER_BROKER_REPLICA_MOVEMENT) {
                clusterModel.relocateReplica(replica.topicPartition(), replica.broker().id(), broker.id());
            }
            return broker;
        }
        return null;
    }

    Replica maybeApplySwapAction(ClusterModel clusterModel, Replica sourceReplica, SortedSet<Replica> candidateReplicas, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions) {
        SortedSet<Replica> eligibleReplicas = GoalUtils.eligibleReplicasForSwap(clusterModel, sourceReplica, candidateReplicas, optimizationOptions);
        if (eligibleReplicas.isEmpty()) {
            return null;
        }
        Broker destinationBroker = eligibleReplicas.first().broker();
        for (Replica destinationReplica : eligibleReplicas) {
            BalancingAction swapProposal = new BalancingAction(sourceReplica.topicPartition(), sourceReplica.broker().id(), destinationBroker.id(), ActionType.INTER_BROKER_REPLICA_SWAP, destinationReplica.topicPartition());
            if (!GoalUtils.legitMove(sourceReplica, destinationBroker, clusterModel, ActionType.INTER_BROKER_REPLICA_MOVEMENT)) {
                LOG.trace("Swap from source to destination broker is not legit for {}.", (Object)swapProposal);
                return null;
            }
            if (!GoalUtils.legitMove(destinationReplica, sourceReplica.broker(), clusterModel, ActionType.INTER_BROKER_REPLICA_MOVEMENT)) {
                LOG.trace("Swap from destination to source broker is not legit for {}.", (Object)swapProposal);
                continue;
            }
            if (!this.selfSatisfied(clusterModel, swapProposal)) {
                LOG.trace("Unable to self-satisfy swap proposal {}.", (Object)swapProposal);
                return null;
            }
            ActionAcceptance acceptance = AnalyzerUtils.isProposalAcceptableForOptimizedGoals(optimizedGoals, swapProposal, clusterModel);
            LOG.trace("Trying to apply legit and self-satisfied swap {}, actionAcceptance = {}.", (Object)swapProposal, (Object)acceptance);
            if (acceptance == ActionAcceptance.ACCEPT) {
                Broker sourceBroker = sourceReplica.broker();
                clusterModel.relocateReplica(sourceReplica.topicPartition(), sourceBroker.id(), destinationBroker.id());
                clusterModel.relocateReplica(destinationReplica.topicPartition(), destinationBroker.id(), sourceBroker.id());
                return destinationReplica;
            }
            if (acceptance != ActionAcceptance.BROKER_REJECT) continue;
            return null;
        }
        return null;
    }

    protected Disk maybeMoveReplicaBetweenDisks(ClusterModel clusterModel, Replica replica, Collection<Disk> candidateDisks, Set<Goal> optimizedGoals) {
        for (Disk disk : candidateDisks) {
            BalancingAction proposal = new BalancingAction(replica.topicPartition(), replica.disk(), disk, ActionType.INTRA_BROKER_REPLICA_MOVEMENT);
            if (!GoalUtils.legitMoveBetweenDisks(replica, disk, ActionType.INTRA_BROKER_REPLICA_MOVEMENT)) {
                LOG.trace("Replica move to disk is not legit for {}.", (Object)proposal);
                continue;
            }
            if (!this.selfSatisfied(clusterModel, proposal)) {
                LOG.trace("Unable to self-satisfy proposal {}.", (Object)proposal);
                continue;
            }
            ActionAcceptance acceptance = AnalyzerUtils.isProposalAcceptableForOptimizedGoals(optimizedGoals, proposal, clusterModel);
            LOG.trace("Trying to apply legit and self-satisfied action {}, actionAcceptance = {}", (Object)proposal, (Object)acceptance);
            if (acceptance != ActionAcceptance.ACCEPT) continue;
            clusterModel.relocateReplica(replica.topicPartition(), replica.broker().id(), disk.logDir());
            return disk;
        }
        return null;
    }

    Replica maybeSwapReplicaBetweenDisks(ClusterModel clusterModel, Replica sourceReplica, SortedSet<Replica> candidateReplicas, Set<Goal> optimizedGoals) {
        for (Replica destinationReplica : candidateReplicas) {
            BalancingAction swapProposal = new BalancingAction(sourceReplica.topicPartition(), sourceReplica.disk(), destinationReplica.disk(), ActionType.INTRA_BROKER_REPLICA_SWAP, destinationReplica.topicPartition());
            if (!GoalUtils.legitMoveBetweenDisks(sourceReplica, destinationReplica.disk(), ActionType.INTRA_BROKER_REPLICA_MOVEMENT)) {
                LOG.trace("Swap from source to destination disk is not legit for {}.", (Object)swapProposal);
                return null;
            }
            if (!GoalUtils.legitMoveBetweenDisks(destinationReplica, sourceReplica.disk(), ActionType.INTRA_BROKER_REPLICA_MOVEMENT)) {
                LOG.trace("Swap from destination to source disk is not legit for {}.", (Object)swapProposal);
                continue;
            }
            if (!this.selfSatisfied(clusterModel, swapProposal)) {
                LOG.trace("Unable to self-satisfy swap proposal {}.", (Object)swapProposal);
                return null;
            }
            ActionAcceptance acceptance = AnalyzerUtils.isProposalAcceptableForOptimizedGoals(optimizedGoals, swapProposal, clusterModel);
            LOG.trace("Trying to apply legit and self-satisfied swap {}, actionAcceptance = {}.", (Object)swapProposal, (Object)acceptance);
            if (acceptance != ActionAcceptance.ACCEPT) continue;
            clusterModel.relocateReplica(sourceReplica.topicPartition(), sourceReplica.broker().id(), destinationReplica.disk().logDir());
            clusterModel.relocateReplica(destinationReplica.topicPartition(), destinationReplica.broker().id(), sourceReplica.disk().logDir());
            return destinationReplica;
        }
        return null;
    }

    public String toString() {
        return this.name();
    }
}

