/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer;

import com.linkedin.kafka.cruisecontrol.analyzer.OptimizationOptions;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.Goal;
import com.linkedin.kafka.cruisecontrol.executor.ExecutionProposal;
import com.linkedin.kafka.cruisecontrol.model.ClusterModelStats;
import com.linkedin.kafka.cruisecontrol.monitor.ModelGeneration;
import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseClass;
import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseField;
import com.linkedin.kafka.cruisecontrol.servlet.response.stats.BrokerStats;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@JsonResponseClass
public class OptimizerResult {
    @JsonResponseField
    private static final String NUM_INTER_BROKER_REPLICA_MOVEMENTS = "numReplicaMovements";
    @JsonResponseField
    private static final String INTER_BROKER_DATA_TO_MOVE_MB = "dataToMoveMB";
    @JsonResponseField
    private static final String NUM_INTRA_BROKER_REPLICA_MOVEMENTS = "numIntraBrokerReplicaMovements";
    @JsonResponseField
    private static final String INTRA_BROKER_DATA_TO_MOVE_MB = "intraBrokerDataToMoveMB";
    @JsonResponseField
    private static final String NUM_LEADER_MOVEMENTS = "numLeaderMovements";
    @JsonResponseField
    private static final String RECENT_WINDOWS = "recentWindows";
    @JsonResponseField
    private static final String MONITORED_PARTITIONS_PERCENTAGE = "monitoredPartitionsPercentage";
    @JsonResponseField
    private static final String EXCLUDED_TOPICS = "excludedTopics";
    @JsonResponseField
    private static final String EXCLUDED_BROKERS_FOR_LEADERSHIP = "excludedBrokersForLeadership";
    @JsonResponseField
    private static final String EXCLUDED_BROKERS_FOR_REPLICA_MOVE = "excludedBrokersForReplicaMove";
    @JsonResponseField
    private static final String ON_DEMAND_BALANCEDNESS_SCORE_AFTER = "onDemandBalancednessScoreAfter";
    @JsonResponseField
    private static final String ON_DEMAND_BALANCEDNESS_SCORE_BEFORE = "onDemandBalancednessScoreBefore";
    private static final String VIOLATED = "VIOLATED";
    private static final String FIXED = "FIXED";
    private static final String NO_ACTION = "NO-ACTION";
    private final Map<String, Goal.ClusterModelStatsComparator> _clusterModelStatsComparatorByGoalName;
    private final LinkedHashMap<String, ClusterModelStats> _statsByGoalName;
    private final Set<ExecutionProposal> _proposals;
    private final Set<String> _violatedGoalNamesBeforeOptimization;
    private final Set<String> _violatedGoalNamesAfterOptimization;
    private final BrokerStats _brokerStatsBeforeOptimization;
    private final BrokerStats _brokerStatsAfterOptimization;
    private final ModelGeneration _modelGeneration;
    private final ClusterModelStats _clusterModelStats;
    private final Map<Integer, String> _capacityEstimationInfoByBrokerId;
    private final OptimizationOptions _optimizationOptions;
    private final double _onDemandBalancednessScoreBefore;
    private final double _onDemandBalancednessScoreAfter;

    OptimizerResult(LinkedHashMap<Goal, ClusterModelStats> statsByGoalPriority, Set<String> violatedGoalNamesBeforeOptimization, Set<String> violatedGoalNamesAfterOptimization, Set<ExecutionProposal> proposals, BrokerStats brokerStatsBeforeOptimization, BrokerStats brokerStatsAfterOptimization, ModelGeneration modelGeneration, ClusterModelStats clusterModelStats, Map<Integer, String> capacityEstimationInfoByBrokerId, OptimizationOptions optimizationOptions, Map<String, Double> balancednessCostByGoal) {
        this._clusterModelStatsComparatorByGoalName = new LinkedHashMap<String, Goal.ClusterModelStatsComparator>(statsByGoalPriority.size());
        this._statsByGoalName = new LinkedHashMap(statsByGoalPriority.size());
        for (Map.Entry<Goal, ClusterModelStats> entry : statsByGoalPriority.entrySet()) {
            String goalName = entry.getKey().name();
            Goal.ClusterModelStatsComparator comparator = entry.getKey().clusterModelStatsComparator();
            this._clusterModelStatsComparatorByGoalName.put(goalName, comparator);
            this._statsByGoalName.put(goalName, entry.getValue());
        }
        this._violatedGoalNamesBeforeOptimization = violatedGoalNamesBeforeOptimization;
        this._violatedGoalNamesAfterOptimization = violatedGoalNamesAfterOptimization;
        this._proposals = proposals;
        this._brokerStatsBeforeOptimization = brokerStatsBeforeOptimization;
        this._brokerStatsAfterOptimization = brokerStatsAfterOptimization;
        this._modelGeneration = modelGeneration;
        this._clusterModelStats = clusterModelStats;
        this._capacityEstimationInfoByBrokerId = capacityEstimationInfoByBrokerId;
        this._optimizationOptions = optimizationOptions;
        this._onDemandBalancednessScoreBefore = this.onDemandBalancednessScore(balancednessCostByGoal, this._violatedGoalNamesBeforeOptimization);
        this._onDemandBalancednessScoreAfter = this.onDemandBalancednessScore(balancednessCostByGoal, this._violatedGoalNamesAfterOptimization);
    }

    private double onDemandBalancednessScore(Map<String, Double> balancednessCostByGoal, Set<String> violatedGoals) {
        double onDemandBalancednessScore = 100.0;
        for (String goalName : this._statsByGoalName.keySet()) {
            if (!violatedGoals.contains(goalName)) continue;
            onDemandBalancednessScore -= balancednessCostByGoal.get(goalName).doubleValue();
        }
        return onDemandBalancednessScore;
    }

    public Map<String, Goal.ClusterModelStatsComparator> clusterModelStatsComparatorByGoalName() {
        return this._clusterModelStatsComparatorByGoalName;
    }

    public LinkedHashMap<String, ClusterModelStats> statsByGoalName() {
        return this._statsByGoalName;
    }

    public Set<ExecutionProposal> goalProposals() {
        return this._proposals;
    }

    public Set<String> violatedGoalsBeforeOptimization() {
        return this._violatedGoalNamesBeforeOptimization;
    }

    public Set<String> violatedGoalsAfterOptimization() {
        return this._violatedGoalNamesAfterOptimization;
    }

    public ModelGeneration modelGeneration() {
        return this._modelGeneration;
    }

    public ClusterModelStats clusterModelStats() {
        return this._clusterModelStats;
    }

    public BrokerStats brokerStatsBeforeOptimization() {
        return this._brokerStatsBeforeOptimization;
    }

    public BrokerStats brokerStatsAfterOptimization() {
        return this._brokerStatsAfterOptimization;
    }

    public boolean isCapacityEstimated() {
        return !this._capacityEstimationInfoByBrokerId.isEmpty();
    }

    public Map<Integer, String> capacityEstimationInfoByBrokerId() {
        return Collections.unmodifiableMap(this._capacityEstimationInfoByBrokerId);
    }

    public Set<String> excludedTopics() {
        return this._optimizationOptions.excludedTopics();
    }

    public Set<Integer> excludedBrokersForLeadership() {
        return this._optimizationOptions.excludedBrokersForLeadership();
    }

    public Set<Integer> excludedBrokersForReplicaMove() {
        return this._optimizationOptions.excludedBrokersForReplicaMove();
    }

    public String goalResultDescription(String goalName) {
        return this._violatedGoalNamesBeforeOptimization.contains(goalName) ? (this._violatedGoalNamesAfterOptimization.contains(goalName) ? VIOLATED : FIXED) : NO_ACTION;
    }

    public Set<String> topicsWithReplicationFactorChange() {
        HashSet<String> topics = new HashSet<String>(this._proposals.size());
        this._proposals.stream().filter(p -> p.newReplicas().size() != p.oldReplicas().size()).forEach(p -> topics.add(p.topic()));
        return topics;
    }

    private List<Number> getMovementStats() {
        int numInterBrokerReplicaMovements = 0;
        int numIntraBrokerReplicaMovements = 0;
        int numLeadershipMovements = 0;
        long interBrokerDataToMove = 0L;
        long intraBrokerDataToMove = 0L;
        for (ExecutionProposal p : this._proposals) {
            if (!p.replicasToAdd().isEmpty() || !p.replicasToRemove().isEmpty()) {
                ++numInterBrokerReplicaMovements;
                interBrokerDataToMove += p.interBrokerDataToMoveInMB();
                continue;
            }
            if (!p.replicasToMoveBetweenDisksByBroker().isEmpty()) {
                numIntraBrokerReplicaMovements += p.replicasToMoveBetweenDisksByBroker().size();
                intraBrokerDataToMove += p.intraBrokerDataToMoveInMB() * (long)p.replicasToMoveBetweenDisksByBroker().size();
                continue;
            }
            ++numLeadershipMovements;
        }
        return Arrays.asList(numInterBrokerReplicaMovements, interBrokerDataToMove, numIntraBrokerReplicaMovements, intraBrokerDataToMove, numLeadershipMovements);
    }

    public String getProposalSummary() {
        List<Number> moveStats = this.getMovementStats();
        return String.format("%n%nOptimization has %d inter-broker replica(%d MB) moves, %d intra-broker replica(%d MB) moves and %d leadership moves with a cluster model of %d recent windows and %.3f%% of the partitions covered.%nExcluded Topics: %s.%nExcluded Brokers For Leadership: %s.%nExcluded Brokers For Replica Move: %s.%nCounts: %s%nOn-demand Balancedness Score Before (%.3f) After(%.3f).", moveStats.get(0).intValue(), moveStats.get(1).longValue(), moveStats.get(2).intValue(), moveStats.get(3).longValue(), moveStats.get(4).intValue(), this._clusterModelStats.numWindows(), this._clusterModelStats.monitoredPartitionsPercentage(), this.excludedTopics(), this.excludedBrokersForLeadership(), this.excludedBrokersForReplicaMove(), this._clusterModelStats.toStringCounts(), this._onDemandBalancednessScoreBefore, this._onDemandBalancednessScoreAfter);
    }

    public Map<String, Object> getProposalSummaryForJson() {
        List<Number> moveStats = this.getMovementStats();
        HashMap<String, Object> ret = new HashMap<String, Object>(12);
        ret.put(NUM_INTER_BROKER_REPLICA_MOVEMENTS, moveStats.get(0).intValue());
        ret.put(INTER_BROKER_DATA_TO_MOVE_MB, moveStats.get(1).longValue());
        ret.put(NUM_INTRA_BROKER_REPLICA_MOVEMENTS, moveStats.get(2).intValue());
        ret.put(INTRA_BROKER_DATA_TO_MOVE_MB, moveStats.get(3).longValue());
        ret.put(NUM_LEADER_MOVEMENTS, moveStats.get(4).intValue());
        ret.put(RECENT_WINDOWS, this._clusterModelStats.numWindows());
        ret.put(MONITORED_PARTITIONS_PERCENTAGE, this._clusterModelStats.monitoredPartitionsPercentage());
        ret.put(EXCLUDED_TOPICS, this.excludedTopics());
        ret.put(EXCLUDED_BROKERS_FOR_LEADERSHIP, this.excludedBrokersForLeadership());
        ret.put(EXCLUDED_BROKERS_FOR_REPLICA_MOVE, this.excludedBrokersForReplicaMove());
        ret.put(ON_DEMAND_BALANCEDNESS_SCORE_BEFORE, this._onDemandBalancednessScoreBefore);
        ret.put(ON_DEMAND_BALANCEDNESS_SCORE_AFTER, this._onDemandBalancednessScoreAfter);
        return ret;
    }
}

