/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer;

import java.util.Collections;
import java.util.Set;

public class OptimizationOptions {
    private final Set<String> _excludedTopics;
    private final Set<Integer> _excludedBrokersForLeadership;
    private final Set<Integer> _excludedBrokersForReplicaMove;
    private final boolean _isTriggeredByGoalViolation;
    private final Set<Integer> _requestedDestinationBrokerIds;
    private final boolean _onlyMoveImmigrantReplicas;

    public OptimizationOptions(Set<String> excludedTopics) {
        this(excludedTopics, Collections.emptySet());
    }

    public OptimizationOptions(Set<String> excludedTopics, Set<Integer> excludedBrokersForLeadership) {
        this(excludedTopics, excludedBrokersForLeadership, Collections.emptySet());
    }

    public OptimizationOptions(Set<String> excludedTopics, Set<Integer> excludedBrokersForLeadership, Set<Integer> excludedBrokersForReplicaMove) {
        this(excludedTopics, excludedBrokersForLeadership, excludedBrokersForReplicaMove, false);
    }

    public OptimizationOptions(Set<String> excludedTopics, Set<Integer> excludedBrokersForLeadership, Set<Integer> excludedBrokersForReplicaMove, boolean isTriggeredByGoalViolation) {
        this(excludedTopics, excludedBrokersForLeadership, excludedBrokersForReplicaMove, isTriggeredByGoalViolation, Collections.emptySet());
    }

    public OptimizationOptions(Set<String> excludedTopics, Set<Integer> excludedBrokersForLeadership, Set<Integer> excludedBrokersForReplicaMove, boolean isTriggeredByGoalViolation, Set<Integer> requestedDestinationBrokerIds) {
        this(excludedTopics, excludedBrokersForLeadership, excludedBrokersForReplicaMove, isTriggeredByGoalViolation, requestedDestinationBrokerIds, false);
    }

    public OptimizationOptions(Set<String> excludedTopics, Set<Integer> excludedBrokersForLeadership, Set<Integer> excludedBrokersForReplicaMove, boolean isTriggeredByGoalViolation, Set<Integer> requestedDestinationBrokerIds, boolean onlyMoveImmigrantReplicas) {
        this._excludedTopics = excludedTopics;
        this._excludedBrokersForLeadership = excludedBrokersForLeadership;
        this._excludedBrokersForReplicaMove = excludedBrokersForReplicaMove;
        this._isTriggeredByGoalViolation = isTriggeredByGoalViolation;
        this._requestedDestinationBrokerIds = requestedDestinationBrokerIds;
        this._onlyMoveImmigrantReplicas = onlyMoveImmigrantReplicas;
    }

    public Set<String> excludedTopics() {
        return Collections.unmodifiableSet(this._excludedTopics);
    }

    public Set<Integer> excludedBrokersForLeadership() {
        return Collections.unmodifiableSet(this._excludedBrokersForLeadership);
    }

    public Set<Integer> excludedBrokersForReplicaMove() {
        return Collections.unmodifiableSet(this._excludedBrokersForReplicaMove);
    }

    public boolean isTriggeredByGoalViolation() {
        return this._isTriggeredByGoalViolation;
    }

    public Set<Integer> requestedDestinationBrokerIds() {
        return Collections.unmodifiableSet(this._requestedDestinationBrokerIds);
    }

    public boolean onlyMoveImmigrantReplicas() {
        return this._onlyMoveImmigrantReplicas;
    }

    public String toString() {
        return String.format("[excludedTopics=%s,excludedBrokersForLeadership=%s,excludedBrokersForReplicaMove=%s,isTriggeredByGoalViolation=%s,requestedDestinationBrokerIds=%s,onlyMoveImmigrantReplicas=%s]", this._excludedTopics, this._excludedBrokersForLeadership, this._excludedBrokersForReplicaMove, this._isTriggeredByGoalViolation, this._requestedDestinationBrokerIds, this._onlyMoveImmigrantReplicas);
    }
}

