/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer;

import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class BalancingConstraint {
    private final List<Resource> _resources = Collections.unmodifiableList(Arrays.asList(Resource.DISK, Resource.NW_IN, Resource.NW_OUT, Resource.CPU));
    private final Map<Resource, Double> _resourceBalancePercentage = new HashMap<Resource, Double>(this._resources.size());
    private final Double _replicaBalancePercentage;
    private final Double _leaderReplicaBalancePercentage;
    private final Double _topicReplicaBalancePercentage;
    private final Double _goalViolationDistributionThresholdMultiplier;
    private final Map<Resource, Double> _capacityThreshold = new HashMap<Resource, Double>(this._resources.size());
    private final Map<Resource, Double> _lowUtilizationThreshold = new HashMap<Resource, Double>(this._resources.size());
    private final Long _maxReplicasPerBroker;

    public BalancingConstraint(KafkaCruiseControlConfig config) {
        this._resourceBalancePercentage.put(Resource.DISK, config.getDouble("disk.balance.threshold"));
        this._resourceBalancePercentage.put(Resource.CPU, config.getDouble("cpu.balance.threshold"));
        this._resourceBalancePercentage.put(Resource.NW_IN, config.getDouble("network.inbound.balance.threshold"));
        this._resourceBalancePercentage.put(Resource.NW_OUT, config.getDouble("network.outbound.balance.threshold"));
        this._capacityThreshold.put(Resource.DISK, config.getDouble("disk.capacity.threshold"));
        this._capacityThreshold.put(Resource.CPU, config.getDouble("cpu.capacity.threshold"));
        this._capacityThreshold.put(Resource.NW_IN, config.getDouble("network.inbound.capacity.threshold"));
        this._capacityThreshold.put(Resource.NW_OUT, config.getDouble("network.outbound.capacity.threshold"));
        this._lowUtilizationThreshold.put(Resource.DISK, config.getDouble("disk.low.utilization.threshold"));
        this._lowUtilizationThreshold.put(Resource.CPU, config.getDouble("cpu.low.utilization.threshold"));
        this._lowUtilizationThreshold.put(Resource.NW_IN, config.getDouble("network.inbound.low.utilization.threshold"));
        this._lowUtilizationThreshold.put(Resource.NW_OUT, config.getDouble("network.outbound.low.utilization.threshold"));
        this._maxReplicasPerBroker = config.getLong("max.replicas.per.broker");
        this._replicaBalancePercentage = config.getDouble("replica.count.balance.threshold");
        this._leaderReplicaBalancePercentage = config.getDouble("leader.replica.count.balance.threshold");
        this._topicReplicaBalancePercentage = config.getDouble("topic.replica.count.balance.threshold");
        this._goalViolationDistributionThresholdMultiplier = config.getDouble("goal.violation.distribution.threshold.multiplier");
    }

    Properties setProps(Properties props) {
        props.put("disk.balance.threshold", this._resourceBalancePercentage.get((Object)Resource.DISK).toString());
        props.put("cpu.balance.threshold", this._resourceBalancePercentage.get((Object)Resource.CPU).toString());
        props.put("network.inbound.balance.threshold", this._resourceBalancePercentage.get((Object)Resource.NW_IN).toString());
        props.put("network.outbound.balance.threshold", this._resourceBalancePercentage.get((Object)Resource.NW_OUT).toString());
        props.put("disk.capacity.threshold", this._capacityThreshold.get((Object)Resource.DISK).toString());
        props.put("cpu.capacity.threshold", this._capacityThreshold.get((Object)Resource.CPU).toString());
        props.put("network.inbound.capacity.threshold", this._capacityThreshold.get((Object)Resource.NW_IN).toString());
        props.put("network.outbound.capacity.threshold", this._capacityThreshold.get((Object)Resource.NW_OUT).toString());
        props.put("disk.low.utilization.threshold", this._lowUtilizationThreshold.get((Object)Resource.DISK).toString());
        props.put("cpu.low.utilization.threshold", this._lowUtilizationThreshold.get((Object)Resource.CPU).toString());
        props.put("network.inbound.low.utilization.threshold", this._lowUtilizationThreshold.get((Object)Resource.NW_IN).toString());
        props.put("network.outbound.low.utilization.threshold", this._lowUtilizationThreshold.get((Object)Resource.NW_OUT).toString());
        props.put("max.replicas.per.broker", this._maxReplicasPerBroker.toString());
        props.put("replica.count.balance.threshold", this._replicaBalancePercentage.toString());
        props.put("leader.replica.count.balance.threshold", this._leaderReplicaBalancePercentage.toString());
        props.put("topic.replica.count.balance.threshold", this._topicReplicaBalancePercentage.toString());
        props.put("goal.violation.distribution.threshold.multiplier", this._goalViolationDistributionThresholdMultiplier.toString());
        return props;
    }

    public List<Resource> resources() {
        return this._resources;
    }

    public Long maxReplicasPerBroker() {
        return this._maxReplicasPerBroker;
    }

    public Double replicaBalancePercentage() {
        return this._replicaBalancePercentage;
    }

    public Double leaderReplicaBalancePercentage() {
        return this._leaderReplicaBalancePercentage;
    }

    public Double topicReplicaBalancePercentage() {
        return this._topicReplicaBalancePercentage;
    }

    public Double goalViolationDistributionThresholdMultiplier() {
        return this._goalViolationDistributionThresholdMultiplier;
    }

    public double resourceBalancePercentage(Resource resource) {
        return this._resourceBalancePercentage.get((Object)resource);
    }

    public double capacityThreshold(Resource resource) {
        return this._capacityThreshold.get((Object)resource);
    }

    public double lowUtilizationThreshold(Resource resource) {
        return this._lowUtilizationThreshold.get((Object)resource);
    }

    private void setBalancePercentageFor(Resource resource, double balancePercentage) {
        if (balancePercentage < 1.0) {
            throw new IllegalArgumentException("Balance Percentage cannot be less than 1.0");
        }
        this._resourceBalancePercentage.put(resource, balancePercentage);
    }

    void setResourceBalancePercentage(double resourceBalancePercentage) {
        for (Resource resource : this._resources) {
            this.setBalancePercentageFor(resource, resourceBalancePercentage);
        }
    }

    private void setCapacityThresholdFor(Resource resource, double capacityThreshold) {
        if (capacityThreshold <= 0.0 || capacityThreshold > 1.0) {
            throw new IllegalArgumentException("Capacity Threshold must be in (0, 1].");
        }
        this._capacityThreshold.put(resource, capacityThreshold);
    }

    void setCapacityThreshold(double capacityThreshold) {
        for (Resource resource : this._resources) {
            this.setCapacityThresholdFor(resource, capacityThreshold);
        }
    }

    public String toString() {
        return String.format("BalancingConstraint[cpuBalancePercentage=%.4f,diskBalancePercentage=%.4f,inboundNwBalancePercentage=%.4f,outboundNwBalancePercentage=%.4f,cpuCapacityThreshold=%.4f,diskCapacityThreshold=%.4f,inboundNwCapacityThreshold=%.4f,outboundNwCapacityThreshold=%.4f,maxReplicasPerBroker=%d,replicaBalancePercentage=%.4f,leaderReplicaBalancePercentage=%.4f,topicReplicaBalancePercentage=%.4f,goalViolationDistributionThresholdMultiplier=%.4f]", this._resourceBalancePercentage.get((Object)Resource.CPU), this._resourceBalancePercentage.get((Object)Resource.DISK), this._resourceBalancePercentage.get((Object)Resource.NW_IN), this._resourceBalancePercentage.get((Object)Resource.NW_OUT), this._capacityThreshold.get((Object)Resource.CPU), this._capacityThreshold.get((Object)Resource.DISK), this._capacityThreshold.get((Object)Resource.NW_IN), this._capacityThreshold.get((Object)Resource.NW_OUT), this._maxReplicasPerBroker, this._replicaBalancePercentage, this._leaderReplicaBalancePercentage, this._topicReplicaBalancePercentage, this._goalViolationDistributionThresholdMultiplier);
    }
}

