/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer;

import com.linkedin.kafka.cruisecontrol.analyzer.ActionType;
import com.linkedin.kafka.cruisecontrol.model.Disk;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.TopicPartition;

public class BalancingAction {
    private static final String TOPIC_PARTITION = "topicPartition";
    private static final String SOURCE_BROKER_ID = "sourceBrokerId";
    private static final String SOURCE_BROKER_LOGDIR = "sourceBrokerLogdir";
    private static final String DESTINATION_BROKER_ID = "destinationBrokerId";
    private static final String DESTINATION_BROKER_LOGIR = "destinationBrokerLogdir";
    private static final String DESTINATION_TOPIC_PARTITION = "destinationTopicPartition";
    private static final String ACTION_TYPE = "actionType";
    private final TopicPartition _tp;
    private final Integer _sourceBrokerId;
    private final String _sourceBrokerLogdir;
    private final String _destinationBrokerLogdir;
    private final Integer _destinationBrokerId;
    private final ActionType _actionType;
    private final TopicPartition _destinationTp;

    public BalancingAction(TopicPartition tp, Integer sourceBrokerId, Integer destinationBrokerId, ActionType actionType) {
        this(tp, sourceBrokerId, destinationBrokerId, actionType, tp);
    }

    public BalancingAction(TopicPartition sourceTp, Integer sourceBrokerId, Integer destinationBrokerId, ActionType actionType, TopicPartition destinationTp) {
        this(sourceTp, sourceBrokerId, null, destinationBrokerId, null, actionType, destinationTp);
    }

    public BalancingAction(TopicPartition tp, Disk sourceDisk, Disk destinationDisk, ActionType actionType) {
        this(tp, sourceDisk.broker().id(), sourceDisk.logDir(), destinationDisk.broker().id(), destinationDisk.logDir(), actionType, tp);
    }

    public BalancingAction(TopicPartition sourceTp, Disk sourceDisk, Disk destinationDisk, ActionType actionType, TopicPartition destinationTp) {
        this(sourceTp, sourceDisk.broker().id(), sourceDisk.logDir(), destinationDisk.broker().id(), destinationDisk.logDir(), actionType, destinationTp);
    }

    private BalancingAction(TopicPartition sourceTp, Integer sourceBrokerId, String sourceBrokerLogdir, Integer destinationBrokerId, String destinationBrokerLogdir, ActionType actionType, TopicPartition destinationTp) {
        this._tp = sourceTp;
        this._sourceBrokerId = sourceBrokerId;
        this._sourceBrokerLogdir = sourceBrokerLogdir;
        this._destinationBrokerId = destinationBrokerId;
        this._destinationBrokerLogdir = destinationBrokerLogdir;
        this._actionType = actionType;
        this._destinationTp = destinationTp;
        this.validate();
    }

    private void validate() {
        switch (this._actionType) {
            case REPLICA_ADDITION: {
                if (this._destinationBrokerId == null) {
                    throw new IllegalArgumentException("The destination broker cannot be null for balancing action " + this);
                }
                if (this._sourceBrokerId == null) break;
                throw new IllegalArgumentException("The source broker should be null for balancing action " + this);
            }
            case REPLICA_DELETION: {
                if (this._destinationBrokerId != null) {
                    throw new IllegalArgumentException("The destination broker should be null for balancing action " + this);
                }
                if (this._sourceBrokerId != null) break;
                throw new IllegalArgumentException("The source broker cannot be null for balancing action " + this);
            }
            case INTER_BROKER_REPLICA_MOVEMENT: 
            case LEADERSHIP_MOVEMENT: 
            case INTER_BROKER_REPLICA_SWAP: {
                if (this._destinationBrokerId == null) {
                    throw new IllegalArgumentException("The destination broker cannot be null for balancing action " + this);
                }
                if (this._sourceBrokerId != null) break;
                throw new IllegalArgumentException("The source broker cannot be null for balancing action " + this);
            }
            case INTRA_BROKER_REPLICA_MOVEMENT: 
            case INTRA_BROKER_REPLICA_SWAP: {
                if (this._destinationBrokerId == null) {
                    throw new IllegalArgumentException("The destination broker cannot be null for balancing action " + this);
                }
                if (this._sourceBrokerId == null) {
                    throw new IllegalArgumentException("The source broker cannot be null for balancing action " + this);
                }
                if (this._sourceBrokerLogdir == null) {
                    throw new IllegalArgumentException("The source disk cannot be null for balancing action " + this);
                }
                if (this._destinationBrokerLogdir == null) {
                    throw new IllegalArgumentException("The destination disk cannot be null for balancing action " + this);
                }
                if (this._sourceBrokerId.equals(this._destinationBrokerId)) break;
                throw new IllegalArgumentException("Replica movement between disks across broker is not supported for balancing action " + this);
            }
            default: {
                throw new IllegalStateException("Should never be here");
            }
        }
    }

    public TopicPartition destinationTopicPartition() {
        return this._destinationTp;
    }

    public String destinationTopic() {
        return this._destinationTp.topic();
    }

    public int partitionId() {
        return this._tp.partition();
    }

    public String topic() {
        return this._tp.topic();
    }

    public TopicPartition topicPartition() {
        return this._tp;
    }

    public String sourceBrokerLogdir() {
        return this._sourceBrokerLogdir;
    }

    public String destinationBrokerLogdir() {
        return this._destinationBrokerLogdir;
    }

    public Integer sourceBrokerId() {
        return this._sourceBrokerId;
    }

    public Integer destinationBrokerId() {
        return this._destinationBrokerId;
    }

    public ActionType balancingAction() {
        return this._actionType;
    }

    public Map<String, Object> getJsonStructure() {
        HashMap<String, Object> proposalMap = new HashMap<String, Object>();
        proposalMap.put(TOPIC_PARTITION, this._tp);
        proposalMap.put(SOURCE_BROKER_ID, this._sourceBrokerId);
        proposalMap.put(DESTINATION_BROKER_ID, this._destinationBrokerId);
        proposalMap.put(DESTINATION_TOPIC_PARTITION, this._destinationTp);
        proposalMap.put(ACTION_TYPE, (Object)this._actionType);
        if (this._sourceBrokerLogdir != null) {
            proposalMap.put(SOURCE_BROKER_LOGDIR, this._sourceBrokerLogdir);
            proposalMap.put(DESTINATION_BROKER_LOGIR, this._destinationBrokerLogdir);
        }
        return proposalMap;
    }

    public String toString() {
        String actSymbol = this._actionType.equals((Object)ActionType.INTER_BROKER_REPLICA_SWAP) || this._actionType.equals((Object)ActionType.INTRA_BROKER_REPLICA_SWAP) ? "<->" : "->";
        return String.format("(%s%s%s, %d%s%s%d%s, %s)", new Object[]{this._tp, actSymbol, this._destinationTp, this._sourceBrokerId, this._sourceBrokerLogdir == null ? "" : String.format("(%s)", this._sourceBrokerLogdir), actSymbol, this._destinationBrokerId, this._destinationBrokerLogdir == null ? "" : String.format("(%s)", this._destinationBrokerLogdir), this._actionType});
    }

    public boolean equals(Object other) {
        if (!(other instanceof BalancingAction)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        BalancingAction otherAction = (BalancingAction)other;
        return Objects.equals(this._sourceBrokerId, otherAction._sourceBrokerId) && Objects.equals(this._sourceBrokerLogdir, otherAction._sourceBrokerLogdir) && Objects.equals(this._tp, otherAction._tp) && Objects.equals(this._destinationBrokerId, otherAction._destinationBrokerId) && Objects.equals(this._destinationBrokerLogdir, otherAction._destinationBrokerLogdir) && Objects.equals(this._destinationTp, otherAction._destinationTp) && Objects.equals((Object)this._actionType, (Object)otherAction._actionType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this._tp, this._sourceBrokerId, this._sourceBrokerLogdir, this._destinationBrokerId, this._destinationBrokerLogdir, this._actionType, this._destinationTp});
    }
}

