/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer;

import com.linkedin.kafka.cruisecontrol.analyzer.ActionAcceptance;
import com.linkedin.kafka.cruisecontrol.analyzer.BalancingAction;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.Goal;
import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.executor.ExecutionProposal;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.model.RawAndDerivedResource;
import com.linkedin.kafka.cruisecontrol.model.Replica;
import com.linkedin.kafka.cruisecontrol.model.ReplicaPlacementInfo;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.math3.random.MersenneTwister;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.stat.inference.KolmogorovSmirnovTest;
import org.apache.kafka.common.TopicPartition;

public class AnalyzerUtils {
    public static final double EPSILON = 1.0E-5;

    private AnalyzerUtils() {
    }

    public static Set<ExecutionProposal> getDiff(Map<TopicPartition, List<ReplicaPlacementInfo>> initialReplicaDistribution, Map<TopicPartition, ReplicaPlacementInfo> initialLeaderDistribution, ClusterModel optimizedClusterModel) {
        return AnalyzerUtils.getDiff(initialReplicaDistribution, initialLeaderDistribution, optimizedClusterModel, false);
    }

    public static Set<ExecutionProposal> getDiff(Map<TopicPartition, List<ReplicaPlacementInfo>> initialReplicaDistribution, Map<TopicPartition, ReplicaPlacementInfo> initialLeaderDistribution, ClusterModel optimizedClusterModel, boolean skipReplicationFactorChangeCheck) {
        Map<TopicPartition, List<ReplicaPlacementInfo>> finalDistribution = optimizedClusterModel.getReplicaDistribution();
        if (!initialReplicaDistribution.keySet().equals(finalDistribution.keySet())) {
            throw new IllegalArgumentException("Attempt to diff distributions with different partitions.");
        }
        if (!skipReplicationFactorChangeCheck) {
            for (Map.Entry<TopicPartition, List<ReplicaPlacementInfo>> entry : initialReplicaDistribution.entrySet()) {
                TopicPartition tp = entry.getKey();
                List<ReplicaPlacementInfo> initialReplicas = entry.getValue();
                if (finalDistribution.get(tp).size() == initialReplicas.size()) continue;
                throw new IllegalArgumentException("Attempt to diff distributions with modified replication factor.");
            }
        }
        HashSet<ExecutionProposal> diff = new HashSet<ExecutionProposal>();
        for (Map.Entry<TopicPartition, List<ReplicaPlacementInfo>> entry : initialReplicaDistribution.entrySet()) {
            TopicPartition tp = entry.getKey();
            List<ReplicaPlacementInfo> initialReplicas = entry.getValue();
            List<ReplicaPlacementInfo> finalReplicas = finalDistribution.get(tp);
            Replica finalLeader = optimizedClusterModel.partition(tp).leader();
            ReplicaPlacementInfo finalLeaderPlacementInfo = new ReplicaPlacementInfo(finalLeader.broker().id(), finalLeader.disk() == null ? null : finalLeader.disk().logDir());
            if (finalReplicas.equals(initialReplicas) && initialLeaderDistribution.get(tp).equals(finalLeaderPlacementInfo)) continue;
            if (finalLeaderPlacementInfo != finalReplicas.get(0)) {
                int leaderPos = finalReplicas.indexOf(finalLeaderPlacementInfo);
                finalReplicas.set(leaderPos, finalReplicas.get(0));
                finalReplicas.set(0, finalLeaderPlacementInfo);
            }
            Double partitionSize = optimizedClusterModel.partition(tp).leader().load().expectedUtilizationFor(Resource.DISK);
            diff.add(new ExecutionProposal(tp, partitionSize.intValue(), initialLeaderDistribution.get(tp), initialReplicas, finalReplicas));
        }
        return diff;
    }

    public static ActionAcceptance isProposalAcceptableForOptimizedGoals(Set<Goal> optimizedGoals, BalancingAction proposal, ClusterModel clusterModel) {
        for (Goal optimizedGoal : optimizedGoals) {
            ActionAcceptance actionAcceptance = optimizedGoal.actionAcceptance(proposal, clusterModel);
            if (actionAcceptance == ActionAcceptance.ACCEPT) continue;
            return actionAcceptance;
        }
        return ActionAcceptance.ACCEPT;
    }

    public static int compare(double d1, double d2, Resource resource) {
        double epsilon = resource.epsilon(d1, d2);
        return AnalyzerUtils.compare(d1, d2, epsilon);
    }

    public static int compare(double d1, double d2, double epsilon) {
        if (d2 - d1 > epsilon) {
            return -1;
        }
        if (d1 - d2 > epsilon) {
            return 1;
        }
        return 0;
    }

    public static List<Goal> getGoalsByPriority(KafkaCruiseControlConfig config) {
        return config.getConfiguredInstances("default.goals", Goal.class);
    }

    public static Map<String, Goal> getCaseInsensitiveGoalsByName(KafkaCruiseControlConfig config) {
        List<Goal> goals = config.getConfiguredInstances("goals", Goal.class);
        goals.addAll(config.getConfiguredInstances("intra.broker.goals", Goal.class));
        TreeMap<String, Goal> caseInsensitiveGoalsByName = new TreeMap<String, Goal>(String.CASE_INSENSITIVE_ORDER);
        for (Goal goal : goals) {
            caseInsensitiveGoalsByName.put(goal.name(), goal);
        }
        return caseInsensitiveGoalsByName;
    }

    public static double[] testDifference(double[][] orig, double[][] optimized) {
        int nResources = RawAndDerivedResource.values().length;
        if (orig.length != nResources) {
            throw new IllegalArgumentException("orig must have number of rows equal to RawAndDerivedResource.");
        }
        if (optimized.length != nResources) {
            throw new IllegalArgumentException("optimized must have number of rows equal to RawAndDerivedResource.");
        }
        if (orig[0].length != optimized[0].length) {
            throw new IllegalArgumentException("The number of brokers must be the same.");
        }
        double[] pValues = new double[orig.length];
        for (int resourceIndex = 0; resourceIndex < nResources; ++resourceIndex) {
            MersenneTwister rng = new MersenneTwister(6706161180467409700L);
            KolmogorovSmirnovTest kolmogorovSmirnovTest = new KolmogorovSmirnovTest((RandomGenerator)rng);
            pValues[resourceIndex] = kolmogorovSmirnovTest.kolmogorovSmirnovTest(orig[resourceIndex], optimized[resourceIndex]);
        }
        return pValues;
    }
}

