/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer;

import com.linkedin.kafka.cruisecontrol.analyzer.GoalReadinessRecord;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.Goal;
import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseClass;
import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

@JsonResponseClass
public class AnalyzerState {
    @JsonResponseField
    private static final String IS_PROPOSAL_READY = "isProposalReady";
    @JsonResponseField
    private static final String READY_GOALS = "readyGoals";
    @JsonResponseField(required=false)
    private static final String GOAL_READINESS = "goalReadiness";
    private static final String READY = "ready";
    private static final String NOT_READY = "notReady";
    private final boolean _isProposalReady;
    private final Map<Goal, Boolean> _readyGoals;

    public AnalyzerState(boolean isProposalReady, Map<Goal, Boolean> readyGoals) {
        this._isProposalReady = isProposalReady;
        this._readyGoals = readyGoals;
    }

    public boolean proposalReady() {
        return this._isProposalReady;
    }

    public Map<Goal, Boolean> readyGoals() {
        return this._readyGoals;
    }

    public Map<String, Object> getJsonStructure(boolean verbose) {
        HashMap<String, Object> analyzerState = new HashMap<String, Object>(verbose ? 3 : 2);
        HashSet<String> readyGoalNames = new HashSet<String>();
        for (Map.Entry<Goal, Boolean> entry : this._readyGoals.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            readyGoalNames.add(entry.getKey().name());
        }
        analyzerState.put(IS_PROPOSAL_READY, this._isProposalReady);
        analyzerState.put(READY_GOALS, readyGoalNames);
        if (verbose) {
            ArrayList<Map<String, Object>> goalReadinessList = new ArrayList<Map<String, Object>>(this._readyGoals.size());
            for (Map.Entry<Goal, Boolean> entry : this._readyGoals.entrySet()) {
                Goal goal = entry.getKey();
                String goalReadyStatus = entry.getValue() != false ? READY : NOT_READY;
                GoalReadinessRecord goalReadinessRecord = new GoalReadinessRecord(goal, goalReadyStatus);
                goalReadinessList.add(goalReadinessRecord.getJsonStructure());
            }
            analyzerState.put(GOAL_READINESS, goalReadinessList);
        }
        return analyzerState;
    }

    public String toString() {
        HashSet<String> readyGoalNames = new HashSet<String>();
        for (Map.Entry<Goal, Boolean> entry : this._readyGoals.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            readyGoalNames.add(entry.getKey().getClass().getSimpleName());
        }
        return String.format("{%s: %s, %s: %s}", IS_PROPOSAL_READY, this._isProposalReady, READY_GOALS, readyGoalNames);
    }
}

